/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.EndpointDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpConnection;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpStreamResetException;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.RequestNotExecutedException;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.impl.BasicEndpointDetails;
import org.apache.hc.core5.http.impl.BasicHttpConnectionMetrics;
import org.apache.hc.core5.http.impl.CharCodingSupport;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.nio.command.CommandSupport;
import org.apache.hc.core5.http.nio.command.ExecutableCommand;
import org.apache.hc.core5.http.nio.command.ShutdownCommand;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http2.H2ConnectionException;
import org.apache.hc.core5.http2.H2Error;
import org.apache.hc.core5.http2.H2StreamResetException;
import org.apache.hc.core5.http2.config.H2Config;
import org.apache.hc.core5.http2.config.H2Config$Builder;
import org.apache.hc.core5.http2.config.H2Param;
import org.apache.hc.core5.http2.config.H2Setting;
import org.apache.hc.core5.http2.frame.Frame;
import org.apache.hc.core5.http2.frame.FrameFactory;
import org.apache.hc.core5.http2.frame.FrameFlag;
import org.apache.hc.core5.http2.frame.FrameType;
import org.apache.hc.core5.http2.frame.RawFrame;
import org.apache.hc.core5.http2.frame.StreamIdGenerator;
import org.apache.hc.core5.http2.hpack.HPackDecoder;
import org.apache.hc.core5.http2.hpack.HPackEncoder;
import org.apache.hc.core5.http2.impl.BasicH2TransportMetrics;
import org.apache.hc.core5.http2.impl.nio.AbstractH2StreamMultiplexer$ConnectionHandshake;
import org.apache.hc.core5.http2.impl.nio.AbstractH2StreamMultiplexer$Continuation;
import org.apache.hc.core5.http2.impl.nio.AbstractH2StreamMultiplexer$H2Stream;
import org.apache.hc.core5.http2.impl.nio.AbstractH2StreamMultiplexer$H2StreamChannelImpl;
import org.apache.hc.core5.http2.impl.nio.AbstractH2StreamMultiplexer$SettingsHandshake;
import org.apache.hc.core5.http2.impl.nio.FrameInputBuffer;
import org.apache.hc.core5.http2.impl.nio.FrameOutputBuffer;
import org.apache.hc.core5.http2.impl.nio.H2StreamChannel;
import org.apache.hc.core5.http2.impl.nio.H2StreamHandler;
import org.apache.hc.core5.http2.impl.nio.H2StreamListener;
import org.apache.hc.core5.http2.impl.nio.NoopH2StreamHandler;
import org.apache.hc.core5.http2.nio.AsyncPingHandler;
import org.apache.hc.core5.http2.nio.command.PingCommand;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.Command$Priority;
import org.apache.hc.core5.reactor.ProtocolIOSession;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.ByteArrayBuffer;
import org.apache.hc.core5.util.Identifiable;
import org.apache.hc.core5.util.Timeout;

abstract class AbstractH2StreamMultiplexer
implements HttpConnection,
Identifiable {
    private static final long LINGER_TIME = 1000L;
    private static final long CONNECTION_WINDOW_LOW_MARK = 0xA00000L;
    private final ProtocolIOSession ioSession;
    private final FrameFactory frameFactory;
    private final StreamIdGenerator idGenerator;
    private final HttpProcessor httpProcessor;
    private final H2Config localConfig;
    private final BasicH2TransportMetrics inputMetrics;
    private final BasicH2TransportMetrics outputMetrics;
    private final BasicHttpConnectionMetrics connMetrics;
    private final FrameInputBuffer inputBuffer;
    private final FrameOutputBuffer outputBuffer;
    private final Deque<RawFrame> outputQueue;
    private final HPackEncoder hPackEncoder;
    private final HPackDecoder hPackDecoder;
    private final Map<Integer, AbstractH2StreamMultiplexer$H2Stream> streamMap;
    private final Queue<AsyncPingHandler> pingHandlers;
    private final AtomicInteger connInputWindow;
    private final AtomicInteger connOutputWindow;
    private final AtomicInteger outputRequests;
    private final AtomicInteger lastStreamId;
    private final H2StreamListener streamListener;
    private AbstractH2StreamMultiplexer$ConnectionHandshake connState = AbstractH2StreamMultiplexer$ConnectionHandshake.READY;
    private AbstractH2StreamMultiplexer$SettingsHandshake localSettingState = AbstractH2StreamMultiplexer$SettingsHandshake.READY;
    private AbstractH2StreamMultiplexer$SettingsHandshake remoteSettingState = AbstractH2StreamMultiplexer$SettingsHandshake.READY;
    private int initInputWinSize;
    private int initOutputWinSize;
    private int lowMark;
    private volatile H2Config remoteConfig;
    private AbstractH2StreamMultiplexer$Continuation continuation;
    private int processedRemoteStreamId;
    private EndpointDetails endpointDetails;
    private boolean goAwayReceived;

    AbstractH2StreamMultiplexer(ProtocolIOSession protocolIOSession, FrameFactory frameFactory, StreamIdGenerator streamIdGenerator, HttpProcessor httpProcessor, CharCodingConfig charCodingConfig, H2Config h2Config, H2StreamListener h2StreamListener) {
        this.ioSession = Args.notNull(protocolIOSession, "IO session");
        this.frameFactory = Args.notNull(frameFactory, "Frame factory");
        this.idGenerator = Args.notNull(streamIdGenerator, "Stream id generator");
        this.httpProcessor = Args.notNull(httpProcessor, "HTTP processor");
        this.localConfig = h2Config != null ? h2Config : H2Config.DEFAULT;
        this.inputMetrics = new BasicH2TransportMetrics();
        this.outputMetrics = new BasicH2TransportMetrics();
        this.connMetrics = new BasicHttpConnectionMetrics(this.inputMetrics, this.outputMetrics);
        this.inputBuffer = new FrameInputBuffer(this.inputMetrics, this.localConfig.getMaxFrameSize());
        this.outputBuffer = new FrameOutputBuffer(this.outputMetrics, this.localConfig.getMaxFrameSize());
        this.outputQueue = new ConcurrentLinkedDeque<RawFrame>();
        this.pingHandlers = new ConcurrentLinkedQueue<AsyncPingHandler>();
        this.outputRequests = new AtomicInteger(0);
        this.lastStreamId = new AtomicInteger(0);
        this.hPackEncoder = new HPackEncoder(H2Config.INIT.getHeaderTableSize(), CharCodingSupport.createEncoder(charCodingConfig));
        this.hPackDecoder = new HPackDecoder(H2Config.INIT.getHeaderTableSize(), CharCodingSupport.createDecoder(charCodingConfig));
        this.streamMap = new ConcurrentHashMap<Integer, AbstractH2StreamMultiplexer$H2Stream>();
        this.remoteConfig = H2Config.INIT;
        this.connInputWindow = new AtomicInteger(H2Config.INIT.getInitialWindowSize());
        this.connOutputWindow = new AtomicInteger(H2Config.INIT.getInitialWindowSize());
        this.initInputWinSize = H2Config.INIT.getInitialWindowSize();
        this.initOutputWinSize = H2Config.INIT.getInitialWindowSize();
        this.hPackDecoder.setMaxListSize(H2Config.INIT.getMaxHeaderListSize());
        this.lowMark = H2Config.INIT.getInitialWindowSize() / 2;
        this.streamListener = h2StreamListener;
    }

    @Override
    public String getId() {
        return this.ioSession.getId();
    }

    abstract void acceptHeaderFrame() throws H2ConnectionException;

    abstract void acceptPushRequest() throws H2ConnectionException;

    abstract void acceptPushFrame() throws H2ConnectionException;

    abstract H2StreamHandler createRemotelyInitiatedStream(H2StreamChannel var1, HttpProcessor var2, BasicHttpConnectionMetrics var3, HandlerFactory<AsyncPushConsumer> var4) throws IOException;

    abstract H2StreamHandler createLocallyInitiatedStream(ExecutableCommand var1, H2StreamChannel var2, HttpProcessor var3, BasicHttpConnectionMetrics var4) throws IOException;

    private int updateWindow(AtomicInteger atomicInteger, int n2) throws ArithmeticException {
        long l2;
        int n3;
        do {
            if (Math.abs(l2 = (long)(n3 = atomicInteger.get()) + (long)n2) <= Integer.MAX_VALUE) continue;
            throw new ArithmeticException("Update causes flow control window to exceed 2147483647");
        } while (!atomicInteger.compareAndSet(n3, (int)l2));
        return (int)l2;
    }

    private int updateWindowMax(AtomicInteger atomicInteger) throws ArithmeticException {
        int n2;
        while (!atomicInteger.compareAndSet(n2 = atomicInteger.get(), Integer.MAX_VALUE)) {
        }
        return Integer.MAX_VALUE - n2;
    }

    private int updateInputWindow(int n2, AtomicInteger atomicInteger, int n3) throws ArithmeticException {
        int n4 = this.updateWindow(atomicInteger, n3);
        if (this.streamListener != null) {
            this.streamListener.onInputFlowControl(this, n2, n3, n4);
        }
        return n4;
    }

    private int updateOutputWindow(int n2, AtomicInteger atomicInteger, int n3) throws ArithmeticException {
        int n4 = this.updateWindow(atomicInteger, n3);
        if (this.streamListener != null) {
            this.streamListener.onOutputFlowControl(this, n2, n3, n4);
        }
        return n4;
    }

    private void commitFrameInternal(RawFrame rawFrame) throws IOException {
        if (this.outputBuffer.isEmpty() && this.outputQueue.isEmpty()) {
            if (this.streamListener != null) {
                this.streamListener.onFrameOutput(this, rawFrame.getStreamId(), rawFrame);
            }
            this.outputBuffer.write(rawFrame, this.ioSession);
        } else {
            this.outputQueue.addLast(rawFrame);
        }
        this.ioSession.setEvent(4);
    }

    private void commitFrame(RawFrame rawFrame) throws IOException {
        Args.notNull(rawFrame, "Frame");
        this.ioSession.getLock().lock();
        try {
            this.commitFrameInternal(rawFrame);
            return;
        }
        finally {
            this.ioSession.getLock().unlock();
        }
    }

    private void commitHeaders(int n2, List<? extends Header> list, boolean bl2) throws IOException {
        if (this.streamListener != null) {
            this.streamListener.onHeaderOutput(this, n2, list);
        }
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(512);
        this.hPackEncoder.encodeHeaders(byteArrayBuffer, list, this.localConfig.isCompressionEnabled());
        int n3 = 0;
        int n4 = byteArrayBuffer.length();
        boolean bl3 = false;
        while (n4 > 0) {
            RawFrame rawFrame;
            int n5 = Math.min(this.remoteConfig.getMaxFrameSize(), n4);
            ByteBuffer byteBuffer = ByteBuffer.wrap(byteArrayBuffer.array(), n3, n5);
            n3 += n5;
            int n6 = n5 = (n4 -= n5) == 0 ? 1 : 0;
            if (!bl3) {
                rawFrame = this.frameFactory.createHeaders(n2, byteBuffer, n5 != 0, bl2);
                bl3 = true;
            } else {
                rawFrame = this.frameFactory.createContinuation(n2, byteBuffer, n5 != 0);
            }
            this.commitFrameInternal(rawFrame);
        }
    }

    private void commitPushPromise(int n2, int n3, List<Header> list) throws IOException {
        if (list == null || list.isEmpty()) {
            throw new H2ConnectionException(H2Error.INTERNAL_ERROR, "Message headers are missing");
        }
        if (this.streamListener != null) {
            this.streamListener.onHeaderOutput(this, n2, list);
        }
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(512);
        byteArrayBuffer.append((byte)(n3 >> 24));
        byteArrayBuffer.append((byte)(n3 >> 16));
        byteArrayBuffer.append((byte)(n3 >> 8));
        byteArrayBuffer.append((byte)n3);
        this.hPackEncoder.encodeHeaders(byteArrayBuffer, list, this.localConfig.isCompressionEnabled());
        n3 = 0;
        int n4 = byteArrayBuffer.length();
        boolean bl2 = false;
        while (n4 > 0) {
            RawFrame rawFrame;
            int n5 = Math.min(this.remoteConfig.getMaxFrameSize(), n4);
            ByteBuffer byteBuffer = ByteBuffer.wrap(byteArrayBuffer.array(), n3, n5);
            n3 += n5;
            int n6 = n5 = (n4 -= n5) == 0 ? 1 : 0;
            if (!bl2) {
                rawFrame = this.frameFactory.createPushPromise(n2, byteBuffer, n5 != 0);
                bl2 = true;
            } else {
                rawFrame = this.frameFactory.createContinuation(n2, byteBuffer, n5 != 0);
            }
            this.commitFrameInternal(rawFrame);
        }
    }

    private void streamDataFrame(int n2, AtomicInteger atomicInteger, ByteBuffer object, int n3) throws IOException {
        object = this.frameFactory.createData(n2, (ByteBuffer)object, false);
        if (this.streamListener != null) {
            this.streamListener.onFrameOutput(this, n2, (RawFrame)object);
        }
        this.updateOutputWindow(0, this.connOutputWindow, -n3);
        this.updateOutputWindow(n2, atomicInteger, -n3);
        this.outputBuffer.write((RawFrame)object, this.ioSession);
    }

    private int streamData(int n2, AtomicInteger atomicInteger, ByteBuffer byteBuffer) throws IOException {
        if (this.outputBuffer.isEmpty() && this.outputQueue.isEmpty()) {
            int n3 = Math.min(this.connOutputWindow.get(), atomicInteger.get());
            if (n3 <= 0) {
                return 0;
            }
            n3 = Math.min(n3, this.outputBuffer.getMaxFramePayloadSize());
            if (byteBuffer.remaining() <= n3) {
                n3 = byteBuffer.remaining();
                this.streamDataFrame(n2, atomicInteger, byteBuffer, n3);
            } else {
                int n4 = byteBuffer.limit();
                try {
                    ByteBuffer byteBuffer2 = byteBuffer;
                    byteBuffer2.limit(byteBuffer2.position() + n3);
                    this.streamDataFrame(n2, atomicInteger, byteBuffer, n3);
                }
                finally {
                    byteBuffer.limit(n4);
                }
            }
            ByteBuffer byteBuffer3 = byteBuffer;
            byteBuffer3.position(byteBuffer3.position() + n3);
            this.ioSession.setEvent(4);
            return n3;
        }
        return 0;
    }

    private void incrementInputCapacity(int n2, AtomicInteger atomicInteger, int n3) throws IOException {
        if (n3 > 0) {
            int n4 = atomicInteger.get();
            if ((n3 = Math.min(n3, n4 = Integer.MAX_VALUE - n4)) != 0) {
                this.updateInputWindow(n2, atomicInteger, n3);
                RawFrame rawFrame = this.frameFactory.createWindowUpdate(n2, n3);
                this.commitFrame(rawFrame);
            }
        }
    }

    private void requestSessionOutput() {
        this.outputRequests.incrementAndGet();
        this.ioSession.setEvent(4);
    }

    private void updateLastStreamId(int n2) {
        int n3 = this.lastStreamId.get();
        if (n2 > n3) {
            this.lastStreamId.compareAndSet(n3, n2);
        }
    }

    private int generateStreamId() {
        int n2;
        int n3;
        while (!this.lastStreamId.compareAndSet(n3 = this.lastStreamId.get(), n2 = this.idGenerator.generate(n3))) {
        }
        return n2;
    }

    public final void onConnect() throws HttpException, IOException {
        this.connState = AbstractH2StreamMultiplexer$ConnectionHandshake.ACTIVE;
        RawFrame rawFrame = this.frameFactory.createSettings(new H2Setting(H2Param.HEADER_TABLE_SIZE, this.localConfig.getHeaderTableSize()), new H2Setting(H2Param.ENABLE_PUSH, this.localConfig.isPushEnabled() ? 1 : 0), new H2Setting(H2Param.MAX_CONCURRENT_STREAMS, this.localConfig.getMaxConcurrentStreams()), new H2Setting(H2Param.INITIAL_WINDOW_SIZE, this.localConfig.getInitialWindowSize()), new H2Setting(H2Param.MAX_FRAME_SIZE, this.localConfig.getMaxFrameSize()), new H2Setting(H2Param.MAX_HEADER_LIST_SIZE, this.localConfig.getMaxHeaderListSize()));
        this.commitFrame(rawFrame);
        this.localSettingState = AbstractH2StreamMultiplexer$SettingsHandshake.TRANSMITTED;
        this.maximizeWindow(0, this.connInputWindow);
        if (this.streamListener != null) {
            int n2;
            int n3 = n2 = this.connInputWindow.get();
            this.streamListener.onInputFlowControl(this, 0, n3, n3);
            int n4 = n2 = this.connOutputWindow.get();
            this.streamListener.onOutputFlowControl(this, 0, n4, n4);
        }
    }

    public final void onInput(ByteBuffer object) throws HttpException, IOException {
        RawFrame rawFrame;
        if (this.connState == AbstractH2StreamMultiplexer$ConnectionHandshake.SHUTDOWN) {
            this.ioSession.clearEvent(1);
            return;
        }
        while ((rawFrame = this.inputBuffer.read((ByteBuffer)object, this.ioSession)) != null) {
            if (this.streamListener != null) {
                this.streamListener.onFrameInput(this, rawFrame.getStreamId(), rawFrame);
            }
            this.consumeFrame(rawFrame);
        }
        if (this.inputBuffer.isEndOfStream()) {
            if (this.connState == AbstractH2StreamMultiplexer$ConnectionHandshake.ACTIVE) {
                object = this.frameFactory.createGoAway(this.processedRemoteStreamId, H2Error.NO_ERROR, "Unexpected end of stream");
                this.commitFrame((RawFrame)object);
            }
            this.connState = AbstractH2StreamMultiplexer$ConnectionHandshake.SHUTDOWN;
            this.requestSessionOutput();
            return;
        }
    }

    public final void onOutput() throws HttpException, IOException {
        this.ioSession.getLock().lock();
        try {
            Object object;
            if (!this.outputBuffer.isEmpty()) {
                this.outputBuffer.flush(this.ioSession);
            }
            while (this.outputBuffer.isEmpty() && (object = this.outputQueue.poll()) != null) {
                if (this.streamListener != null) {
                    this.streamListener.onFrameOutput(this, ((Frame)object).getStreamId(), (RawFrame)object);
                }
                this.outputBuffer.write((RawFrame)object, this.ioSession);
            }
        }
        finally {
            this.ioSession.getLock().unlock();
        }
        if (this.connState.compareTo(AbstractH2StreamMultiplexer$ConnectionHandshake.SHUTDOWN) < 0) {
            if (this.connOutputWindow.get() > 0 && this.remoteSettingState == AbstractH2StreamMultiplexer$SettingsHandshake.ACKED) {
                this.produceOutput();
            }
            int n2 = this.outputRequests.get();
            boolean bl2 = false;
            if (!this.streamMap.isEmpty() && this.connOutputWindow.get() > 0) {
                for (Map.Entry entry : this.streamMap.entrySet()) {
                    AbstractH2StreamMultiplexer$H2Stream object = (AbstractH2StreamMultiplexer$H2Stream)entry.getValue();
                    if (object.isLocalClosed() || object.getOutputWindow().get() <= 0 || !object.isOutputReady()) continue;
                    bl2 = true;
                    break;
                }
            }
            this.ioSession.getLock().lock();
            try {
                if (!bl2 && this.outputBuffer.isEmpty() && this.outputQueue.isEmpty() && this.outputRequests.compareAndSet(n2, 0)) {
                    this.ioSession.clearEvent(4);
                } else {
                    this.outputRequests.addAndGet(-n2);
                }
            }
            finally {
                this.ioSession.getLock().unlock();
            }
        }
        if (this.connState.compareTo(AbstractH2StreamMultiplexer$ConnectionHandshake.ACTIVE) <= 0 && this.remoteSettingState == AbstractH2StreamMultiplexer$SettingsHandshake.ACKED) {
            this.processPendingCommands();
        }
        if (this.connState.compareTo(AbstractH2StreamMultiplexer$ConnectionHandshake.GRACEFUL_SHUTDOWN) == 0) {
            int n3 = 0;
            Iterator<Map.Entry<Integer, AbstractH2StreamMultiplexer$H2Stream>> iterator = this.streamMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Integer, AbstractH2StreamMultiplexer$H2Stream> entry = iterator.next();
                AbstractH2StreamMultiplexer$H2Stream abstractH2StreamMultiplexer$H2Stream = entry.getValue();
                if (abstractH2StreamMultiplexer$H2Stream.isLocalClosed() && abstractH2StreamMultiplexer$H2Stream.isRemoteClosed()) {
                    abstractH2StreamMultiplexer$H2Stream.releaseResources();
                    iterator.remove();
                    continue;
                }
                if (!this.idGenerator.isSameSide(abstractH2StreamMultiplexer$H2Stream.getId()) && abstractH2StreamMultiplexer$H2Stream.getId() > this.processedRemoteStreamId) continue;
                ++n3;
            }
            if (n3 == 0) {
                this.connState = AbstractH2StreamMultiplexer$ConnectionHandshake.SHUTDOWN;
            }
        }
        if (this.connState.compareTo(AbstractH2StreamMultiplexer$ConnectionHandshake.SHUTDOWN) >= 0) {
            if (!this.streamMap.isEmpty()) {
                for (AbstractH2StreamMultiplexer$H2Stream abstractH2StreamMultiplexer$H2Stream : this.streamMap.values()) {
                    if (abstractH2StreamMultiplexer$H2Stream.isLocalClosed() && abstractH2StreamMultiplexer$H2Stream.isRemoteClosed()) {
                        abstractH2StreamMultiplexer$H2Stream.releaseResources();
                        continue;
                    }
                    abstractH2StreamMultiplexer$H2Stream.fail(new ConnectionClosedException());
                }
                this.streamMap.clear();
            }
            this.ioSession.getLock().lock();
            try {
                if (this.outputBuffer.isEmpty() && this.outputQueue.isEmpty()) {
                    this.ioSession.close();
                }
                return;
            }
            finally {
                this.ioSession.getLock().unlock();
            }
        }
    }

    public final void onTimeout(Timeout timeout) throws HttpException, IOException {
        this.connState = AbstractH2StreamMultiplexer$ConnectionHandshake.SHUTDOWN;
        RawFrame rawFrame = this.localSettingState != AbstractH2StreamMultiplexer$SettingsHandshake.ACKED ? this.frameFactory.createGoAway(this.processedRemoteStreamId, H2Error.SETTINGS_TIMEOUT, "Setting timeout (" + timeout + ")") : this.frameFactory.createGoAway(this.processedRemoteStreamId, H2Error.NO_ERROR, "Timeout due to inactivity (" + timeout + ")");
        this.commitFrame(rawFrame);
        for (Map.Entry entry : this.streamMap.entrySet()) {
            AbstractH2StreamMultiplexer$H2Stream object = (AbstractH2StreamMultiplexer$H2Stream)entry.getValue();
            object.fail(new H2StreamResetException(H2Error.NO_ERROR, "Timeout due to inactivity (" + timeout + ")"));
        }
        this.streamMap.clear();
    }

    public final void onDisconnect() {
        Object object;
        while ((object = this.pingHandlers.poll()) != null) {
            object.cancel();
        }
        for (Map.Entry entry : this.streamMap.entrySet()) {
            AbstractH2StreamMultiplexer$H2Stream object2 = (AbstractH2StreamMultiplexer$H2Stream)entry.getValue();
            if (object2.isLocalClosed() && object2.isRemoteClosed()) {
                object2.releaseResources();
                continue;
            }
            object2.fail(new ConnectionClosedException());
        }
        CommandSupport.cancelCommands(this.ioSession);
    }

    private void processPendingCommands() throws IOException, HttpException {
        Command command;
        while (this.streamMap.size() < this.remoteConfig.getMaxConcurrentStreams() && (command = this.ioSession.poll()) != null) {
            Object object;
            Object object2;
            if (command instanceof ShutdownCommand) {
                ShutdownCommand shutdownCommand = (ShutdownCommand)command;
                if (shutdownCommand.getType() == CloseMode.IMMEDIATE) {
                    for (Map.Entry entry : this.streamMap.entrySet()) {
                        object2 = (AbstractH2StreamMultiplexer$H2Stream)entry.getValue();
                        if (((AbstractH2StreamMultiplexer$H2Stream)object2).isLocalClosed() && ((AbstractH2StreamMultiplexer$H2Stream)object2).isRemoteClosed()) {
                            ((AbstractH2StreamMultiplexer$H2Stream)object2).releaseResources();
                            continue;
                        }
                        ((AbstractH2StreamMultiplexer$H2Stream)object2).fail(new ConnectionClosedException());
                    }
                    this.streamMap.clear();
                    this.connState = AbstractH2StreamMultiplexer$ConnectionHandshake.SHUTDOWN;
                    return;
                }
                if (this.connState.compareTo(AbstractH2StreamMultiplexer$ConnectionHandshake.ACTIVE) > 0) break;
                object = this.frameFactory.createGoAway(this.processedRemoteStreamId, H2Error.NO_ERROR, "Graceful shutdown");
                this.commitFrame((RawFrame)object);
                this.connState = this.streamMap.isEmpty() ? AbstractH2StreamMultiplexer$ConnectionHandshake.SHUTDOWN : AbstractH2StreamMultiplexer$ConnectionHandshake.GRACEFUL_SHUTDOWN;
                return;
            }
            if (command instanceof PingCommand) {
                PingCommand pingCommand = (PingCommand)command;
                object = pingCommand.getHandler();
                this.pingHandlers.add((AsyncPingHandler)object);
                RawFrame rawFrame = this.frameFactory.createPing(object.getData());
                this.commitFrame(rawFrame);
                continue;
            }
            if (!(command instanceof ExecutableCommand)) continue;
            int n2 = this.generateStreamId();
            object = new AbstractH2StreamMultiplexer$H2StreamChannelImpl(this, n2, true, this.initInputWinSize, this.initOutputWinSize);
            ExecutableCommand executableCommand = (ExecutableCommand)command;
            object2 = this.createLocallyInitiatedStream(executableCommand, (H2StreamChannel)object, this.httpProcessor, this.connMetrics);
            object = new AbstractH2StreamMultiplexer$H2Stream((AbstractH2StreamMultiplexer$H2StreamChannelImpl)object, (H2StreamHandler)object2, false, null);
            this.streamMap.put(n2, (AbstractH2StreamMultiplexer$H2Stream)object);
            if (this.streamListener != null) {
                int n3;
                int n4 = n3 = ((AbstractH2StreamMultiplexer$H2Stream)object).getInputWindow().get();
                this.streamListener.onInputFlowControl(this, n2, n4, n4);
                int n5 = n3 = ((AbstractH2StreamMultiplexer$H2Stream)object).getOutputWindow().get();
                this.streamListener.onOutputFlowControl(this, n2, n5, n5);
            }
            if (((AbstractH2StreamMultiplexer$H2Stream)object).isOutputReady()) {
                ((AbstractH2StreamMultiplexer$H2Stream)object).produceOutput();
            }
            if ((object2 = executableCommand.getCancellableDependency()) != null) {
                object2.setDependency(((AbstractH2StreamMultiplexer$H2Stream)object)::abort);
            }
            if (this.outputQueue.isEmpty()) continue;
            return;
        }
    }

    public final void onException(Exception object) {
        Object object2;
        try {
            while ((object2 = this.pingHandlers.poll()) != null) {
                object2.failed((Exception)object);
            }
            CommandSupport.cancelCommands(this.ioSession);
            for (Map.Entry entry : this.streamMap.entrySet()) {
                AbstractH2StreamMultiplexer$H2Stream object3 = (AbstractH2StreamMultiplexer$H2Stream)entry.getValue();
                object3.fail((Exception)object);
            }
            this.streamMap.clear();
            if (!(object instanceof ConnectionClosedException) && this.connState.compareTo(AbstractH2StreamMultiplexer$ConnectionHandshake.GRACEFUL_SHUTDOWN) <= 0) {
                object2 = object instanceof H2ConnectionException ? H2Error.getByCode(((H2ConnectionException)object).getCode()) : (object instanceof ProtocolException ? H2Error.PROTOCOL_ERROR : H2Error.INTERNAL_ERROR);
                RawFrame rawFrame = this.frameFactory.createGoAway(this.processedRemoteStreamId, (H2Error)((Object)object2), ((Throwable)object).getMessage());
                this.commitFrame(rawFrame);
            }
            return;
        }
        catch (IOException iOException) {
            return;
        }
        finally {
            this.connState = AbstractH2StreamMultiplexer$ConnectionHandshake.SHUTDOWN;
            object2 = !(object instanceof ConnectionClosedException) && !(object instanceof SSLHandshakeException) && object instanceof IOException ? CloseMode.IMMEDIATE : CloseMode.GRACEFUL;
            this.ioSession.close((CloseMode)((Object)object2));
        }
    }

    private AbstractH2StreamMultiplexer$H2Stream getValidStream(int n2) throws H2ConnectionException {
        if (n2 == 0) {
            throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Illegal stream id: " + n2);
        }
        AbstractH2StreamMultiplexer$H2Stream abstractH2StreamMultiplexer$H2Stream = this.streamMap.get(n2);
        if (abstractH2StreamMultiplexer$H2Stream == null) {
            if (n2 <= this.lastStreamId.get()) {
                throw new H2ConnectionException(H2Error.STREAM_CLOSED, "Stream closed");
            }
            throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Unexpected stream id: " + n2);
        }
        return abstractH2StreamMultiplexer$H2Stream;
    }

    /*
     * WARNING - void declaration
     */
    private void consumeFrame(RawFrame object) throws HttpException, IOException {
        FrameType object22 = FrameType.valueOf(((Frame)object).getType());
        int n2 = ((Frame)object).getStreamId();
        if (this.continuation != null && object22 != FrameType.CONTINUATION) {
            throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "CONTINUATION frame expected");
        }
        switch (object22) {
            case DATA: {
                AbstractH2StreamMultiplexer$H2Stream abstractH2StreamMultiplexer$H2Stream = this.getValidStream(n2);
                try {
                    this.consumeDataFrame((RawFrame)object, abstractH2StreamMultiplexer$H2Stream);
                }
                catch (H2StreamResetException h2StreamResetException) {
                    abstractH2StreamMultiplexer$H2Stream.localReset(h2StreamResetException);
                }
                catch (HttpStreamResetException httpStreamResetException) {
                    HttpStreamResetException httpStreamResetException2 = httpStreamResetException;
                    abstractH2StreamMultiplexer$H2Stream.localReset((Exception)httpStreamResetException2, httpStreamResetException2.getCause() != null ? H2Error.INTERNAL_ERROR : H2Error.CANCEL);
                }
                if (abstractH2StreamMultiplexer$H2Stream.isTerminated()) {
                    this.streamMap.remove(n2);
                    abstractH2StreamMultiplexer$H2Stream.releaseResources();
                    this.requestSessionOutput();
                }
                return;
            }
            case HEADERS: {
                void var2_8;
                if (n2 == 0) {
                    throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Illegal stream id: " + n2);
                }
                AbstractH2StreamMultiplexer$H2Stream abstractH2StreamMultiplexer$H2Stream = this.streamMap.get(n2);
                if (abstractH2StreamMultiplexer$H2Stream == null) {
                    H2StreamHandler h2StreamHandler;
                    this.acceptHeaderFrame();
                    if (n2 <= this.lastStreamId.get()) {
                        throw new H2ConnectionException(H2Error.STREAM_CLOSED, "Stream closed");
                    }
                    if (this.idGenerator.isSameSide(n2)) {
                        throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Illegal stream id: " + n2);
                    }
                    if (this.goAwayReceived) {
                        throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "GOAWAY received");
                    }
                    this.updateLastStreamId(n2);
                    AbstractH2StreamMultiplexer$H2StreamChannelImpl abstractH2StreamMultiplexer$H2StreamChannelImpl = new AbstractH2StreamMultiplexer$H2StreamChannelImpl(this, n2, false, this.initInputWinSize, this.initOutputWinSize);
                    if (this.connState.compareTo(AbstractH2StreamMultiplexer$ConnectionHandshake.ACTIVE) <= 0) {
                        h2StreamHandler = this.createRemotelyInitiatedStream(abstractH2StreamMultiplexer$H2StreamChannelImpl, this.httpProcessor, this.connMetrics, null);
                    } else {
                        h2StreamHandler = NoopH2StreamHandler.INSTANCE;
                        abstractH2StreamMultiplexer$H2StreamChannelImpl.setLocalEndStream();
                    }
                    AbstractH2StreamMultiplexer$H2Stream abstractH2StreamMultiplexer$H2Stream2 = new AbstractH2StreamMultiplexer$H2Stream(abstractH2StreamMultiplexer$H2StreamChannelImpl, h2StreamHandler, true, null);
                    if (abstractH2StreamMultiplexer$H2Stream2.isOutputReady()) {
                        abstractH2StreamMultiplexer$H2Stream2.produceOutput();
                    }
                    this.streamMap.put(n2, abstractH2StreamMultiplexer$H2Stream2);
                }
                try {
                    this.consumeHeaderFrame((RawFrame)object, (AbstractH2StreamMultiplexer$H2Stream)var2_8);
                    if (var2_8.isOutputReady()) {
                        var2_8.produceOutput();
                    }
                }
                catch (H2StreamResetException h2StreamResetException) {
                    var2_8.localReset(h2StreamResetException);
                }
                catch (HttpStreamResetException httpStreamResetException) {
                    HttpStreamResetException httpStreamResetException3 = httpStreamResetException;
                    var2_8.localReset((Exception)httpStreamResetException3, httpStreamResetException3.getCause() != null ? H2Error.INTERNAL_ERROR : H2Error.CANCEL);
                }
                catch (HttpException httpException) {
                    var2_8.handle(httpException);
                }
                if (var2_8.isTerminated()) {
                    this.streamMap.remove(n2);
                    var2_8.releaseResources();
                    this.requestSessionOutput();
                }
                return;
            }
            case CONTINUATION: {
                if (this.continuation == null) {
                    throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Unexpected CONTINUATION frame");
                }
                if (n2 != this.continuation.streamId) {
                    throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Unexpected CONTINUATION stream id: " + n2);
                }
                AbstractH2StreamMultiplexer$H2Stream abstractH2StreamMultiplexer$H2Stream = this.getValidStream(n2);
                try {
                    this.consumeContinuationFrame((RawFrame)object, abstractH2StreamMultiplexer$H2Stream);
                }
                catch (H2StreamResetException h2StreamResetException) {
                    abstractH2StreamMultiplexer$H2Stream.localReset(h2StreamResetException);
                }
                catch (HttpStreamResetException httpStreamResetException) {
                    HttpStreamResetException httpStreamResetException4 = httpStreamResetException;
                    abstractH2StreamMultiplexer$H2Stream.localReset((Exception)httpStreamResetException4, httpStreamResetException4.getCause() != null ? H2Error.INTERNAL_ERROR : H2Error.CANCEL);
                }
                if (abstractH2StreamMultiplexer$H2Stream.isTerminated()) {
                    this.streamMap.remove(n2);
                    abstractH2StreamMultiplexer$H2Stream.releaseResources();
                    this.requestSessionOutput();
                }
                return;
            }
            case WINDOW_UPDATE: {
                ByteBuffer byteBuffer = ((RawFrame)object).getPayload();
                if (byteBuffer == null || byteBuffer.remaining() != 4) {
                    throw new H2ConnectionException(H2Error.FRAME_SIZE_ERROR, "Invalid WINDOW_UPDATE frame payload");
                }
                int n3 = byteBuffer.getInt();
                if (n3 <= 0) {
                    throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Invalid WINDOW_UPDATE delta");
                }
                if (n2 == 0) {
                    try {
                        this.updateOutputWindow(0, this.connOutputWindow, n3);
                    }
                    catch (ArithmeticException arithmeticException) {
                        throw new H2ConnectionException(H2Error.FLOW_CONTROL_ERROR, arithmeticException.getMessage());
                    }
                }
                AbstractH2StreamMultiplexer$H2Stream abstractH2StreamMultiplexer$H2Stream = this.streamMap.get(n2);
                if (abstractH2StreamMultiplexer$H2Stream != null) {
                    try {
                        this.updateOutputWindow(n2, abstractH2StreamMultiplexer$H2Stream.getOutputWindow(), n3);
                    }
                    catch (ArithmeticException arithmeticException) {
                        throw new H2ConnectionException(H2Error.FLOW_CONTROL_ERROR, arithmeticException.getMessage());
                    }
                }
                this.ioSession.setEvent(4);
                return;
            }
            case RST_STREAM: {
                if (n2 == 0) {
                    throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Illegal stream id: " + n2);
                }
                AbstractH2StreamMultiplexer$H2Stream abstractH2StreamMultiplexer$H2Stream = this.streamMap.get(n2);
                if (abstractH2StreamMultiplexer$H2Stream == null) {
                    if (n2 > this.lastStreamId.get()) {
                        throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Unexpected stream id: " + n2);
                    }
                } else {
                    ByteBuffer byteBuffer = ((RawFrame)object).getPayload();
                    if (byteBuffer == null || byteBuffer.remaining() != 4) {
                        throw new H2ConnectionException(H2Error.FRAME_SIZE_ERROR, "Invalid RST_STREAM frame payload");
                    }
                    int n4 = byteBuffer.getInt();
                    abstractH2StreamMultiplexer$H2Stream.fail(new H2StreamResetException(n4, "Stream reset (" + n4 + ")"));
                    this.streamMap.remove(n2);
                    this.requestSessionOutput();
                }
                return;
            }
            case PING: {
                if (n2 != 0) {
                    throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Illegal stream id");
                }
                ByteBuffer byteBuffer = ((RawFrame)object).getPayloadContent();
                if (byteBuffer == null || byteBuffer.remaining() != 8) {
                    throw new H2ConnectionException(H2Error.FRAME_SIZE_ERROR, "Invalid PING frame payload");
                }
                if (((Frame)object).isFlagSet(FrameFlag.ACK)) {
                    AsyncPingHandler asyncPingHandler = this.pingHandlers.poll();
                    if (asyncPingHandler == null) break;
                    asyncPingHandler.consumeResponse(byteBuffer);
                    break;
                }
                ByteBuffer byteBuffer2 = ByteBuffer.allocate(byteBuffer.remaining());
                byteBuffer2.put(byteBuffer);
                byteBuffer2.flip();
                RawFrame rawFrame = this.frameFactory.createPingAck(byteBuffer2);
                this.commitFrame(rawFrame);
                return;
            }
            case SETTINGS: {
                if (n2 != 0) {
                    throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Illegal stream id");
                }
                if (((Frame)object).isFlagSet(FrameFlag.ACK)) {
                    if (this.localSettingState != AbstractH2StreamMultiplexer$SettingsHandshake.TRANSMITTED) break;
                    this.localSettingState = AbstractH2StreamMultiplexer$SettingsHandshake.ACKED;
                    this.ioSession.setEvent(4);
                    this.applyLocalSettings();
                    return;
                }
                ByteBuffer byteBuffer = ((RawFrame)object).getPayload();
                if (byteBuffer != null) {
                    if (byteBuffer.remaining() % 6 != 0) {
                        throw new H2ConnectionException(H2Error.FRAME_SIZE_ERROR, "Invalid SETTINGS payload");
                    }
                    this.consumeSettingsFrame(byteBuffer);
                    this.remoteSettingState = AbstractH2StreamMultiplexer$SettingsHandshake.TRANSMITTED;
                }
                RawFrame rawFrame = this.frameFactory.createSettingsAck();
                this.commitFrame(rawFrame);
                this.remoteSettingState = AbstractH2StreamMultiplexer$SettingsHandshake.ACKED;
                return;
            }
            case PRIORITY: {
                return;
            }
            case PUSH_PROMISE: {
                void var2_17;
                this.acceptPushFrame();
                if (this.goAwayReceived) {
                    throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "GOAWAY received");
                }
                if (!this.localConfig.isPushEnabled()) {
                    throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Push is disabled");
                }
                AbstractH2StreamMultiplexer$H2Stream abstractH2StreamMultiplexer$H2Stream = this.getValidStream(n2);
                if (abstractH2StreamMultiplexer$H2Stream.isRemoteClosed()) {
                    abstractH2StreamMultiplexer$H2Stream.localReset(new H2StreamResetException(H2Error.STREAM_CLOSED, "Stream closed"));
                    return;
                }
                ByteBuffer byteBuffer = ((RawFrame)object).getPayloadContent();
                if (byteBuffer == null || byteBuffer.remaining() < 4) {
                    throw new H2ConnectionException(H2Error.FRAME_SIZE_ERROR, "Invalid PUSH_PROMISE payload");
                }
                int n5 = byteBuffer.getInt();
                if (n5 == 0 || this.idGenerator.isSameSide(n5)) {
                    throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Illegal promised stream id: " + n5);
                }
                if (this.streamMap.get(n5) != null) {
                    throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Unexpected promised stream id: " + n5);
                }
                this.updateLastStreamId(n5);
                AbstractH2StreamMultiplexer$H2StreamChannelImpl abstractH2StreamMultiplexer$H2StreamChannelImpl = new AbstractH2StreamMultiplexer$H2StreamChannelImpl(this, n5, false, this.initInputWinSize, this.initOutputWinSize);
                if (this.connState.compareTo(AbstractH2StreamMultiplexer$ConnectionHandshake.ACTIVE) <= 0) {
                    H2StreamHandler h2StreamHandler = this.createRemotelyInitiatedStream(abstractH2StreamMultiplexer$H2StreamChannelImpl, this.httpProcessor, this.connMetrics, abstractH2StreamMultiplexer$H2Stream.getPushHandlerFactory());
                } else {
                    NoopH2StreamHandler noopH2StreamHandler = NoopH2StreamHandler.INSTANCE;
                    abstractH2StreamMultiplexer$H2StreamChannelImpl.setLocalEndStream();
                }
                AbstractH2StreamMultiplexer$H2Stream abstractH2StreamMultiplexer$H2Stream3 = new AbstractH2StreamMultiplexer$H2Stream(abstractH2StreamMultiplexer$H2StreamChannelImpl, (H2StreamHandler)var2_17, true, null);
                this.streamMap.put(n5, abstractH2StreamMultiplexer$H2Stream3);
                try {
                    this.consumePushPromiseFrame((RawFrame)object, byteBuffer, abstractH2StreamMultiplexer$H2Stream3);
                    break;
                }
                catch (H2StreamResetException h2StreamResetException) {
                    abstractH2StreamMultiplexer$H2Stream3.localReset(h2StreamResetException);
                    break;
                }
                catch (HttpStreamResetException httpStreamResetException) {
                    HttpStreamResetException httpStreamResetException5 = httpStreamResetException;
                    abstractH2StreamMultiplexer$H2Stream3.localReset((Exception)httpStreamResetException5, httpStreamResetException5.getCause() != null ? H2Error.INTERNAL_ERROR : H2Error.NO_ERROR);
                    return;
                }
            }
            case GOAWAY: {
                if (n2 != 0) {
                    throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Illegal stream id");
                }
                ByteBuffer byteBuffer = ((RawFrame)object).getPayload();
                if (byteBuffer == null || byteBuffer.remaining() < 8) {
                    throw new H2ConnectionException(H2Error.FRAME_SIZE_ERROR, "Invalid GOAWAY payload");
                }
                int n6 = byteBuffer.getInt();
                int n7 = byteBuffer.getInt();
                this.goAwayReceived = true;
                if (n7 == H2Error.NO_ERROR.getCode()) {
                    if (this.connState.compareTo(AbstractH2StreamMultiplexer$ConnectionHandshake.ACTIVE) <= 0) {
                        Iterator<Map.Entry<Integer, AbstractH2StreamMultiplexer$H2Stream>> iterator = this.streamMap.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry<Integer, AbstractH2StreamMultiplexer$H2Stream> entry = iterator.next();
                            int n8 = entry.getKey();
                            if (this.idGenerator.isSameSide(n8) || n8 <= n6) continue;
                            object = entry.getValue();
                            ((AbstractH2StreamMultiplexer$H2Stream)object).fail(new RequestNotExecutedException());
                            iterator.remove();
                        }
                    }
                    this.connState = this.streamMap.isEmpty() ? AbstractH2StreamMultiplexer$ConnectionHandshake.SHUTDOWN : AbstractH2StreamMultiplexer$ConnectionHandshake.GRACEFUL_SHUTDOWN;
                } else {
                    for (Map.Entry<Integer, AbstractH2StreamMultiplexer$H2Stream> entry : this.streamMap.entrySet()) {
                        AbstractH2StreamMultiplexer$H2Stream abstractH2StreamMultiplexer$H2Stream = entry.getValue();
                        abstractH2StreamMultiplexer$H2Stream.fail(new H2StreamResetException(n7, "Connection terminated by the peer (" + n7 + ")"));
                    }
                    this.streamMap.clear();
                    this.connState = AbstractH2StreamMultiplexer$ConnectionHandshake.SHUTDOWN;
                }
                this.ioSession.setEvent(4);
            }
        }
    }

    private void consumeDataFrame(RawFrame rawFrame, AbstractH2StreamMultiplexer$H2Stream abstractH2StreamMultiplexer$H2Stream) throws HttpException, IOException {
        if (abstractH2StreamMultiplexer$H2Stream.isRemoteClosed()) {
            throw new H2StreamResetException(H2Error.STREAM_CLOSED, "Stream already closed");
        }
        int n2 = abstractH2StreamMultiplexer$H2Stream.getId();
        ByteBuffer byteBuffer = rawFrame.getPayloadContent();
        if (byteBuffer != null) {
            int n3 = rawFrame.getLength();
            if ((n2 = this.updateInputWindow(n2, abstractH2StreamMultiplexer$H2Stream.getInputWindow(), -n3)) < this.lowMark && !abstractH2StreamMultiplexer$H2Stream.isRemoteClosed()) {
                abstractH2StreamMultiplexer$H2Stream.produceInputCapacityUpdate();
            }
            if ((long)(n2 = this.updateInputWindow(0, this.connInputWindow, -n3)) < 0xA00000L) {
                this.maximizeWindow(0, this.connInputWindow);
            }
        }
        if (rawFrame.isFlagSet(FrameFlag.END_STREAM)) {
            abstractH2StreamMultiplexer$H2Stream.setRemoteEndStream();
        }
        if (abstractH2StreamMultiplexer$H2Stream.isLocalReset()) {
            return;
        }
        abstractH2StreamMultiplexer$H2Stream.consumeData(byteBuffer);
    }

    private void maximizeWindow(int n2, AtomicInteger atomicInteger) throws IOException {
        int n3 = this.updateWindowMax(atomicInteger);
        if (n3 > 0) {
            RawFrame rawFrame = this.frameFactory.createWindowUpdate(n2, n3);
            this.commitFrame(rawFrame);
        }
    }

    private void consumePushPromiseFrame(RawFrame object, ByteBuffer byteBuffer, AbstractH2StreamMultiplexer$H2Stream abstractH2StreamMultiplexer$H2Stream) throws HttpException, IOException {
        int n2 = abstractH2StreamMultiplexer$H2Stream.getId();
        if (!((Frame)object).isFlagSet(FrameFlag.END_HEADERS)) {
            this.continuation = new AbstractH2StreamMultiplexer$Continuation(n2, ((Frame)object).getType(), true, this.localConfig.getMaxContinuations(), null);
        }
        if (this.continuation == null) {
            object = this.hPackDecoder.decodeHeaders(byteBuffer);
            if (n2 > this.processedRemoteStreamId) {
                this.processedRemoteStreamId = n2;
            }
            if (this.streamListener != null) {
                this.streamListener.onHeaderInput(this, n2, (List<? extends Header>)object);
            }
            abstractH2StreamMultiplexer$H2Stream.consumePromise((List<Header>)object);
            return;
        }
        this.continuation.copyPayload(byteBuffer);
    }

    List<Header> decodeHeaders(ByteBuffer byteBuffer) throws HttpException {
        return this.hPackDecoder.decodeHeaders(byteBuffer);
    }

    private void consumeHeaderFrame(RawFrame rawFrame, AbstractH2StreamMultiplexer$H2Stream abstractH2StreamMultiplexer$H2Stream) throws HttpException, IOException {
        if (abstractH2StreamMultiplexer$H2Stream.isRemoteClosed()) {
            throw new H2StreamResetException(H2Error.STREAM_CLOSED, "Stream already closed");
        }
        int n2 = abstractH2StreamMultiplexer$H2Stream.getId();
        if (!rawFrame.isFlagSet(FrameFlag.END_HEADERS)) {
            this.continuation = new AbstractH2StreamMultiplexer$Continuation(n2, rawFrame.getType(), rawFrame.isFlagSet(FrameFlag.END_STREAM), this.localConfig.getMaxContinuations(), null);
        }
        Object object = rawFrame.getPayloadContent();
        if (rawFrame.isFlagSet(FrameFlag.PRIORITY)) {
            ((ByteBuffer)object).getInt();
            ((ByteBuffer)object).get();
        }
        if (this.continuation == null) {
            object = this.decodeHeaders((ByteBuffer)object);
            if (abstractH2StreamMultiplexer$H2Stream.isRemoteInitiated() && n2 > this.processedRemoteStreamId) {
                this.processedRemoteStreamId = n2;
            }
            if (this.streamListener != null) {
                this.streamListener.onHeaderInput(this, n2, (List<? extends Header>)object);
            }
            if (abstractH2StreamMultiplexer$H2Stream.isLocalReset()) {
                return;
            }
            if (rawFrame.isFlagSet(FrameFlag.END_STREAM)) {
                abstractH2StreamMultiplexer$H2Stream.setRemoteEndStream();
            }
            abstractH2StreamMultiplexer$H2Stream.consumeHeader((List<Header>)object);
            return;
        }
        this.continuation.copyPayload((ByteBuffer)object);
    }

    private void consumeContinuationFrame(RawFrame object, AbstractH2StreamMultiplexer$H2Stream abstractH2StreamMultiplexer$H2Stream) throws HttpException, IOException {
        if (abstractH2StreamMultiplexer$H2Stream.isRemoteClosed()) {
            throw new H2StreamResetException(H2Error.STREAM_CLOSED, "Stream already closed");
        }
        int n2 = ((Frame)object).getStreamId();
        ByteBuffer byteBuffer = ((RawFrame)object).getPayload();
        this.continuation.copyPayload(byteBuffer);
        if (((Frame)object).isFlagSet(FrameFlag.END_HEADERS)) {
            AbstractH2StreamMultiplexer abstractH2StreamMultiplexer = this;
            object = abstractH2StreamMultiplexer.decodeHeaders(abstractH2StreamMultiplexer.continuation.getContent());
            if (abstractH2StreamMultiplexer$H2Stream.isRemoteInitiated() && n2 > this.processedRemoteStreamId) {
                this.processedRemoteStreamId = n2;
            }
            if (this.streamListener != null) {
                this.streamListener.onHeaderInput(this, n2, (List<? extends Header>)object);
            }
            if (abstractH2StreamMultiplexer$H2Stream.isLocalReset()) {
                return;
            }
            if (this.continuation.endStream) {
                abstractH2StreamMultiplexer$H2Stream.setRemoteEndStream();
            }
            if (this.continuation.type == FrameType.PUSH_PROMISE.getValue()) {
                abstractH2StreamMultiplexer$H2Stream.consumePromise((List<Header>)object);
            } else {
                abstractH2StreamMultiplexer$H2Stream.consumeHeader((List<Header>)object);
            }
            this.continuation = null;
        }
    }

    private void consumeSettingsFrame(ByteBuffer byteBuffer) throws IOException {
        H2Config$Builder h2Config$Builder = H2Config.initial();
        block18: while (byteBuffer.hasRemaining()) {
            short s2 = byteBuffer.getShort();
            int n2 = byteBuffer.getInt();
            H2Param h2Param = H2Param.valueOf(s2);
            if (h2Param == null) continue;
            switch (h2Param) {
                case HEADER_TABLE_SIZE: {
                    try {
                        h2Config$Builder.setHeaderTableSize(n2);
                        continue block18;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, illegalArgumentException.getMessage());
                    }
                }
                case MAX_CONCURRENT_STREAMS: {
                    try {
                        h2Config$Builder.setMaxConcurrentStreams(n2);
                        continue block18;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, illegalArgumentException.getMessage());
                    }
                }
                case ENABLE_PUSH: {
                    h2Config$Builder.setPushEnabled(n2 == 1);
                    continue block18;
                }
                case INITIAL_WINDOW_SIZE: {
                    try {
                        h2Config$Builder.setInitialWindowSize(n2);
                        continue block18;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, illegalArgumentException.getMessage());
                    }
                }
                case MAX_FRAME_SIZE: {
                    try {
                        h2Config$Builder.setMaxFrameSize(n2);
                        continue block18;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, illegalArgumentException.getMessage());
                    }
                }
                case MAX_HEADER_LIST_SIZE: {
                    try {
                        h2Config$Builder.setMaxHeaderListSize(n2);
                        continue block18;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, illegalArgumentException.getMessage());
                    }
                }
            }
        }
        this.applyRemoteSettings(h2Config$Builder.build());
    }

    private void produceOutput() throws HttpException, IOException {
        Iterator<Map.Entry<Integer, AbstractH2StreamMultiplexer$H2Stream>> iterator = this.streamMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!((AbstractH2StreamMultiplexer$H2Stream)(object = object.getValue())).isLocalClosed() && ((AbstractH2StreamMultiplexer$H2Stream)object).getOutputWindow().get() > 0) {
                ((AbstractH2StreamMultiplexer$H2Stream)object).produceOutput();
            }
            if (((AbstractH2StreamMultiplexer$H2Stream)object).isTerminated()) {
                iterator.remove();
                ((AbstractH2StreamMultiplexer$H2Stream)object).releaseResources();
                this.requestSessionOutput();
            }
            if (this.outputQueue.isEmpty()) continue;
        }
    }

    private void applyRemoteSettings(H2Config h2Config) throws H2ConnectionException {
        this.remoteConfig = h2Config;
        this.hPackEncoder.setMaxTableSize(this.remoteConfig.getHeaderTableSize());
        int n2 = this.remoteConfig.getInitialWindowSize() - this.initOutputWinSize;
        this.initOutputWinSize = this.remoteConfig.getInitialWindowSize();
        int n3 = this.remoteConfig.getMaxFrameSize();
        if (n3 < this.outputBuffer.getMaxFramePayloadSize()) {
            try {
                this.outputBuffer.resize(n3);
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new H2ConnectionException(H2Error.INTERNAL_ERROR, "Failure resizing the frame output buffer");
            }
        }
        if (n2 != 0 && !this.streamMap.isEmpty()) {
            for (Map.Entry<Integer, AbstractH2StreamMultiplexer$H2Stream> entry : this.streamMap.entrySet()) {
                AbstractH2StreamMultiplexer$H2Stream object = entry.getValue();
                try {
                    this.updateOutputWindow(object.getId(), object.getOutputWindow(), n2);
                }
                catch (ArithmeticException arithmeticException) {
                    throw new H2ConnectionException(H2Error.FLOW_CONTROL_ERROR, arithmeticException.getMessage());
                }
            }
        }
    }

    private void applyLocalSettings() throws H2ConnectionException {
        this.hPackDecoder.setMaxTableSize(this.localConfig.getHeaderTableSize());
        this.hPackDecoder.setMaxListSize(this.localConfig.getMaxHeaderListSize());
        int n2 = this.localConfig.getInitialWindowSize() - this.initInputWinSize;
        this.initInputWinSize = this.localConfig.getInitialWindowSize();
        if (n2 != 0 && !this.streamMap.isEmpty()) {
            for (Map.Entry<Integer, AbstractH2StreamMultiplexer$H2Stream> entry : this.streamMap.entrySet()) {
                AbstractH2StreamMultiplexer$H2Stream object = entry.getValue();
                try {
                    this.updateInputWindow(object.getId(), object.getInputWindow(), n2);
                }
                catch (ArithmeticException arithmeticException) {
                    throw new H2ConnectionException(H2Error.FLOW_CONTROL_ERROR, arithmeticException.getMessage());
                }
            }
        }
        this.lowMark = this.initInputWinSize / 2;
    }

    @Override
    public void close() throws IOException {
        this.ioSession.enqueue(ShutdownCommand.GRACEFUL, Command$Priority.IMMEDIATE);
    }

    @Override
    public void close(CloseMode closeMode) {
        this.ioSession.close(closeMode);
    }

    @Override
    public boolean isOpen() {
        return this.connState == AbstractH2StreamMultiplexer$ConnectionHandshake.ACTIVE;
    }

    @Override
    public void setSocketTimeout(Timeout timeout) {
        this.ioSession.setSocketTimeout(timeout);
    }

    @Override
    public SSLSession getSSLSession() {
        TlsDetails tlsDetails = this.ioSession.getTlsDetails();
        if (tlsDetails != null) {
            return tlsDetails.getSSLSession();
        }
        return null;
    }

    @Override
    public EndpointDetails getEndpointDetails() {
        if (this.endpointDetails == null) {
            this.endpointDetails = new BasicEndpointDetails(this.ioSession.getRemoteAddress(), this.ioSession.getLocalAddress(), this.connMetrics, this.ioSession.getSocketTimeout());
        }
        return this.endpointDetails;
    }

    @Override
    public Timeout getSocketTimeout() {
        return this.ioSession.getSocketTimeout();
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return HttpVersion.HTTP_2;
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.ioSession.getRemoteAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.ioSession.getLocalAddress();
    }

    void appendState(StringBuilder stringBuilder) {
        stringBuilder.append("connState=").append((Object)this.connState).append(", connInputWindow=").append(this.connInputWindow).append(", connOutputWindow=").append(this.connOutputWindow).append(", outputQueue=").append(this.outputQueue.size()).append(", streamMap=").append(this.streamMap.size()).append(", processedRemoteStreamId=").append(this.processedRemoteStreamId);
    }

    static /* synthetic */ ProtocolIOSession access$200(AbstractH2StreamMultiplexer abstractH2StreamMultiplexer) {
        return abstractH2StreamMultiplexer.ioSession;
    }

    static /* synthetic */ void access$300(AbstractH2StreamMultiplexer abstractH2StreamMultiplexer, int n2, List list, boolean bl2) throws IOException {
        abstractH2StreamMultiplexer.commitHeaders(n2, list, bl2);
    }

    static /* synthetic */ int access$400(AbstractH2StreamMultiplexer abstractH2StreamMultiplexer) {
        return abstractH2StreamMultiplexer.generateStreamId();
    }

    static /* synthetic */ H2Config access$500(AbstractH2StreamMultiplexer abstractH2StreamMultiplexer) {
        return abstractH2StreamMultiplexer.localConfig;
    }

    static /* synthetic */ H2Config access$600(AbstractH2StreamMultiplexer abstractH2StreamMultiplexer) {
        return abstractH2StreamMultiplexer.remoteConfig;
    }

    static /* synthetic */ HttpProcessor access$700(AbstractH2StreamMultiplexer abstractH2StreamMultiplexer) {
        return abstractH2StreamMultiplexer.httpProcessor;
    }

    static /* synthetic */ BasicHttpConnectionMetrics access$800(AbstractH2StreamMultiplexer abstractH2StreamMultiplexer) {
        return abstractH2StreamMultiplexer.connMetrics;
    }

    static /* synthetic */ Map access$900(AbstractH2StreamMultiplexer abstractH2StreamMultiplexer) {
        return abstractH2StreamMultiplexer.streamMap;
    }

    static /* synthetic */ void access$1000(AbstractH2StreamMultiplexer abstractH2StreamMultiplexer, int n2, int n3, List list) throws IOException {
        abstractH2StreamMultiplexer.commitPushPromise(n2, n3, list);
    }

    static /* synthetic */ void access$1100(AbstractH2StreamMultiplexer abstractH2StreamMultiplexer, int n2, AtomicInteger atomicInteger, int n3) throws IOException {
        abstractH2StreamMultiplexer.incrementInputCapacity(n2, atomicInteger, n3);
    }

    static /* synthetic */ int access$1200(AbstractH2StreamMultiplexer abstractH2StreamMultiplexer, int n2, AtomicInteger atomicInteger, ByteBuffer byteBuffer) throws IOException {
        return abstractH2StreamMultiplexer.streamData(n2, atomicInteger, byteBuffer);
    }

    static /* synthetic */ FrameFactory access$1300(AbstractH2StreamMultiplexer abstractH2StreamMultiplexer) {
        return abstractH2StreamMultiplexer.frameFactory;
    }

    static /* synthetic */ void access$1400(AbstractH2StreamMultiplexer abstractH2StreamMultiplexer, RawFrame rawFrame) throws IOException {
        abstractH2StreamMultiplexer.commitFrameInternal(rawFrame);
    }

    static /* synthetic */ void access$1500(AbstractH2StreamMultiplexer abstractH2StreamMultiplexer) {
        abstractH2StreamMultiplexer.requestSessionOutput();
    }

    static /* synthetic */ AbstractH2StreamMultiplexer$ConnectionHandshake access$1600(AbstractH2StreamMultiplexer abstractH2StreamMultiplexer) {
        return abstractH2StreamMultiplexer.connState;
    }
}

