/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.http.impl.nio.BufferedData;
import org.apache.hc.core5.http2.impl.nio.ClientH2IOEventHandler;
import org.apache.hc.core5.http2.impl.nio.ClientH2StreamMultiplexerFactory;
import org.apache.hc.core5.http2.impl.nio.PrefaceHandlerBase;
import org.apache.hc.core5.http2.impl.nio.ProtocolNegotiationException;
import org.apache.hc.core5.http2.ssl.ApplicationProtocol;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.ProtocolIOSession;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TextUtils;

@Internal
public class ClientH2PrefaceHandler
extends PrefaceHandlerBase {
    static final byte[] PREFACE = new byte[]{80, 82, 73, 32, 42, 32, 72, 84, 84, 80, 47, 50, 46, 48, 13, 10, 13, 10, 83, 77, 13, 10, 13, 10};
    private final ClientH2StreamMultiplexerFactory http2StreamHandlerFactory;
    private final boolean strictALPNHandshake;
    private final AtomicBoolean initialized;
    private volatile ByteBuffer preface;
    private volatile BufferedData inBuf;

    public ClientH2PrefaceHandler(ProtocolIOSession protocolIOSession, ClientH2StreamMultiplexerFactory clientH2StreamMultiplexerFactory, boolean bl2, Callback<Exception> callback) {
        this(protocolIOSession, clientH2StreamMultiplexerFactory, bl2, null, callback);
    }

    public ClientH2PrefaceHandler(ProtocolIOSession protocolIOSession, ClientH2StreamMultiplexerFactory clientH2StreamMultiplexerFactory, boolean bl2, FutureCallback<ProtocolIOSession> futureCallback, Callback<Exception> callback) {
        super(protocolIOSession, futureCallback, callback);
        this.http2StreamHandlerFactory = Args.notNull(clientH2StreamMultiplexerFactory, "HTTP/2 stream handler factory");
        this.strictALPNHandshake = bl2;
        this.initialized = new AtomicBoolean();
    }

    private void initialize() throws IOException {
        Object object = this.ioSession.getTlsDetails();
        if (object != null) {
            if (TextUtils.isEmpty((CharSequence)(object = ((TlsDetails)object).getApplicationProtocol()))) {
                if (this.strictALPNHandshake) {
                    throw new ProtocolNegotiationException("ALPN: missing application protocol");
                }
            } else if (!ApplicationProtocol.HTTP_2.id.equals(object)) {
                throw new ProtocolNegotiationException("ALPN: unexpected application protocol '" + (String)object + "'");
            }
        }
        this.preface = ByteBuffer.wrap(PREFACE);
        this.ioSession.setEvent(4);
    }

    private boolean writeOutPreface(IOSession iOSession, ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer.hasRemaining()) {
            iOSession.write(byteBuffer);
        }
        if (!byteBuffer.hasRemaining()) {
            iOSession.clearEvent(4);
            iOSession = this.inBuf != null ? this.inBuf.data() : null;
            this.startProtocol(new ClientH2IOEventHandler(this.http2StreamHandlerFactory.create(this.ioSession)), (ByteBuffer)((Object)iOSession));
            if (this.inBuf != null) {
                this.inBuf.clear();
            }
            return true;
        }
        return false;
    }

    @Override
    public void connected(IOSession iOSession) throws IOException {
        if (this.initialized.compareAndSet(false, true)) {
            this.initialize();
        }
    }

    @Override
    public void outputReady(IOSession iOSession) throws IOException {
        ByteBuffer byteBuffer;
        if (this.initialized.compareAndSet(false, true)) {
            this.initialize();
        }
        if ((byteBuffer = this.preface) != null) {
            if (this.writeOutPreface(iOSession, byteBuffer)) {
                this.preface = null;
                return;
            }
        } else {
            throw new ProtocolNegotiationException("Unexpected output");
        }
    }

    @Override
    public void inputReady(IOSession iOSession, ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer != null) {
            if (this.inBuf == null) {
                this.inBuf = BufferedData.allocate(byteBuffer.remaining());
            }
            this.inBuf.put(byteBuffer);
        }
        if ((byteBuffer = this.preface) != null) {
            if (this.writeOutPreface(iOSession, byteBuffer)) {
                this.preface = null;
                return;
            }
        } else {
            throw new ProtocolNegotiationException("Unexpected input");
        }
    }

    public String toString() {
        return this.getClass().getName();
    }
}

