/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.impl.BasicHttpConnectionMetrics;
import org.apache.hc.core5.http.impl.IncomingEntityDetails;
import org.apache.hc.core5.http.impl.nio.MessageState;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http2.H2ConnectionException;
import org.apache.hc.core5.http2.H2Error;
import org.apache.hc.core5.http2.impl.DefaultH2RequestConverter;
import org.apache.hc.core5.http2.impl.DefaultH2ResponseConverter;
import org.apache.hc.core5.http2.impl.nio.ClientH2StreamHandler$1;
import org.apache.hc.core5.http2.impl.nio.H2StreamChannel;
import org.apache.hc.core5.http2.impl.nio.H2StreamHandler;

class ClientH2StreamHandler
implements H2StreamHandler {
    private final H2StreamChannel outputChannel;
    private final DataStreamChannel dataChannel;
    private final HttpProcessor httpProcessor;
    private final BasicHttpConnectionMetrics connMetrics;
    private final AsyncClientExchangeHandler exchangeHandler;
    private final HandlerFactory<AsyncPushConsumer> pushHandlerFactory;
    private final HttpCoreContext context;
    private final AtomicReference<MessageState> requestState;
    private final AtomicReference<MessageState> responseState;
    private final AtomicBoolean requestCommitted;
    private final AtomicBoolean failed;
    private final AtomicBoolean done;

    ClientH2StreamHandler(H2StreamChannel h2StreamChannel, HttpProcessor httpProcessor, BasicHttpConnectionMetrics basicHttpConnectionMetrics, AsyncClientExchangeHandler asyncClientExchangeHandler, HandlerFactory<AsyncPushConsumer> handlerFactory, HttpCoreContext httpCoreContext) {
        this.outputChannel = h2StreamChannel;
        this.dataChannel = new ClientH2StreamHandler$1(this, h2StreamChannel);
        this.httpProcessor = httpProcessor;
        this.connMetrics = basicHttpConnectionMetrics;
        this.exchangeHandler = asyncClientExchangeHandler;
        this.pushHandlerFactory = handlerFactory;
        this.context = httpCoreContext;
        this.requestCommitted = new AtomicBoolean();
        this.failed = new AtomicBoolean();
        this.done = new AtomicBoolean();
        this.requestState = new AtomicReference<MessageState>(MessageState.HEADERS);
        this.responseState = new AtomicReference<MessageState>(MessageState.HEADERS);
    }

    @Override
    public HandlerFactory<AsyncPushConsumer> getPushHandlerFactory() {
        return this.pushHandlerFactory;
    }

    @Override
    public boolean isOutputReady() {
        switch (this.requestState.get()) {
            case HEADERS: {
                return true;
            }
            case BODY: {
                return this.exchangeHandler.available() > 0;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void commitRequest(HttpRequest object, EntityDetails entityDetails) throws HttpException, IOException {
        if (!this.requestCommitted.compareAndSet(false, true)) throw new H2ConnectionException(H2Error.INTERNAL_ERROR, "Request already committed");
        this.context.setProtocolVersion(HttpVersion.HTTP_2);
        this.context.setRequest((HttpRequest)object);
        this.httpProcessor.process((HttpRequest)object, entityDetails, (HttpContext)this.context);
        List<Header> list = DefaultH2RequestConverter.INSTANCE.convert((HttpRequest)object);
        if (entityDetails == null) {
            this.requestState.set(MessageState.COMPLETE);
            this.outputChannel.submit(list, true);
            this.connMetrics.incrementRequestCount();
            return;
        } else {
            this.outputChannel.submit(list, false);
            this.connMetrics.incrementRequestCount();
            object = object.getFirstHeader("Expect");
            boolean bl2 = object != null && "100-continue".equalsIgnoreCase(object.getValue());
            if (bl2) {
                this.requestState.set(MessageState.ACK);
                return;
            } else {
                this.exchangeHandler.produce(this.dataChannel);
                if (!this.requestState.compareAndSet(MessageState.HEADERS, MessageState.BODY)) return;
                this.outputChannel.requestOutput();
                return;
            }
        }
    }

    @Override
    public void produceOutput() throws HttpException, IOException {
        switch (this.requestState.get()) {
            case HEADERS: {
                this.exchangeHandler.produceRequest((httpRequest, entityDetails, httpContext) -> this.commitRequest(httpRequest, entityDetails), this.context);
                return;
            }
            case BODY: {
                this.exchangeHandler.produce(this.dataChannel);
            }
        }
    }

    @Override
    public void consumePromise(List<Header> list) throws HttpException, IOException {
        throw new ProtocolException("Unexpected message promise");
    }

    @Override
    public void consumeHeader(List<Header> object, boolean bl2) throws HttpException, IOException {
        if (this.done.get()) {
            throw new ProtocolException("Unexpected message headers");
        }
        switch (this.responseState.get()) {
            case HEADERS: {
                object = DefaultH2ResponseConverter.INSTANCE.convert((List)object);
                int n2 = object.getCode();
                if (n2 < 100) {
                    throw new ProtocolException("Invalid response: " + new StatusLine((HttpResponse)object));
                }
                if (n2 > 100 && n2 < 200) {
                    this.exchangeHandler.consumeInformation((HttpResponse)object, this.context);
                }
                if (this.requestState.get() == MessageState.ACK && (n2 == 100 || n2 >= 200)) {
                    this.requestState.set(MessageState.BODY);
                    this.exchangeHandler.produce(this.dataChannel);
                }
                if (n2 < 200) {
                    return;
                }
                IncomingEntityDetails incomingEntityDetails = bl2 ? null : new IncomingEntityDetails((MessageHeaders)object, -1L);
                this.context.setResponse((HttpResponse)object);
                this.httpProcessor.process((HttpResponse)object, (EntityDetails)incomingEntityDetails, (HttpContext)this.context);
                this.connMetrics.incrementResponseCount();
                this.exchangeHandler.consumeResponse((HttpResponse)object, incomingEntityDetails, this.context);
                this.responseState.set(bl2 ? MessageState.COMPLETE : MessageState.BODY);
                return;
            }
            case BODY: {
                this.responseState.set(MessageState.COMPLETE);
                this.exchangeHandler.streamEnd((List<? extends Header>)object);
                return;
            }
        }
        throw new ProtocolException("Unexpected message headers");
    }

    @Override
    public void updateInputCapacity() throws IOException {
        this.exchangeHandler.updateCapacity(this.outputChannel);
    }

    @Override
    public void consumeData(ByteBuffer byteBuffer, boolean bl2) throws HttpException, IOException {
        if (this.done.get() || this.responseState.get() != MessageState.BODY) {
            throw new ProtocolException("Unexpected message data");
        }
        if (byteBuffer != null) {
            this.exchangeHandler.consume(byteBuffer);
        }
        if (bl2) {
            this.responseState.set(MessageState.COMPLETE);
            this.exchangeHandler.streamEnd(null);
        }
    }

    @Override
    public void handle(HttpException httpException, boolean bl2) throws HttpException, IOException {
        throw httpException;
    }

    @Override
    public void failed(Exception exception) {
        try {
            if (this.failed.compareAndSet(false, true) && this.exchangeHandler != null) {
                this.exchangeHandler.failed(exception);
            }
            return;
        }
        finally {
            this.releaseResources();
        }
    }

    @Override
    public void releaseResources() {
        if (this.done.compareAndSet(false, true)) {
            this.responseState.set(MessageState.COMPLETE);
            this.requestState.set(MessageState.COMPLETE);
            this.exchangeHandler.releaseResources();
        }
    }

    public String toString() {
        return "[requestState=" + (Object)((Object)this.requestState.get()) + ", responseState=" + (Object)((Object)this.responseState.get()) + ']';
    }

    static /* synthetic */ AtomicReference access$000(ClientH2StreamHandler clientH2StreamHandler) {
        return clientH2StreamHandler.requestState;
    }
}

