/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import java.io.IOException;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.http2.impl.nio.ClientH2PrefaceHandler;
import org.apache.hc.core5.http2.impl.nio.ClientH2StreamMultiplexerFactory;
import org.apache.hc.core5.reactor.IOEventHandler;
import org.apache.hc.core5.reactor.ProtocolIOSession;
import org.apache.hc.core5.reactor.ProtocolUpgradeHandler;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
@Internal
public class ClientH2UpgradeHandler
implements ProtocolUpgradeHandler {
    private final ClientH2StreamMultiplexerFactory http2StreamHandlerFactory;
    private final Callback<Exception> exceptionCallback;

    public ClientH2UpgradeHandler(ClientH2StreamMultiplexerFactory clientH2StreamMultiplexerFactory, Callback<Exception> callback) {
        this.http2StreamHandlerFactory = Args.notNull(clientH2StreamMultiplexerFactory, "HTTP/2 stream handler factory");
        this.exceptionCallback = callback;
    }

    @Override
    public void upgrade(ProtocolIOSession protocolIOSession, FutureCallback<ProtocolIOSession> object) {
        object = new ClientH2PrefaceHandler(protocolIOSession, this.http2StreamHandlerFactory, true, (FutureCallback<ProtocolIOSession>)object, this.exceptionCallback);
        protocolIOSession.upgrade((IOEventHandler)object);
        try {
            object.connected(protocolIOSession);
            return;
        }
        catch (IOException iOException) {
            object.exception(protocolIOSession, iOException);
            return;
        }
    }
}

