/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import java.io.IOException;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.impl.nio.ClientHttp1IOEventHandler;
import org.apache.hc.core5.http.impl.nio.ClientHttp1StreamDuplexerFactory;
import org.apache.hc.core5.reactor.ProtocolIOSession;
import org.apache.hc.core5.reactor.ProtocolUpgradeHandler;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
@Internal
public class ClientHttp1UpgradeHandler
implements ProtocolUpgradeHandler {
    private final ClientHttp1StreamDuplexerFactory http1StreamHandlerFactory;

    public ClientHttp1UpgradeHandler(ClientHttp1StreamDuplexerFactory clientHttp1StreamDuplexerFactory) {
        this.http1StreamHandlerFactory = Args.notNull(clientHttp1StreamDuplexerFactory, "HTTP/1.1 stream handler factory");
    }

    @Override
    public void upgrade(ProtocolIOSession protocolIOSession, FutureCallback<ProtocolIOSession> futureCallback) {
        ClientHttp1IOEventHandler clientHttp1IOEventHandler = new ClientHttp1IOEventHandler(this.http1StreamHandlerFactory.create(protocolIOSession));
        protocolIOSession.upgrade(clientHttp1IOEventHandler);
        try {
            clientHttp1IOEventHandler.connected(protocolIOSession);
            if (futureCallback != null) {
                futureCallback.completed(protocolIOSession);
            }
            return;
        }
        catch (IOException iOException) {
            clientHttp1IOEventHandler.exception(protocolIOSession, iOException);
            return;
        }
    }
}

