/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.impl.nio.ClientHttp1IOEventHandler;
import org.apache.hc.core5.http.impl.nio.ClientHttp1StreamDuplexerFactory;
import org.apache.hc.core5.http.impl.nio.HttpConnectionEventHandler;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.http2.impl.nio.ClientH2PrefaceHandler;
import org.apache.hc.core5.http2.impl.nio.ClientH2StreamMultiplexerFactory;
import org.apache.hc.core5.http2.impl.nio.ClientH2UpgradeHandler;
import org.apache.hc.core5.http2.impl.nio.ClientHttp1UpgradeHandler;
import org.apache.hc.core5.http2.impl.nio.HttpProtocolNegotiator;
import org.apache.hc.core5.http2.ssl.ApplicationProtocol;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.reactor.EndpointParameters;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.ProtocolIOSession;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Timeout;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
@Internal
public class ClientHttpProtocolNegotiationStarter
implements IOEventHandlerFactory {
    private final ClientHttp1StreamDuplexerFactory http1StreamHandlerFactory;
    private final ClientH2StreamMultiplexerFactory http2StreamHandlerFactory;
    private final HttpVersionPolicy versionPolicy;
    private final TlsStrategy tlsStrategy;
    private final Timeout handshakeTimeout;
    private final Callback<Exception> exceptionCallback;

    public ClientHttpProtocolNegotiationStarter(ClientHttp1StreamDuplexerFactory clientHttp1StreamDuplexerFactory, ClientH2StreamMultiplexerFactory clientH2StreamMultiplexerFactory, HttpVersionPolicy httpVersionPolicy, TlsStrategy tlsStrategy, Timeout timeout, Callback<Exception> callback) {
        this.http1StreamHandlerFactory = Args.notNull(clientHttp1StreamDuplexerFactory, "HTTP/1.1 stream handler factory");
        this.http2StreamHandlerFactory = Args.notNull(clientH2StreamMultiplexerFactory, "HTTP/2 stream handler factory");
        this.versionPolicy = httpVersionPolicy != null ? httpVersionPolicy : HttpVersionPolicy.NEGOTIATE;
        this.tlsStrategy = tlsStrategy;
        this.handshakeTimeout = timeout;
        this.exceptionCallback = callback;
    }

    @Override
    public HttpConnectionEventHandler createHandler(ProtocolIOSession protocolIOSession, Object object) {
        HttpVersionPolicy httpVersionPolicy = this.versionPolicy;
        if (object instanceof EndpointParameters) {
            object = (EndpointParameters)object;
            if (this.tlsStrategy != null && URIScheme.HTTPS.same(((EndpointParameters)object).getScheme())) {
                Object object2 = object;
                this.tlsStrategy.upgrade(protocolIOSession, (NamedEndpoint)object2, ((EndpointParameters)object2).getAttachment(), this.handshakeTimeout, null);
            }
            if (((EndpointParameters)object).getAttachment() instanceof HttpVersionPolicy) {
                httpVersionPolicy = (HttpVersionPolicy)((Object)((EndpointParameters)object).getAttachment());
            }
        }
        protocolIOSession.registerProtocol(ApplicationProtocol.HTTP_1_1.id, new ClientHttp1UpgradeHandler(this.http1StreamHandlerFactory));
        protocolIOSession.registerProtocol(ApplicationProtocol.HTTP_2.id, new ClientH2UpgradeHandler(this.http2StreamHandlerFactory, this.exceptionCallback));
        switch (httpVersionPolicy) {
            case FORCE_HTTP_2: {
                return new ClientH2PrefaceHandler(protocolIOSession, this.http2StreamHandlerFactory, false, this.exceptionCallback);
            }
            case FORCE_HTTP_1: {
                return new ClientHttp1IOEventHandler(this.http1StreamHandlerFactory.create(protocolIOSession));
            }
        }
        return new HttpProtocolNegotiator(protocolIOSession, null);
    }
}

