/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLSession;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.EndpointDetails;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.impl.nio.HttpConnectionEventHandler;
import org.apache.hc.core5.http.nio.command.CommandSupport;
import org.apache.hc.core5.http2.impl.nio.ProtocolNegotiationException;
import org.apache.hc.core5.http2.ssl.ApplicationProtocol;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.SocketTimeoutExceptionFactory;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.ProtocolIOSession;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TextUtils;
import org.apache.hc.core5.util.Timeout;

@Internal
public class HttpProtocolNegotiator
implements HttpConnectionEventHandler {
    private final ProtocolIOSession ioSession;
    private final FutureCallback<ProtocolIOSession> resultCallback;
    private final AtomicBoolean completed;
    private final AtomicReference<ProtocolVersion> negotiatedProtocolRef;

    public HttpProtocolNegotiator(ProtocolIOSession protocolIOSession, FutureCallback<ProtocolIOSession> futureCallback) {
        this.ioSession = Args.notNull(protocolIOSession, "I/O session");
        this.resultCallback = futureCallback;
        this.completed = new AtomicBoolean();
        this.negotiatedProtocolRef = new AtomicReference();
    }

    void startProtocol(HttpVersion httpVersion) {
        this.ioSession.switchProtocol(httpVersion == HttpVersion.HTTP_2 ? ApplicationProtocol.HTTP_2.id : ApplicationProtocol.HTTP_1_1.id, this.resultCallback);
        this.negotiatedProtocolRef.set(httpVersion);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void connected(IOSession object) throws IOException {
        object = this.ioSession.getTlsDetails();
        if (object != null) {
            if (TextUtils.isEmpty((CharSequence)(object = ((TlsDetails)object).getApplicationProtocol()))) {
                object = HttpVersion.HTTP_1_1;
            } else if (((String)object).equals(ApplicationProtocol.HTTP_1_1.id)) {
                object = HttpVersion.HTTP_1_1;
            } else {
                if (!((String)object).equals(ApplicationProtocol.HTTP_2.id)) throw new ProtocolNegotiationException("Unsupported application protocol: " + (String)object);
                object = HttpVersion.HTTP_2;
            }
        } else {
            object = HttpVersion.HTTP_1_1;
        }
        this.startProtocol((HttpVersion)object);
    }

    @Override
    public void inputReady(IOSession iOSession, ByteBuffer byteBuffer) throws IOException {
        throw new ProtocolNegotiationException("Unexpected input");
    }

    @Override
    public void outputReady(IOSession iOSession) throws IOException {
        throw new ProtocolNegotiationException("Unexpected output");
    }

    @Override
    public void timeout(IOSession iOSession, Timeout timeout) {
        this.exception(iOSession, SocketTimeoutExceptionFactory.create(timeout));
    }

    @Override
    public void exception(IOSession iOSession, Exception exception) {
        try {
            iOSession.close(CloseMode.IMMEDIATE);
            CommandSupport.failCommands(iOSession, exception);
            return;
        }
        catch (Exception exception2) {
            if (this.completed.compareAndSet(false, true) && this.resultCallback != null) {
                this.resultCallback.failed(exception2);
            }
            return;
        }
    }

    @Override
    public void disconnected(IOSession iOSession) {
        try {
            CommandSupport.cancelCommands(iOSession);
            if (this.completed.compareAndSet(false, true) && this.resultCallback != null) {
                this.resultCallback.failed(new ConnectionClosedException());
                return;
            }
        }
        catch (Throwable throwable) {
            if (this.completed.compareAndSet(false, true) && this.resultCallback != null) {
                this.resultCallback.failed(new ConnectionClosedException());
            }
            throw throwable;
        }
    }

    @Override
    public SSLSession getSSLSession() {
        TlsDetails tlsDetails = this.ioSession.getTlsDetails();
        if (tlsDetails != null) {
            return tlsDetails.getSSLSession();
        }
        return null;
    }

    @Override
    public EndpointDetails getEndpointDetails() {
        return null;
    }

    @Override
    public void setSocketTimeout(Timeout timeout) {
        this.ioSession.setSocketTimeout(timeout);
    }

    @Override
    public Timeout getSocketTimeout() {
        return this.ioSession.getSocketTimeout();
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.negotiatedProtocolRef.get();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.ioSession.getRemoteAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.ioSession.getLocalAddress();
    }

    @Override
    public boolean isOpen() {
        return this.ioSession.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.ioSession.close();
    }

    @Override
    public void close(CloseMode closeMode) {
        this.ioSession.close(closeMode);
    }

    public String toString() {
        return this.getClass().getName();
    }
}

