/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.RequestHeaderFieldsTooLargeException;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.impl.BasicHttpConnectionMetrics;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.AsyncServerExchangeHandler;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.nio.command.ExecutableCommand;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http2.H2ConnectionException;
import org.apache.hc.core5.http2.H2Error;
import org.apache.hc.core5.http2.config.H2Config;
import org.apache.hc.core5.http2.frame.DefaultFrameFactory;
import org.apache.hc.core5.http2.frame.FrameFactory;
import org.apache.hc.core5.http2.frame.StreamIdGenerator;
import org.apache.hc.core5.http2.hpack.HeaderListConstraintException;
import org.apache.hc.core5.http2.impl.nio.AbstractH2StreamMultiplexer;
import org.apache.hc.core5.http2.impl.nio.H2StreamChannel;
import org.apache.hc.core5.http2.impl.nio.H2StreamHandler;
import org.apache.hc.core5.http2.impl.nio.H2StreamListener;
import org.apache.hc.core5.http2.impl.nio.ServerH2StreamHandler;
import org.apache.hc.core5.reactor.ProtocolIOSession;
import org.apache.hc.core5.util.Args;

@Internal
public class ServerH2StreamMultiplexer
extends AbstractH2StreamMultiplexer {
    private final HandlerFactory<AsyncServerExchangeHandler> exchangeHandlerFactory;

    public ServerH2StreamMultiplexer(ProtocolIOSession protocolIOSession, FrameFactory frameFactory, HttpProcessor httpProcessor, HandlerFactory<AsyncServerExchangeHandler> handlerFactory, CharCodingConfig charCodingConfig, H2Config h2Config, H2StreamListener h2StreamListener) {
        super(protocolIOSession, frameFactory, StreamIdGenerator.EVEN, httpProcessor, charCodingConfig, h2Config, h2StreamListener);
        this.exchangeHandlerFactory = Args.notNull(handlerFactory, "Handler factory");
    }

    public ServerH2StreamMultiplexer(ProtocolIOSession protocolIOSession, HttpProcessor httpProcessor, HandlerFactory<AsyncServerExchangeHandler> handlerFactory, CharCodingConfig charCodingConfig, H2Config h2Config) {
        this(protocolIOSession, DefaultFrameFactory.INSTANCE, httpProcessor, handlerFactory, charCodingConfig, h2Config, null);
    }

    @Override
    void acceptHeaderFrame() throws H2ConnectionException {
    }

    @Override
    void acceptPushRequest() throws H2ConnectionException {
    }

    @Override
    void acceptPushFrame() throws H2ConnectionException {
        throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Push not supported");
    }

    @Override
    H2StreamHandler createRemotelyInitiatedStream(H2StreamChannel h2StreamChannel, HttpProcessor httpProcessor, BasicHttpConnectionMetrics basicHttpConnectionMetrics, HandlerFactory<AsyncPushConsumer> object) throws IOException {
        object = HttpCoreContext.create();
        ((HttpCoreContext)object).setSSLSession(this.getSSLSession());
        ((HttpCoreContext)object).setEndpointDetails(this.getEndpointDetails());
        return new ServerH2StreamHandler(h2StreamChannel, httpProcessor, basicHttpConnectionMetrics, this.exchangeHandlerFactory, (HttpCoreContext)object);
    }

    @Override
    H2StreamHandler createLocallyInitiatedStream(ExecutableCommand executableCommand, H2StreamChannel h2StreamChannel, HttpProcessor httpProcessor, BasicHttpConnectionMetrics basicHttpConnectionMetrics) throws IOException {
        throw new H2ConnectionException(H2Error.INTERNAL_ERROR, "Illegal attempt to execute a request");
    }

    @Override
    List<Header> decodeHeaders(ByteBuffer byteBuffer) throws HttpException {
        try {
            return super.decodeHeaders(byteBuffer);
        }
        catch (HeaderListConstraintException headerListConstraintException) {
            throw new RequestHeaderFieldsTooLargeException(headerListConstraintException.getMessage(), headerListConstraintException);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        this.appendState(stringBuilder);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

