/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio.bootstrap;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.concurrent.Cancellable;
import org.apache.hc.core5.concurrent.CancellableDependency;

final class CancellableExecution
implements CancellableDependency {
    private final AtomicBoolean cancelled = new AtomicBoolean();
    private final AtomicReference<Cancellable> dependencyRef = new AtomicReference();

    CancellableExecution() {
    }

    @Override
    public final void setDependency(Cancellable cancellable) {
        this.dependencyRef.set(cancellable);
        if (this.cancelled.get() && (cancellable = (Cancellable)this.dependencyRef.getAndSet(null)) != null) {
            cancellable.cancel();
        }
    }

    @Override
    public final boolean isCancelled() {
        return this.cancelled.get();
    }

    @Override
    public final boolean cancel() {
        if (this.cancelled.compareAndSet(false, true)) {
            Cancellable cancellable = this.dependencyRef.getAndSet(null);
            if (cancellable != null) {
                cancellable.cancel();
            }
            return true;
        }
        return false;
    }
}

