/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio.bootstrap;

import java.util.ArrayList;
import java.util.List;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.function.Decorator;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.HttpRequestMapper;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.impl.DefaultAddressResolver;
import org.apache.hc.core5.http.impl.routing.RequestRouter;
import org.apache.hc.core5.http.impl.routing.RequestRouter$Entry;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http.protocol.UriPatternType;
import org.apache.hc.core5.http2.config.H2Config;
import org.apache.hc.core5.http2.impl.H2Processors;
import org.apache.hc.core5.http2.impl.nio.ClientH2PrefaceHandler;
import org.apache.hc.core5.http2.impl.nio.ClientH2StreamMultiplexerFactory;
import org.apache.hc.core5.http2.impl.nio.H2StreamListener;
import org.apache.hc.core5.http2.impl.nio.bootstrap.H2MultiplexingRequester;
import org.apache.hc.core5.http2.nio.support.DefaultAsyncPushConsumerFactory;
import org.apache.hc.core5.http2.ssl.H2ClientTlsStrategy;
import org.apache.hc.core5.reactor.IOEventHandler;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.IOSessionListener;
import org.apache.hc.core5.reactor.ProtocolIOSession;
import org.apache.hc.core5.util.Args;

public class H2MultiplexingRequesterBootstrap {
    private final List<RequestRouter$Entry<Supplier<AsyncPushConsumer>>> routeEntries = new ArrayList<RequestRouter$Entry<Supplier<AsyncPushConsumer>>>();
    private UriPatternType uriPatternType;
    private IOReactorConfig ioReactorConfig;
    private HttpProcessor httpProcessor;
    private CharCodingConfig charCodingConfig;
    private H2Config h2Config;
    private TlsStrategy tlsStrategy;
    private boolean strictALPNHandshake;
    private Decorator<IOSession> ioSessionDecorator;
    private Callback<Exception> exceptionCallback;
    private IOSessionListener sessionListener;
    private H2StreamListener streamListener;

    private H2MultiplexingRequesterBootstrap() {
    }

    public static H2MultiplexingRequesterBootstrap bootstrap() {
        return new H2MultiplexingRequesterBootstrap();
    }

    public final H2MultiplexingRequesterBootstrap setIOReactorConfig(IOReactorConfig iOReactorConfig) {
        this.ioReactorConfig = iOReactorConfig;
        return this;
    }

    public final H2MultiplexingRequesterBootstrap setHttpProcessor(HttpProcessor httpProcessor) {
        this.httpProcessor = httpProcessor;
        return this;
    }

    public final H2MultiplexingRequesterBootstrap setH2Config(H2Config h2Config) {
        this.h2Config = h2Config;
        return this;
    }

    public final H2MultiplexingRequesterBootstrap setCharCodingConfig(CharCodingConfig charCodingConfig) {
        this.charCodingConfig = charCodingConfig;
        return this;
    }

    public final H2MultiplexingRequesterBootstrap setTlsStrategy(TlsStrategy tlsStrategy) {
        this.tlsStrategy = tlsStrategy;
        return this;
    }

    public final H2MultiplexingRequesterBootstrap setStrictALPNHandshake(boolean bl2) {
        this.strictALPNHandshake = bl2;
        return this;
    }

    public final H2MultiplexingRequesterBootstrap setIOSessionDecorator(Decorator<IOSession> decorator) {
        this.ioSessionDecorator = decorator;
        return this;
    }

    public final H2MultiplexingRequesterBootstrap setExceptionCallback(Callback<Exception> callback) {
        this.exceptionCallback = callback;
        return this;
    }

    public final H2MultiplexingRequesterBootstrap setIOSessionListener(IOSessionListener iOSessionListener) {
        this.sessionListener = iOSessionListener;
        return this;
    }

    public final H2MultiplexingRequesterBootstrap setStreamListener(H2StreamListener h2StreamListener) {
        this.streamListener = h2StreamListener;
        return this;
    }

    public final H2MultiplexingRequesterBootstrap setUriPatternType(UriPatternType uriPatternType) {
        this.uriPatternType = uriPatternType;
        return this;
    }

    public final H2MultiplexingRequesterBootstrap register(String string, Supplier<AsyncPushConsumer> supplier) {
        Args.notBlank(string, "URI pattern");
        Args.notNull(supplier, "Push consumer supplier");
        this.routeEntries.add(new RequestRouter$Entry<Supplier<AsyncPushConsumer>>(string, supplier));
        return this;
    }

    public final H2MultiplexingRequesterBootstrap register(String string, String string2, Supplier<AsyncPushConsumer> supplier) {
        Args.notBlank(string, "Hostname");
        Args.notBlank(string2, "URI pattern");
        Args.notNull(supplier, "Push consumer supplier");
        this.routeEntries.add(new RequestRouter$Entry<Supplier<AsyncPushConsumer>>(string, string2, supplier));
        return this;
    }

    @Deprecated
    public final H2MultiplexingRequesterBootstrap registerVirtual(String string, String string2, Supplier<AsyncPushConsumer> supplier) {
        return this.register(string, string2, supplier);
    }

    public H2MultiplexingRequester create() {
        Object object = RequestRouter.create(null, this.uriPatternType, this.routeEntries, RequestRouter.LOCAL_AUTHORITY_RESOLVER, null);
        object = new ClientH2StreamMultiplexerFactory(this.httpProcessor != null ? this.httpProcessor : H2Processors.client(), new DefaultAsyncPushConsumerFactory((HttpRequestMapper<Supplier<AsyncPushConsumer>>)object), this.h2Config != null ? this.h2Config : H2Config.DEFAULT, this.charCodingConfig != null ? this.charCodingConfig : CharCodingConfig.DEFAULT, this.streamListener);
        return new H2MultiplexingRequester(this.ioReactorConfig, (arg_0, arg_1) -> this.lambda$create$0((ClientH2StreamMultiplexerFactory)object, arg_0, arg_1), this.ioSessionDecorator, this.exceptionCallback, this.sessionListener, DefaultAddressResolver.INSTANCE, this.tlsStrategy != null ? this.tlsStrategy : new H2ClientTlsStrategy());
    }

    private /* synthetic */ IOEventHandler lambda$create$0(ClientH2StreamMultiplexerFactory clientH2StreamMultiplexerFactory, ProtocolIOSession protocolIOSession, Object object) {
        return new ClientH2PrefaceHandler(protocolIOSession, clientH2StreamMultiplexerFactory, this.strictALPNHandshake, this.exceptionCallback);
    }
}

