/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.ssl;

import java.net.SocketAddress;
import javax.net.ssl.SSLContext;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http2.ssl.ConscryptSupport;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.reactor.ssl.SSLBufferMode;
import org.apache.hc.core5.reactor.ssl.SSLSessionInitializer;
import org.apache.hc.core5.reactor.ssl.SSLSessionVerifier;
import org.apache.hc.core5.reactor.ssl.TransportSecurityLayer;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Timeout;

public class ConscryptClientTlsStrategy
implements TlsStrategy {
    private final SSLContext sslContext;
    private final SSLBufferMode sslBufferMode;
    private final SSLSessionInitializer initializer;
    private final SSLSessionVerifier verifier;

    public ConscryptClientTlsStrategy(SSLContext sSLContext, SSLBufferMode sSLBufferMode, SSLSessionInitializer sSLSessionInitializer, SSLSessionVerifier sSLSessionVerifier) {
        this.sslContext = Args.notNull(sSLContext, "SSL context");
        this.sslBufferMode = sSLBufferMode;
        this.initializer = sSLSessionInitializer;
        this.verifier = sSLSessionVerifier;
    }

    public ConscryptClientTlsStrategy(SSLContext sSLContext, SSLSessionInitializer sSLSessionInitializer, SSLSessionVerifier sSLSessionVerifier) {
        this(sSLContext, null, sSLSessionInitializer, sSLSessionVerifier);
    }

    public ConscryptClientTlsStrategy(SSLContext sSLContext, SSLSessionVerifier sSLSessionVerifier) {
        this(sSLContext, null, null, sSLSessionVerifier);
    }

    public ConscryptClientTlsStrategy(SSLContext sSLContext) {
        this(sSLContext, null, null, null);
    }

    public ConscryptClientTlsStrategy() {
        this(SSLContexts.createSystemDefault(), null, null, null);
    }

    public ConscryptClientTlsStrategy(SSLSessionVerifier sSLSessionVerifier) {
        this(SSLContexts.createSystemDefault(), sSLSessionVerifier);
    }

    @Override
    public void upgrade(TransportSecurityLayer transportSecurityLayer, NamedEndpoint namedEndpoint, Object object, Timeout timeout, FutureCallback<TransportSecurityLayer> futureCallback) {
        transportSecurityLayer.startTls(this.sslContext, namedEndpoint, this.sslBufferMode, ConscryptSupport.initialize(object, this.initializer), ConscryptSupport.verify(this.verifier), timeout, futureCallback);
    }

    @Override
    @Deprecated
    public boolean upgrade(TransportSecurityLayer transportSecurityLayer, HttpHost httpHost, SocketAddress object, SocketAddress socketAddress, Object object2, Timeout timeout) {
        Object object3 = object = httpHost != null ? httpHost.getSchemeName() : null;
        if (URIScheme.HTTPS.same((String)object)) {
            this.upgrade(transportSecurityLayer, httpHost, object2, timeout, null);
            return true;
        }
        return false;
    }
}

