/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.ssl;

import java.net.SocketAddress;
import javax.net.ssl.SSLContext;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.nio.ssl.FixedPortStrategy;
import org.apache.hc.core5.http.nio.ssl.SecurePortStrategy;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http2.ssl.ConscryptSupport;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.reactor.ssl.SSLBufferMode;
import org.apache.hc.core5.reactor.ssl.SSLSessionInitializer;
import org.apache.hc.core5.reactor.ssl.SSLSessionVerifier;
import org.apache.hc.core5.reactor.ssl.TransportSecurityLayer;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Timeout;

public class ConscryptServerTlsStrategy
implements TlsStrategy {
    private final SSLContext sslContext;
    private final SecurePortStrategy securePortStrategy;
    private final SSLBufferMode sslBufferMode;
    private final SSLSessionInitializer initializer;
    private final SSLSessionVerifier verifier;

    @Deprecated
    public ConscryptServerTlsStrategy(SSLContext sSLContext, SecurePortStrategy securePortStrategy, SSLBufferMode sSLBufferMode, SSLSessionInitializer sSLSessionInitializer, SSLSessionVerifier sSLSessionVerifier) {
        this.sslContext = Args.notNull(sSLContext, "SSL context");
        this.securePortStrategy = securePortStrategy;
        this.sslBufferMode = sSLBufferMode;
        this.initializer = sSLSessionInitializer;
        this.verifier = sSLSessionVerifier;
    }

    @Deprecated
    public ConscryptServerTlsStrategy(SSLContext sSLContext, SecurePortStrategy securePortStrategy, SSLSessionInitializer sSLSessionInitializer, SSLSessionVerifier sSLSessionVerifier) {
        this(sSLContext, securePortStrategy, null, sSLSessionInitializer, sSLSessionVerifier);
    }

    @Deprecated
    public ConscryptServerTlsStrategy(SSLContext sSLContext, SecurePortStrategy securePortStrategy, SSLSessionVerifier sSLSessionVerifier) {
        this(sSLContext, securePortStrategy, null, null, sSLSessionVerifier);
    }

    @Deprecated
    public ConscryptServerTlsStrategy(SSLContext sSLContext, SecurePortStrategy securePortStrategy) {
        this(sSLContext, securePortStrategy, null, null, null);
    }

    @Deprecated
    public ConscryptServerTlsStrategy(SSLContext sSLContext, int ... nArray) {
        this(sSLContext, new FixedPortStrategy(nArray));
    }

    public ConscryptServerTlsStrategy(SSLContext sSLContext, SSLBufferMode sSLBufferMode, SSLSessionInitializer sSLSessionInitializer, SSLSessionVerifier sSLSessionVerifier) {
        this.sslContext = Args.notNull(sSLContext, "SSL context");
        this.sslBufferMode = sSLBufferMode;
        this.initializer = sSLSessionInitializer;
        this.verifier = sSLSessionVerifier;
        this.securePortStrategy = null;
    }

    public ConscryptServerTlsStrategy(SSLContext sSLContext, SSLSessionInitializer sSLSessionInitializer, SSLSessionVerifier sSLSessionVerifier) {
        this(sSLContext, (SSLBufferMode)null, sSLSessionInitializer, sSLSessionVerifier);
    }

    public ConscryptServerTlsStrategy(SSLContext sSLContext, SSLSessionVerifier sSLSessionVerifier) {
        this(sSLContext, (SSLBufferMode)null, (SSLSessionInitializer)null, sSLSessionVerifier);
    }

    public ConscryptServerTlsStrategy(SSLContext sSLContext) {
        this(sSLContext, (SSLBufferMode)null, (SSLSessionInitializer)null, (SSLSessionVerifier)null);
    }

    public ConscryptServerTlsStrategy() {
        this(SSLContexts.createSystemDefault(), (SSLBufferMode)null, (SSLSessionInitializer)null, (SSLSessionVerifier)null);
    }

    public ConscryptServerTlsStrategy(SSLSessionVerifier sSLSessionVerifier) {
        this(SSLContexts.createSystemDefault(), (SSLBufferMode)null, (SSLSessionInitializer)null, sSLSessionVerifier);
    }

    private boolean isApplicable(SocketAddress socketAddress) {
        return this.securePortStrategy == null || this.securePortStrategy.isSecure(socketAddress);
    }

    @Override
    public void upgrade(TransportSecurityLayer transportSecurityLayer, NamedEndpoint namedEndpoint, Object object, Timeout timeout, FutureCallback<TransportSecurityLayer> futureCallback) {
        transportSecurityLayer.startTls(this.sslContext, namedEndpoint, this.sslBufferMode, ConscryptSupport.initialize(object, this.initializer), ConscryptSupport.verify(this.verifier), timeout, futureCallback);
    }

    @Override
    @Deprecated
    public boolean upgrade(TransportSecurityLayer transportSecurityLayer, HttpHost httpHost, SocketAddress socketAddress, SocketAddress socketAddress2, Object object, Timeout timeout) {
        if (this.isApplicable(socketAddress)) {
            this.upgrade(transportSecurityLayer, httpHost, object, timeout, null);
            return true;
        }
        return false;
    }
}

