/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.net;

import java.io.Serializable;
import java.net.IDN;
import java.net.URISyntaxException;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.net.InetAddressUtils;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.net.Ports;
import org.apache.hc.core5.net.URISupport;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.LangUtils;
import org.apache.hc.core5.util.TextUtils;
import org.apache.hc.core5.util.Tokenizer;
import org.apache.hc.core5.util.Tokenizer$Cursor;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public final class Host
implements Serializable,
NamedEndpoint {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String lcName;
    private final int port;

    static boolean isPunyCode(CharSequence charSequence) {
        if (charSequence == null || charSequence.length() < 4) {
            return false;
        }
        return !(charSequence.charAt(0) != 'x' && charSequence.charAt(0) != 'X' || charSequence.charAt(1) != 'n' && charSequence.charAt(1) != 'N' || charSequence.charAt(2) != '-' || charSequence.charAt(3) != '-');
    }

    public Host(String string, int n2) {
        Args.notNull(string, "Host name");
        Ports.checkWithDefault(n2);
        this.name = Host.isPunyCode(string) ? IDN.toUnicode(string) : string;
        this.port = n2;
        this.lcName = TextUtils.toLowerCase(this.name);
    }

    static Host parse(CharSequence charSequence, Tokenizer$Cursor tokenizer$Cursor) throws URISyntaxException {
        int n2;
        String string;
        Tokenizer tokenizer = Tokenizer.INSTANCE;
        boolean bl2 = !tokenizer$Cursor.atEnd() && charSequence.charAt(tokenizer$Cursor.getPos()) == '[';
        if (bl2) {
            Tokenizer$Cursor tokenizer$Cursor2 = tokenizer$Cursor;
            tokenizer$Cursor2.updatePos(tokenizer$Cursor2.getPos() + 1);
            string = tokenizer.parseContent(charSequence, tokenizer$Cursor, URISupport.IPV6_HOST_DELIMITERS);
            if (tokenizer$Cursor.atEnd() || charSequence.charAt(tokenizer$Cursor.getPos()) != ']') {
                throw URISupport.createException(charSequence, tokenizer$Cursor, "Expected an IPv6 closing bracket ']'");
            }
            Tokenizer$Cursor tokenizer$Cursor3 = tokenizer$Cursor;
            tokenizer$Cursor3.updatePos(tokenizer$Cursor3.getPos() + 1);
            if (!InetAddressUtils.isIPv6(string)) {
                throw URISupport.createException(charSequence, tokenizer$Cursor, "Expected an IPv6 address");
            }
        } else {
            string = tokenizer.parseContent(charSequence, tokenizer$Cursor, URISupport.PORT_DELIMITERS);
        }
        String string2 = null;
        if (!tokenizer$Cursor.atEnd() && charSequence.charAt(tokenizer$Cursor.getPos()) == ':') {
            Tokenizer$Cursor tokenizer$Cursor4 = tokenizer$Cursor;
            tokenizer$Cursor4.updatePos(tokenizer$Cursor4.getPos() + 1);
            string2 = tokenizer.parseContent(charSequence, tokenizer$Cursor, URISupport.DELIMITERS);
        }
        if (!TextUtils.isBlank(string2)) {
            if (!bl2 && string2.contains(":")) {
                throw URISupport.createException(charSequence, tokenizer$Cursor, "Expected IPv6 address to be enclosed in brackets");
            }
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw URISupport.createException(charSequence, tokenizer$Cursor, "Port is invalid");
            }
        } else {
            n2 = -1;
        }
        return new Host(string, n2);
    }

    static Host parse(CharSequence charSequence) throws URISyntaxException {
        Tokenizer$Cursor tokenizer$Cursor = new Tokenizer$Cursor(0, charSequence.length());
        return Host.parse(charSequence, tokenizer$Cursor);
    }

    static void format(StringBuilder stringBuilder, NamedEndpoint namedEndpoint) {
        String string = namedEndpoint.getHostName();
        if (InetAddressUtils.isIPv6(string)) {
            stringBuilder.append('[').append(string).append(']');
        } else if (TextUtils.isAllASCII(string)) {
            stringBuilder.append(string);
        } else {
            stringBuilder.append(IDN.toASCII(string));
        }
        if (namedEndpoint.getPort() != -1) {
            stringBuilder.append(":");
            stringBuilder.append(namedEndpoint.getPort());
        }
    }

    static void format(StringBuilder stringBuilder, Host host) {
        Host.format(stringBuilder, (NamedEndpoint)host);
    }

    static String format(Host host) {
        StringBuilder stringBuilder = new StringBuilder();
        Host.format(stringBuilder, host);
        return stringBuilder.toString();
    }

    public static Host create(String string) throws URISyntaxException {
        Args.notEmpty(string, "HTTP Host");
        Tokenizer$Cursor tokenizer$Cursor = new Tokenizer$Cursor(0, string.length());
        Host host = Host.parse(string, tokenizer$Cursor);
        if (TextUtils.isBlank(host.getHostName())) {
            throw URISupport.createException(string, tokenizer$Cursor, "Hostname is invalid");
        }
        if (!tokenizer$Cursor.atEnd()) {
            throw URISupport.createException(string, tokenizer$Cursor, "Unexpected content");
        }
        return host;
    }

    @Override
    public final String getHostName() {
        return this.name;
    }

    @Override
    public final int getPort() {
        return this.port;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Host) {
            object = (Host)object;
            return this.lcName.equals(((Host)object).lcName) && this.port == ((Host)object).port;
        }
        return false;
    }

    public final int hashCode() {
        int n2 = LangUtils.hashCode(17, this.lcName);
        n2 = LangUtils.hashCode(n2, this.port);
        return n2;
    }

    public final String toString() {
        return Host.format(this);
    }
}

