/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.net;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;

public class PercentCodec {
    static final BitSet GEN_DELIMS;
    static final BitSet SUB_DELIMS;
    static final BitSet UNRESERVED;
    static final BitSet URIC;
    static final BitSet RFC5987_UNRESERVED;
    private static final int RADIX = 16;
    public static final PercentCodec RFC3986;
    public static final PercentCodec RFC5987;
    private final BitSet unreserved;

    static void encode(StringBuilder stringBuilder, CharSequence object, Charset charset, BitSet bitSet, boolean bl2) {
        if (object == null) {
            return;
        }
        object = CharBuffer.wrap((CharSequence)object);
        object = (charset != null ? charset : StandardCharsets.UTF_8).encode((CharBuffer)object);
        while (((Buffer)object).hasRemaining()) {
            int n2 = ((ByteBuffer)object).get() & 0xFF;
            if (bitSet.get(n2)) {
                stringBuilder.append((char)n2);
                continue;
            }
            if (bl2 && n2 == 32) {
                stringBuilder.append("+");
                continue;
            }
            stringBuilder.append("%");
            char c2 = Character.toUpperCase(Character.forDigit(n2 >> 4 & 0xF, 16));
            n2 = Character.toUpperCase(Character.forDigit(n2 & 0xF, 16));
            stringBuilder.append(c2);
            stringBuilder.append((char)n2);
        }
    }

    static void encode(StringBuilder stringBuilder, CharSequence charSequence, Charset charset, boolean bl2) {
        PercentCodec.encode(stringBuilder, charSequence, charset, UNRESERVED, bl2);
    }

    public static void encode(StringBuilder stringBuilder, CharSequence charSequence, Charset charset) {
        PercentCodec.encode(stringBuilder, charSequence, charset, UNRESERVED, false);
    }

    public static String encode(CharSequence charSequence, Charset charset) {
        if (charSequence == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        PercentCodec.encode(stringBuilder, charSequence, charset, UNRESERVED, false);
        return stringBuilder.toString();
    }

    static String decode(CharSequence charSequence, Charset charset, boolean bl2) {
        if (charSequence == null) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(charSequence.length());
        charSequence = CharBuffer.wrap(charSequence);
        while (((Buffer)((Object)charSequence)).hasRemaining()) {
            char c2 = ((CharBuffer)charSequence).get();
            if (c2 == '%' && ((Buffer)((Object)charSequence)).remaining() >= 2) {
                c2 = ((CharBuffer)charSequence).get();
                char c3 = ((CharBuffer)charSequence).get();
                int n2 = Character.digit(c2, 16);
                int n3 = Character.digit(c3, 16);
                if (n2 != -1 && n3 != -1) {
                    byteBuffer.put((byte)((n2 << 4) + n3));
                    continue;
                }
                byteBuffer.put((byte)37);
                byteBuffer.put((byte)c2);
                byteBuffer.put((byte)c3);
                continue;
            }
            if (bl2 && c2 == '+') {
                byteBuffer.put((byte)32);
                continue;
            }
            byteBuffer.put((byte)c2);
        }
        byteBuffer.flip();
        return (charset != null ? charset : StandardCharsets.UTF_8).decode(byteBuffer).toString();
    }

    public static String decode(CharSequence charSequence, Charset charset) {
        return PercentCodec.decode(charSequence, charset, false);
    }

    private PercentCodec(BitSet bitSet) {
        this.unreserved = bitSet;
    }

    public PercentCodec() {
        this.unreserved = UNRESERVED;
    }

    public void encode(StringBuilder stringBuilder, CharSequence charSequence) {
        PercentCodec.encode(stringBuilder, charSequence, StandardCharsets.UTF_8, this.unreserved, false);
    }

    public String encode(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        PercentCodec.encode(stringBuilder, charSequence, StandardCharsets.UTF_8, this.unreserved, false);
        return stringBuilder.toString();
    }

    public String decode(CharSequence charSequence) {
        return PercentCodec.decode(charSequence, StandardCharsets.UTF_8, false);
    }

    static {
        int n2;
        GEN_DELIMS = new BitSet(256);
        SUB_DELIMS = new BitSet(256);
        UNRESERVED = new BitSet(256);
        URIC = new BitSet(256);
        GEN_DELIMS.set(58);
        GEN_DELIMS.set(47);
        GEN_DELIMS.set(63);
        GEN_DELIMS.set(35);
        GEN_DELIMS.set(91);
        GEN_DELIMS.set(93);
        GEN_DELIMS.set(64);
        SUB_DELIMS.set(33);
        SUB_DELIMS.set(36);
        SUB_DELIMS.set(38);
        SUB_DELIMS.set(39);
        SUB_DELIMS.set(40);
        SUB_DELIMS.set(41);
        SUB_DELIMS.set(42);
        SUB_DELIMS.set(43);
        SUB_DELIMS.set(44);
        SUB_DELIMS.set(59);
        SUB_DELIMS.set(61);
        for (n2 = 97; n2 <= 122; ++n2) {
            UNRESERVED.set(n2);
        }
        for (n2 = 65; n2 <= 90; ++n2) {
            UNRESERVED.set(n2);
        }
        for (n2 = 48; n2 <= 57; ++n2) {
            UNRESERVED.set(n2);
        }
        UNRESERVED.set(45);
        UNRESERVED.set(46);
        UNRESERVED.set(95);
        UNRESERVED.set(126);
        URIC.or(SUB_DELIMS);
        URIC.or(UNRESERVED);
        RFC5987_UNRESERVED = new BitSet(256);
        for (n2 = 97; n2 <= 122; ++n2) {
            RFC5987_UNRESERVED.set(n2);
        }
        for (n2 = 65; n2 <= 90; ++n2) {
            RFC5987_UNRESERVED.set(n2);
        }
        for (n2 = 48; n2 <= 57; ++n2) {
            RFC5987_UNRESERVED.set(n2);
        }
        RFC5987_UNRESERVED.set(33);
        RFC5987_UNRESERVED.set(35);
        RFC5987_UNRESERVED.set(36);
        RFC5987_UNRESERVED.set(38);
        RFC5987_UNRESERVED.set(43);
        RFC5987_UNRESERVED.set(45);
        RFC5987_UNRESERVED.set(46);
        RFC5987_UNRESERVED.set(94);
        RFC5987_UNRESERVED.set(95);
        RFC5987_UNRESERVED.set(96);
        RFC5987_UNRESERVED.set(124);
        RFC5987_UNRESERVED.set(126);
        RFC3986 = new PercentCodec(UNRESERVED);
        RFC5987 = new PercentCodec(RFC5987_UNRESERVED);
    }
}

