/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.net;

import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.Objects;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.net.Host;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.net.URISupport;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.LangUtils;
import org.apache.hc.core5.util.TextUtils;
import org.apache.hc.core5.util.Tokenizer;
import org.apache.hc.core5.util.Tokenizer$Cursor;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public final class URIAuthority
implements Serializable,
NamedEndpoint {
    private static final long serialVersionUID = 1L;
    private final String userInfo;
    private final Host host;

    static URIAuthority parse(CharSequence object, Tokenizer$Cursor tokenizer$Cursor) throws URISyntaxException {
        Object object2 = Tokenizer.INSTANCE;
        Object object3 = null;
        int n2 = tokenizer$Cursor.getPos();
        object2 = ((Tokenizer)object2).parseContent((CharSequence)object, tokenizer$Cursor, URISupport.HOST_DELIMITERS);
        if (!tokenizer$Cursor.atEnd() && object.charAt(tokenizer$Cursor.getPos()) == '@') {
            Tokenizer$Cursor tokenizer$Cursor2 = tokenizer$Cursor;
            tokenizer$Cursor2.updatePos(tokenizer$Cursor2.getPos() + 1);
            if (!TextUtils.isBlank((CharSequence)object2)) {
                object3 = object2;
            }
        } else {
            tokenizer$Cursor.updatePos(n2);
        }
        object = Host.parse((CharSequence)object, tokenizer$Cursor);
        return new URIAuthority((String)object3, (Host)object);
    }

    static URIAuthority parse(CharSequence charSequence) throws URISyntaxException {
        Tokenizer$Cursor tokenizer$Cursor = new Tokenizer$Cursor(0, charSequence.length());
        return URIAuthority.parse(charSequence, tokenizer$Cursor);
    }

    static void format(StringBuilder stringBuilder, URIAuthority uRIAuthority) {
        if (uRIAuthority.getUserInfo() != null) {
            stringBuilder.append(uRIAuthority.getUserInfo());
            stringBuilder.append("@");
        }
        Host.format(stringBuilder, uRIAuthority);
    }

    static String format(URIAuthority uRIAuthority) {
        StringBuilder stringBuilder = new StringBuilder();
        URIAuthority.format(stringBuilder, uRIAuthority);
        return stringBuilder.toString();
    }

    public URIAuthority(String string, String string2, int n2) {
        this.userInfo = string;
        this.host = new Host(string2, n2);
    }

    public URIAuthority(String string, int n2) {
        this(null, string, n2);
    }

    public URIAuthority(String string, Host host) {
        Args.notNull(host, "Host");
        this.userInfo = string;
        this.host = host;
    }

    public URIAuthority(Host host) {
        this(null, host);
    }

    public URIAuthority(String string, NamedEndpoint namedEndpoint) {
        Args.notNull(namedEndpoint, "Endpoint");
        this.userInfo = string;
        this.host = new Host(namedEndpoint.getHostName(), namedEndpoint.getPort());
    }

    public URIAuthority(NamedEndpoint namedEndpoint) {
        this(null, namedEndpoint);
    }

    public static URIAuthority create(String string) throws URISyntaxException {
        if (TextUtils.isBlank(string)) {
            return null;
        }
        Tokenizer$Cursor tokenizer$Cursor = new Tokenizer$Cursor(0, string.length());
        URIAuthority uRIAuthority = URIAuthority.parse(string, tokenizer$Cursor);
        if (!tokenizer$Cursor.atEnd()) {
            throw URISupport.createException(string, tokenizer$Cursor, "Unexpected content");
        }
        return uRIAuthority;
    }

    public URIAuthority(String string) {
        this(null, string, -1);
    }

    public final String getUserInfo() {
        return this.userInfo;
    }

    @Override
    public final String getHostName() {
        return this.host.getHostName();
    }

    @Override
    public final int getPort() {
        return this.host.getPort();
    }

    public final String toString() {
        return URIAuthority.format(this);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof URIAuthority) {
            object = (URIAuthority)object;
            return Objects.equals(this.userInfo, ((URIAuthority)object).userInfo) && Objects.equals(this.host, ((URIAuthority)object).host);
        }
        return false;
    }

    public final int hashCode() {
        int n2 = LangUtils.hashCode(17, this.userInfo);
        n2 = LangUtils.hashCode(n2, this.host);
        return n2;
    }
}

