/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.net;

import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.http.message.ParserCursor;
import org.apache.hc.core5.net.InetAddressUtils;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.net.PercentCodec;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TextUtils;
import org.apache.hc.core5.util.Tokenizer;
import org.apache.hc.core5.util.Tokenizer$Cursor;
import org.apache.hc.core5.util.Tokenizer$Delimiter;

public class URIBuilder {
    private String scheme;
    private String encodedSchemeSpecificPart;
    private String encodedAuthority;
    private String userInfo;
    private String encodedUserInfo;
    private String host;
    private int port;
    private String encodedPath;
    private boolean pathRootless;
    private List<String> pathSegments;
    private String encodedQuery;
    private List<NameValuePair> queryParams;
    private String query;
    private Charset charset;
    private String fragment;
    private String encodedFragment;
    private static final char QUERY_PARAM_SEPARATOR = '&';
    private static final char PARAM_VALUE_SEPARATOR = '=';
    private static final char PATH_SEPARATOR = '/';
    private static final Tokenizer$Delimiter QUERY_PARAM_SEPARATORS = Tokenizer.delimiters('&', '=');
    private static final Tokenizer$Delimiter QUERY_VALUE_SEPARATORS = Tokenizer.delimiters('&');

    public static URIBuilder localhost() throws UnknownHostException {
        return new URIBuilder().setHost(InetAddress.getLocalHost());
    }

    public static URIBuilder loopbackAddress() {
        return new URIBuilder().setHost(InetAddress.getLoopbackAddress());
    }

    public URIBuilder() {
        this.port = -1;
    }

    public URIBuilder(String string) throws URISyntaxException {
        this(new URI(string), StandardCharsets.UTF_8);
    }

    public URIBuilder(URI uRI) {
        this(uRI, StandardCharsets.UTF_8);
    }

    public URIBuilder(String string, Charset charset) throws URISyntaxException {
        this(new URI(string), charset);
    }

    public URIBuilder(URI uRI, Charset charset) {
        this.digestURI(uRI, charset);
    }

    public URIBuilder setAuthority(NamedEndpoint namedEndpoint) {
        this.setUserInfo(null);
        this.setHost(namedEndpoint.getHostName());
        this.setPort(namedEndpoint.getPort());
        return this;
    }

    public URIBuilder setAuthority(URIAuthority uRIAuthority) {
        this.setUserInfo(uRIAuthority.getUserInfo());
        this.setHost(uRIAuthority.getHostName());
        this.setPort(uRIAuthority.getPort());
        return this;
    }

    public URIBuilder setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public URIAuthority getAuthority() {
        return new URIAuthority(this.getUserInfo(), this.getHost(), this.getPort());
    }

    public Charset getCharset() {
        return this.charset;
    }

    static List<NameValuePair> parseQuery(CharSequence charSequence, Charset charset, boolean bl2) {
        if (charSequence == null) {
            return null;
        }
        Tokenizer tokenizer = Tokenizer.INSTANCE;
        ParserCursor parserCursor = new ParserCursor(0, charSequence.length());
        ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>();
        while (!parserCursor.atEnd()) {
            String string = tokenizer.parseToken(charSequence, (Tokenizer$Cursor)parserCursor, QUERY_PARAM_SEPARATORS);
            String string2 = null;
            if (!parserCursor.atEnd()) {
                char c2 = charSequence.charAt(parserCursor.getPos());
                ParserCursor parserCursor2 = parserCursor;
                parserCursor2.updatePos(parserCursor2.getPos() + 1);
                if (c2 == '=') {
                    string2 = tokenizer.parseToken(charSequence, (Tokenizer$Cursor)parserCursor, QUERY_VALUE_SEPARATORS);
                    if (!parserCursor.atEnd()) {
                        ParserCursor parserCursor3 = parserCursor;
                        parserCursor3.updatePos(parserCursor3.getPos() + 1);
                    }
                }
            }
            if (string.isEmpty()) continue;
            arrayList.add(new BasicNameValuePair(PercentCodec.decode(string, charset, bl2), PercentCodec.decode(string2, charset, bl2)));
        }
        return arrayList;
    }

    static List<String> splitPath(CharSequence charSequence) {
        if (charSequence == null) {
            return Collections.emptyList();
        }
        ParserCursor parserCursor = new ParserCursor(0, charSequence.length());
        if (parserCursor.atEnd()) {
            return new ArrayList<String>(0);
        }
        if (charSequence.charAt(parserCursor.getPos()) == '/') {
            ParserCursor parserCursor2 = parserCursor;
            parserCursor2.updatePos(parserCursor2.getPos() + 1);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            if (parserCursor.atEnd()) break;
            char c2 = charSequence.charAt(parserCursor.getPos());
            if (c2 == '/') {
                arrayList.add(stringBuilder.toString());
                stringBuilder.setLength(0);
            } else {
                stringBuilder.append(c2);
            }
            ParserCursor parserCursor3 = parserCursor;
            parserCursor3.updatePos(parserCursor3.getPos() + 1);
        }
        arrayList.add(stringBuilder.toString());
        return arrayList;
    }

    static List<String> parsePath(CharSequence iterator, Charset charset) {
        if (iterator == null) {
            return Collections.emptyList();
        }
        iterator = URIBuilder.splitPath((CharSequence)((Object)iterator));
        ArrayList<String> arrayList = new ArrayList<String>(iterator.size());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            arrayList.add(PercentCodec.decode(string, charset));
        }
        return arrayList;
    }

    static void formatPath(StringBuilder stringBuilder, Iterable<String> object, boolean bl2, Charset charset) {
        int n2 = 0;
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            if (n2 > 0 || !bl2) {
                stringBuilder.append('/');
            }
            PercentCodec.encode(stringBuilder, string, charset);
            ++n2;
        }
    }

    static void formatQuery(StringBuilder stringBuilder, Iterable<? extends NameValuePair> object, Charset charset, boolean bl2) {
        int n2 = 0;
        object = object.iterator();
        while (object.hasNext()) {
            NameValuePair nameValuePair = (NameValuePair)object.next();
            if (n2 > 0) {
                stringBuilder.append('&');
            }
            PercentCodec.encode(stringBuilder, nameValuePair.getName(), charset, bl2);
            if (nameValuePair.getValue() != null) {
                stringBuilder.append('=');
                PercentCodec.encode(stringBuilder, nameValuePair.getValue(), charset, bl2);
            }
            ++n2;
        }
    }

    public URI build() throws URISyntaxException {
        if ((URIScheme.HTTPS.same(this.scheme) || URIScheme.HTTP.same(this.scheme)) && TextUtils.isBlank(this.host)) {
            throw new URISyntaxException(this.scheme, "http/https URI cannot have an empty host identifier");
        }
        return new URI(this.buildString());
    }

    private String buildString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.scheme != null) {
            stringBuilder.append(this.scheme).append(':');
        }
        if (this.encodedSchemeSpecificPart != null) {
            stringBuilder.append(this.encodedSchemeSpecificPart);
        } else {
            int n2;
            if (this.encodedAuthority != null) {
                stringBuilder.append("//").append(this.encodedAuthority);
                n2 = 1;
            } else if (this.host != null) {
                stringBuilder.append("//");
                if (this.encodedUserInfo != null) {
                    stringBuilder.append(this.encodedUserInfo).append("@");
                } else if (this.userInfo != null) {
                    n2 = this.userInfo.indexOf(58);
                    if (n2 != -1) {
                        PercentCodec.encode(stringBuilder, this.userInfo.substring(0, n2), this.charset);
                        stringBuilder.append(':');
                        PercentCodec.encode(stringBuilder, this.userInfo.substring(n2 + 1), this.charset);
                    } else {
                        PercentCodec.encode(stringBuilder, this.userInfo, this.charset);
                    }
                    stringBuilder.append("@");
                }
                if (InetAddressUtils.isIPv6(this.host)) {
                    stringBuilder.append("[").append(this.host).append("]");
                } else {
                    PercentCodec.encode(stringBuilder, this.host, this.charset);
                }
                if (this.port >= 0) {
                    stringBuilder.append(":").append(this.port);
                }
                n2 = 1;
            } else {
                n2 = 0;
            }
            if (this.encodedPath != null) {
                if (n2 != 0 && !TextUtils.isEmpty(this.encodedPath) && !this.encodedPath.startsWith("/")) {
                    stringBuilder.append('/');
                }
                stringBuilder.append(this.encodedPath);
            } else if (this.pathSegments != null) {
                URIBuilder.formatPath(stringBuilder, this.pathSegments, n2 == 0 && this.pathRootless, this.charset);
            }
            if (this.encodedQuery != null) {
                stringBuilder.append("?").append(this.encodedQuery);
            } else if (this.queryParams != null && !this.queryParams.isEmpty()) {
                stringBuilder.append("?");
                URIBuilder.formatQuery(stringBuilder, this.queryParams, this.charset, false);
            } else if (this.query != null) {
                stringBuilder.append("?");
                PercentCodec.encode(stringBuilder, this.query, this.charset, PercentCodec.URIC, false);
            }
        }
        if (this.encodedFragment != null) {
            stringBuilder.append("#").append(this.encodedFragment);
        } else if (this.fragment != null) {
            stringBuilder.append("#");
            PercentCodec.encode(stringBuilder, this.fragment, this.charset, PercentCodec.URIC, false);
        }
        return stringBuilder.toString();
    }

    private void digestURI(URI uRI, Charset charset) {
        this.scheme = uRI.getScheme();
        this.encodedSchemeSpecificPart = uRI.getRawSchemeSpecificPart();
        this.encodedAuthority = uRI.getRawAuthority();
        Object object = uRI.getHost();
        this.host = object != null && InetAddressUtils.isIPv6URLBracketed((CharSequence)object) ? ((String)object).substring(1, ((String)object).length() - 1) : object;
        this.port = uRI.getPort();
        this.encodedUserInfo = uRI.getRawUserInfo();
        this.userInfo = uRI.getUserInfo();
        if (this.encodedAuthority != null && this.host == null) {
            try {
                object = URIAuthority.parse(this.encodedAuthority);
                this.encodedUserInfo = ((URIAuthority)object).getUserInfo();
                this.userInfo = PercentCodec.decode(((URIAuthority)object).getUserInfo(), charset);
                this.host = PercentCodec.decode(((URIAuthority)object).getHostName(), charset);
                this.port = ((URIAuthority)object).getPort();
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        this.encodedPath = uRI.getRawPath();
        this.pathSegments = URIBuilder.parsePath(uRI.getRawPath(), charset);
        this.pathRootless = uRI.getRawPath() == null || !uRI.getRawPath().startsWith("/");
        this.encodedQuery = uRI.getRawQuery();
        this.queryParams = URIBuilder.parseQuery(uRI.getRawQuery(), charset, false);
        this.encodedFragment = uRI.getRawFragment();
        this.fragment = uRI.getFragment();
        this.charset = charset;
    }

    public URIBuilder setScheme(String string) {
        this.scheme = !TextUtils.isBlank(string) ? string : null;
        return this;
    }

    public URIBuilder setSchemeSpecificPart(String string) {
        this.encodedSchemeSpecificPart = string;
        return this;
    }

    public URIBuilder setSchemeSpecificPart(String string, NameValuePair ... nameValuePairArray) {
        return this.setSchemeSpecificPart(string, nameValuePairArray != null ? Arrays.asList(nameValuePairArray) : null);
    }

    public URIBuilder setSchemeSpecificPart(String charSequence, List<NameValuePair> list) {
        this.encodedSchemeSpecificPart = null;
        if (!TextUtils.isBlank(charSequence)) {
            charSequence = new StringBuilder((String)charSequence);
            if (list != null && !list.isEmpty()) {
                ((StringBuilder)charSequence).append("?");
                URIBuilder.formatQuery((StringBuilder)charSequence, list, this.charset, false);
            }
            this.encodedSchemeSpecificPart = ((StringBuilder)charSequence).toString();
        }
        return this;
    }

    public URIBuilder setUserInfo(String string) {
        this.userInfo = !TextUtils.isBlank(string) ? string : null;
        this.encodedSchemeSpecificPart = null;
        this.encodedAuthority = null;
        this.encodedUserInfo = null;
        return this;
    }

    @Deprecated
    public URIBuilder setUserInfo(String string, String string2) {
        return this.setUserInfo(string + ':' + string2);
    }

    public URIBuilder setHost(InetAddress inetAddress) {
        this.host = inetAddress != null ? inetAddress.getHostAddress() : null;
        this.encodedSchemeSpecificPart = null;
        this.encodedAuthority = null;
        return this;
    }

    public URIBuilder setHost(String string) {
        this.host = string;
        this.encodedSchemeSpecificPart = null;
        this.encodedAuthority = null;
        return this;
    }

    public URIBuilder setHttpHost(HttpHost httpHost) {
        this.setScheme(httpHost.getSchemeName());
        this.setHost(httpHost.getHostName());
        this.setPort(httpHost.getPort());
        return this;
    }

    public URIBuilder setPort(int n2) {
        this.port = n2 < 0 ? -1 : n2;
        this.encodedSchemeSpecificPart = null;
        this.encodedAuthority = null;
        return this;
    }

    public URIBuilder setPath(String string) {
        this.setPathSegments(string != null ? URIBuilder.splitPath(string) : null);
        this.pathRootless = string != null && !string.startsWith("/");
        return this;
    }

    public URIBuilder appendPath(String string) {
        if (string != null) {
            this.appendPathSegments(URIBuilder.splitPath(string));
        }
        return this;
    }

    public URIBuilder setPathSegments(String ... stringArray) {
        return this.setPathSegments(Arrays.asList(stringArray));
    }

    public URIBuilder appendPathSegments(String ... stringArray) {
        return this.appendPathSegments(Arrays.asList(stringArray));
    }

    public URIBuilder setPathSegmentsRootless(String ... stringArray) {
        return this.setPathSegmentsRootless(Arrays.asList(stringArray));
    }

    public URIBuilder setPathSegments(List<String> list) {
        this.pathSegments = list != null && !list.isEmpty() ? new ArrayList<String>(list) : null;
        this.encodedSchemeSpecificPart = null;
        this.encodedPath = null;
        this.pathRootless = false;
        return this;
    }

    public URIBuilder appendPathSegments(List<String> list) {
        if (list != null && !list.isEmpty()) {
            if (this.pathSegments == null) {
                this.pathSegments = new ArrayList<String>();
            }
            this.pathSegments.addAll(list);
            this.encodedSchemeSpecificPart = null;
            this.encodedPath = null;
        }
        return this;
    }

    public URIBuilder setPathSegmentsRootless(List<String> list) {
        this.pathSegments = list != null && !list.isEmpty() ? new ArrayList<String>(list) : null;
        this.encodedSchemeSpecificPart = null;
        this.encodedPath = null;
        this.pathRootless = true;
        return this;
    }

    public URIBuilder removeQuery() {
        this.queryParams = null;
        this.query = null;
        this.encodedQuery = null;
        this.encodedSchemeSpecificPart = null;
        return this;
    }

    public URIBuilder setParameters(List<NameValuePair> list) {
        if (this.queryParams == null) {
            this.queryParams = new ArrayList<NameValuePair>();
        } else {
            this.queryParams.clear();
        }
        if (list != null) {
            this.queryParams.addAll(list);
        }
        this.encodedQuery = null;
        this.encodedSchemeSpecificPart = null;
        this.query = null;
        return this;
    }

    public URIBuilder addParameters(List<NameValuePair> list) {
        if (this.queryParams == null) {
            this.queryParams = new ArrayList<NameValuePair>();
        }
        if (list != null) {
            this.queryParams.addAll(list);
        }
        this.encodedQuery = null;
        this.encodedSchemeSpecificPart = null;
        this.query = null;
        return this;
    }

    public URIBuilder setParameters(NameValuePair ... nameValuePairArray) {
        if (this.queryParams == null) {
            this.queryParams = new ArrayList<NameValuePair>();
        } else {
            this.queryParams.clear();
        }
        if (nameValuePairArray != null) {
            Collections.addAll(this.queryParams, nameValuePairArray);
        }
        this.encodedQuery = null;
        this.encodedSchemeSpecificPart = null;
        this.query = null;
        return this;
    }

    public URIBuilder addParameter(String string, String string2) {
        return this.addParameter(new BasicNameValuePair(string, string2));
    }

    public URIBuilder addParameter(NameValuePair nameValuePair) {
        if (this.queryParams == null) {
            this.queryParams = new ArrayList<NameValuePair>();
        }
        if (nameValuePair != null) {
            this.queryParams.add(nameValuePair);
        }
        this.encodedQuery = null;
        this.encodedSchemeSpecificPart = null;
        this.query = null;
        return this;
    }

    public URIBuilder removeParameter(String string) {
        Args.notNull(string, "param");
        if (this.queryParams != null && !this.queryParams.isEmpty()) {
            this.queryParams.removeIf(nameValuePair -> nameValuePair.getName().equals(string));
        }
        this.encodedQuery = null;
        this.encodedSchemeSpecificPart = null;
        this.query = null;
        return this;
    }

    public URIBuilder setParameter(String string, String string2) {
        if (this.queryParams == null) {
            this.queryParams = new ArrayList<NameValuePair>();
        }
        if (!this.queryParams.isEmpty()) {
            this.queryParams.removeIf(nameValuePair -> nameValuePair.getName().equals(string));
        }
        this.queryParams.add(new BasicNameValuePair(string, string2));
        this.encodedQuery = null;
        this.encodedSchemeSpecificPart = null;
        this.query = null;
        return this;
    }

    public URIBuilder clearParameters() {
        this.queryParams = null;
        this.encodedQuery = null;
        this.encodedSchemeSpecificPart = null;
        return this;
    }

    public URIBuilder setCustomQuery(String string) {
        this.query = !TextUtils.isBlank(string) ? string : null;
        this.encodedQuery = null;
        this.encodedSchemeSpecificPart = null;
        this.queryParams = null;
        return this;
    }

    public URIBuilder setFragment(String string) {
        this.fragment = !TextUtils.isBlank(string) ? string : null;
        this.encodedFragment = null;
        return this;
    }

    public boolean isAbsolute() {
        return this.scheme != null;
    }

    public boolean isOpaque() {
        return this.pathSegments == null && this.encodedPath == null;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getSchemeSpecificPart() {
        return this.encodedSchemeSpecificPart;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isPathEmpty() {
        return !(this.pathSegments != null && !this.pathSegments.isEmpty() || this.encodedPath != null && !this.encodedPath.isEmpty());
    }

    public List<String> getPathSegments() {
        if (this.pathSegments != null) {
            return new ArrayList<String>(this.pathSegments);
        }
        return new ArrayList<String>();
    }

    public String getPath() {
        if (this.pathSegments == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.pathSegments) {
            stringBuilder.append('/').append(string);
        }
        return stringBuilder.toString();
    }

    public boolean isQueryEmpty() {
        return (this.queryParams == null || this.queryParams.isEmpty()) && this.encodedQuery == null;
    }

    public List<NameValuePair> getQueryParams() {
        if (this.queryParams != null) {
            return new ArrayList<NameValuePair>(this.queryParams);
        }
        return new ArrayList<NameValuePair>();
    }

    public NameValuePair getFirstQueryParam(String string) {
        if (this.queryParams == null) {
            return null;
        }
        return this.queryParams.stream().filter(nameValuePair -> string.equals(nameValuePair.getName())).findFirst().orElse(null);
    }

    public String getFragment() {
        return this.fragment;
    }

    @Deprecated
    public URIBuilder normalizeSyntax() {
        return this.optimize();
    }

    public URIBuilder optimize() {
        List<String> list = this.scheme;
        if (list != null) {
            this.scheme = TextUtils.toLowerCase((String)((Object)list));
        }
        if (this.pathRootless) {
            return this;
        }
        this.encodedSchemeSpecificPart = null;
        this.encodedAuthority = null;
        this.encodedUserInfo = null;
        this.encodedPath = null;
        this.encodedQuery = null;
        this.encodedFragment = null;
        list = this.host;
        if (list != null) {
            this.host = TextUtils.toLowerCase((String)((Object)list));
        }
        if (this.pathSegments != null) {
            list = this.pathSegments;
            if (!list.isEmpty()) {
                LinkedList<String> linkedList = new LinkedList<String>();
                for (String string : list) {
                    if (string.isEmpty() || ".".equals(string)) continue;
                    if ("..".equals(string)) {
                        if (linkedList.isEmpty()) continue;
                        linkedList.removeLast();
                        continue;
                    }
                    linkedList.addLast(string);
                }
                if (!list.isEmpty()) {
                    List<String> list2 = list;
                    String string = (String)list2.get(list2.size() - 1);
                    if (string.isEmpty()) {
                        linkedList.addLast("");
                    }
                }
                this.pathSegments = linkedList;
            } else {
                this.pathSegments = Collections.singletonList("");
            }
        }
        return this;
    }

    public String toString() {
        return this.buildString();
    }
}

