/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.net;

import java.net.URISyntaxException;
import java.util.BitSet;
import org.apache.hc.core5.util.Tokenizer;
import org.apache.hc.core5.util.Tokenizer$Cursor;
import org.apache.hc.core5.util.Tokenizer$Delimiter;

final class URISupport {
    private static final BitSet HOST_SEPARATORS = new BitSet(256);
    private static final BitSet PORT_SEPARATORS = new BitSet(256);
    private static final BitSet TERMINATORS = new BitSet(256);
    static final Tokenizer$Delimiter DELIMITERS;
    static final Tokenizer$Delimiter HOST_DELIMITERS;
    static final Tokenizer$Delimiter IPV6_HOST_DELIMITERS;
    static final Tokenizer$Delimiter PORT_DELIMITERS;

    URISupport() {
    }

    static URISyntaxException createException(CharSequence charSequence, Tokenizer$Cursor tokenizer$Cursor, String string) {
        return new URISyntaxException(charSequence.subSequence(tokenizer$Cursor.getLowerBound(), tokenizer$Cursor.getUpperBound()).toString(), string, tokenizer$Cursor.getPos());
    }

    static {
        TERMINATORS.set(47);
        TERMINATORS.set(35);
        TERMINATORS.set(63);
        HOST_SEPARATORS.or(TERMINATORS);
        HOST_SEPARATORS.set(64);
        PORT_SEPARATORS.or(TERMINATORS);
        PORT_SEPARATORS.set(58);
        DELIMITERS = Tokenizer.delimiters(TERMINATORS);
        HOST_DELIMITERS = Tokenizer.delimiters(HOST_SEPARATORS);
        IPV6_HOST_DELIMITERS = Tokenizer.delimiters(']');
        PORT_DELIMITERS = Tokenizer.delimiters(PORT_SEPARATORS);
    }
}

