/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.pool;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.concurrent.BasicFuture;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.ModalCloseable;
import org.apache.hc.core5.pool.ConnPoolListener;
import org.apache.hc.core5.pool.DisposalCallback;
import org.apache.hc.core5.pool.ManagedConnPool;
import org.apache.hc.core5.pool.PoolEntry;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.pool.PoolStats;
import org.apache.hc.core5.pool.StrictConnPool$1;
import org.apache.hc.core5.pool.StrictConnPool$LeaseRequest;
import org.apache.hc.core5.pool.StrictConnPool$PerRoutePool;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Asserts;
import org.apache.hc.core5.util.Deadline;
import org.apache.hc.core5.util.DeadlineTimeoutException;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

@Contract(threading=ThreadingBehavior.SAFE)
public class StrictConnPool<T, C extends ModalCloseable>
implements ManagedConnPool<T, C> {
    private final TimeValue timeToLive;
    private final PoolReusePolicy policy;
    private final DisposalCallback<C> disposalCallback;
    private final ConnPoolListener<T> connPoolListener;
    private final Map<T, StrictConnPool$PerRoutePool<T, C>> routeToPool;
    private final LinkedList<StrictConnPool$LeaseRequest<T, C>> pendingRequests;
    private final Set<PoolEntry<T, C>> leased;
    private final LinkedList<PoolEntry<T, C>> available;
    private final ConcurrentLinkedQueue<StrictConnPool$LeaseRequest<T, C>> completedRequests;
    private final Map<T, Integer> maxPerRoute;
    private final ReentrantLock lock;
    private final AtomicBoolean isShutDown;
    private volatile int defaultMaxPerRoute;
    private volatile int maxTotal;

    public StrictConnPool(int n2, int n3, TimeValue timeValue, PoolReusePolicy poolReusePolicy, DisposalCallback<C> disposalCallback, ConnPoolListener<T> connPoolListener) {
        Args.positive(n2, "Max per route value");
        Args.positive(n3, "Max total value");
        this.timeToLive = TimeValue.defaultsToNegativeOneMillisecond(timeValue);
        this.policy = poolReusePolicy != null ? poolReusePolicy : PoolReusePolicy.LIFO;
        this.disposalCallback = disposalCallback;
        this.connPoolListener = connPoolListener;
        this.routeToPool = new HashMap<T, StrictConnPool$PerRoutePool<T, C>>();
        this.pendingRequests = new LinkedList();
        this.leased = new HashSet<PoolEntry<T, C>>();
        this.available = new LinkedList();
        this.completedRequests = new ConcurrentLinkedQueue();
        this.maxPerRoute = new HashMap<T, Integer>();
        this.lock = new ReentrantLock();
        this.isShutDown = new AtomicBoolean();
        this.defaultMaxPerRoute = n2;
        this.maxTotal = n3;
    }

    public StrictConnPool(int n2, int n3, TimeValue timeValue, PoolReusePolicy poolReusePolicy, ConnPoolListener<T> connPoolListener) {
        this(n2, n3, timeValue, poolReusePolicy, null, connPoolListener);
    }

    public StrictConnPool(int n2, int n3) {
        this(n2, n3, TimeValue.NEG_ONE_MILLISECOND, PoolReusePolicy.LIFO, null);
    }

    public boolean isShutdown() {
        return this.isShutDown.get();
    }

    @Override
    public void close(CloseMode closeMode) {
        if (this.isShutDown.compareAndSet(false, true)) {
            this.fireCallbacks();
            this.lock.lock();
            try {
                for (StrictConnPool$PerRoutePool<T, C> strictConnPool$PerRoutePool : this.routeToPool.values()) {
                    strictConnPool$PerRoutePool.shutdown(closeMode);
                }
                this.routeToPool.clear();
                this.leased.clear();
                this.available.clear();
                this.pendingRequests.clear();
                return;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public void close() {
        this.close(CloseMode.GRACEFUL);
    }

    private StrictConnPool$PerRoutePool<T, C> getPool(T t2) {
        StrictConnPool$PerRoutePool<T, C> strictConnPool$PerRoutePool = this.routeToPool.get(t2);
        if (strictConnPool$PerRoutePool == null) {
            strictConnPool$PerRoutePool = new StrictConnPool$PerRoutePool<T, C>(t2, this.disposalCallback);
            this.routeToPool.put(t2, strictConnPool$PerRoutePool);
        }
        return strictConnPool$PerRoutePool;
    }

    @Override
    public Future<PoolEntry<T, C>> lease(T object, Object object2, Timeout timeout, FutureCallback<PoolEntry<T, C>> object3) {
        boolean bl2;
        Args.notNull(object, "Route");
        Args.notNull(timeout, "Request timeout");
        Asserts.check(!this.isShutDown.get(), "Connection pool shut down");
        Deadline deadline = Deadline.calculate(timeout);
        object3 = new StrictConnPool$1(this, (FutureCallback)object3);
        try {
            if (TimeValue.isPositive(timeout)) {
                bl2 = this.lock.tryLock(timeout.getDuration(), timeout.getTimeUnit());
            } else {
                this.lock.lockInterruptibly();
                bl2 = true;
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            ((BasicFuture)object3).cancel();
            return object3;
        }
        if (bl2) {
            try {
                object = new StrictConnPool$LeaseRequest(object, object2, timeout, object3);
                boolean bl3 = this.processPendingRequest((StrictConnPool$LeaseRequest<T, C>)object);
                if (!((StrictConnPool$LeaseRequest)object).isDone() && !bl3) {
                    this.pendingRequests.add((StrictConnPool$LeaseRequest<T, C>)object);
                }
                if (((StrictConnPool$LeaseRequest)object).isDone()) {
                    this.completedRequests.add((StrictConnPool$LeaseRequest<T, C>)object);
                }
            }
            finally {
                this.lock.unlock();
            }
            this.fireCallbacks();
        } else {
            ((BasicFuture)object3).failed(DeadlineTimeoutException.from(deadline));
        }
        return object3;
    }

    public Future<PoolEntry<T, C>> lease(T t2, Object object) {
        return this.lease(t2, object, Timeout.DISABLED, null);
    }

    @Override
    public void release(PoolEntry<T, C> poolEntry, boolean bl2) {
        block11: {
            if (poolEntry == null) {
                return;
            }
            if (this.isShutDown.get()) {
                return;
            }
            if (!bl2) {
                poolEntry.discardConnection(CloseMode.GRACEFUL);
            }
            this.lock.lock();
            try {
                block12: {
                    block14: {
                        block13: {
                            if (!this.leased.remove(poolEntry)) break block12;
                            if (this.connPoolListener != null) {
                                this.connPoolListener.onRelease(poolEntry.getRoute(), this);
                            }
                            StrictConnPool$PerRoutePool<T, C> strictConnPool$PerRoutePool = this.getPool(poolEntry.getRoute());
                            bl2 = poolEntry.hasConnection() && bl2;
                            strictConnPool$PerRoutePool.free(poolEntry, bl2);
                            if (!bl2) break block13;
                            switch (this.policy) {
                                case LIFO: {
                                    this.available.addFirst(poolEntry);
                                    break block14;
                                }
                                case FIFO: {
                                    this.available.addLast(poolEntry);
                                    break block14;
                                }
                                default: {
                                    throw new IllegalStateException("Unexpected ConnPoolPolicy value: " + (Object)((Object)this.policy));
                                }
                            }
                        }
                        poolEntry.discardConnection(CloseMode.GRACEFUL);
                    }
                    this.processNextPendingRequest();
                    break block11;
                }
                throw new IllegalStateException("Pool entry is not present in the set of leased entries");
            }
            finally {
                this.lock.unlock();
            }
        }
        this.fireCallbacks();
    }

    private void processPendingRequests() {
        ListIterator listIterator = this.pendingRequests.listIterator();
        while (listIterator.hasNext()) {
            StrictConnPool$LeaseRequest strictConnPool$LeaseRequest = (StrictConnPool$LeaseRequest)listIterator.next();
            BasicFuture basicFuture = strictConnPool$LeaseRequest.getFuture();
            if (basicFuture.isCancelled()) {
                listIterator.remove();
                continue;
            }
            boolean bl2 = this.processPendingRequest(strictConnPool$LeaseRequest);
            if (strictConnPool$LeaseRequest.isDone() || bl2) {
                listIterator.remove();
            }
            if (!strictConnPool$LeaseRequest.isDone()) continue;
            this.completedRequests.add(strictConnPool$LeaseRequest);
        }
    }

    private void processNextPendingRequest() {
        ListIterator listIterator = this.pendingRequests.listIterator();
        while (listIterator.hasNext()) {
            StrictConnPool$LeaseRequest strictConnPool$LeaseRequest = (StrictConnPool$LeaseRequest)listIterator.next();
            BasicFuture basicFuture = strictConnPool$LeaseRequest.getFuture();
            if (basicFuture.isCancelled()) {
                listIterator.remove();
                continue;
            }
            boolean bl2 = this.processPendingRequest(strictConnPool$LeaseRequest);
            if (strictConnPool$LeaseRequest.isDone() || bl2) {
                listIterator.remove();
            }
            if (strictConnPool$LeaseRequest.isDone()) {
                this.completedRequests.add(strictConnPool$LeaseRequest);
            }
            if (!bl2) continue;
            return;
        }
    }

    private boolean processPendingRequest(StrictConnPool$LeaseRequest<T, C> strictConnPool$LeaseRequest) {
        PoolEntry poolEntry;
        T t2 = strictConnPool$LeaseRequest.getRoute();
        Object object = strictConnPool$LeaseRequest.getState();
        Object object2 = strictConnPool$LeaseRequest.getDeadline();
        if (((Deadline)object2).isExpired()) {
            strictConnPool$LeaseRequest.failed(DeadlineTimeoutException.from((Deadline)object2));
            return false;
        }
        object2 = this.getPool(t2);
        while ((poolEntry = ((StrictConnPool$PerRoutePool)object2).getFree(object)) != null && poolEntry.getExpiryDeadline().isExpired()) {
            poolEntry.discardConnection(CloseMode.GRACEFUL);
            this.available.remove(poolEntry);
            ((StrictConnPool$PerRoutePool)object2).free(poolEntry, false);
        }
        if (poolEntry != null) {
            this.available.remove(poolEntry);
            this.leased.add(poolEntry);
            strictConnPool$LeaseRequest.completed(poolEntry);
            if (this.connPoolListener != null) {
                this.connPoolListener.onLease(poolEntry.getRoute(), this);
            }
            return true;
        }
        int n2 = this.getMax(t2);
        int n3 = Math.max(0, ((StrictConnPool$PerRoutePool)object2).getAllocatedCount() + 1 - n2);
        if (n3 > 0) {
            PoolEntry poolEntry2;
            for (int i2 = 0; i2 < n3 && (poolEntry2 = ((StrictConnPool$PerRoutePool)object2).getLastUsed()) != null; ++i2) {
                poolEntry2.discardConnection(CloseMode.GRACEFUL);
                this.available.remove(poolEntry2);
                ((StrictConnPool$PerRoutePool)object2).remove(poolEntry2);
            }
        }
        if (((StrictConnPool$PerRoutePool)object2).getAllocatedCount() < n2) {
            int n4 = Math.max(this.maxTotal - this.leased.size(), 0);
            if (n4 == 0) {
                return false;
            }
            int n5 = this.available.size();
            if (n5 > n4 - 1) {
                PoolEntry<T, C> poolEntry3 = this.available.removeLast();
                poolEntry3.discardConnection(CloseMode.GRACEFUL);
                StrictConnPool$PerRoutePool<T, C> strictConnPool$PerRoutePool = this.getPool(poolEntry3.getRoute());
                strictConnPool$PerRoutePool.remove(poolEntry3);
            }
            PoolEntry poolEntry4 = ((StrictConnPool$PerRoutePool)object2).createEntry(this.timeToLive);
            this.leased.add(poolEntry4);
            strictConnPool$LeaseRequest.completed(poolEntry4);
            if (this.connPoolListener != null) {
                this.connPoolListener.onLease(poolEntry4.getRoute(), this);
            }
            return true;
        }
        return false;
    }

    private void fireCallbacks() {
        Object object;
        while ((object = this.completedRequests.poll()) != null) {
            BasicFuture<PoolEntry<Object, C>> basicFuture = ((StrictConnPool$LeaseRequest)object).getFuture();
            Exception exception = ((StrictConnPool$LeaseRequest)object).getException();
            object = ((StrictConnPool$LeaseRequest)object).getResult();
            boolean bl2 = false;
            if (exception != null) {
                basicFuture.failed(exception);
            } else if (object != null) {
                if (basicFuture.completed((PoolEntry<Object, C>)object)) {
                    bl2 = true;
                }
            } else {
                basicFuture.cancel();
            }
            if (bl2) continue;
            this.release((PoolEntry<T, C>)object, true);
        }
    }

    public void validatePendingRequests() {
        this.lock.lock();
        try {
            long l2 = System.currentTimeMillis();
            ListIterator listIterator = this.pendingRequests.listIterator();
            while (listIterator.hasNext()) {
                StrictConnPool$LeaseRequest strictConnPool$LeaseRequest = (StrictConnPool$LeaseRequest)listIterator.next();
                Object object = strictConnPool$LeaseRequest.getFuture();
                if (((BasicFuture)object).isCancelled() && !strictConnPool$LeaseRequest.isDone()) {
                    listIterator.remove();
                    continue;
                }
                object = strictConnPool$LeaseRequest.getDeadline();
                if (((Deadline)object).isBefore(l2)) {
                    strictConnPool$LeaseRequest.failed(DeadlineTimeoutException.from((Deadline)object));
                }
                if (!strictConnPool$LeaseRequest.isDone()) continue;
                listIterator.remove();
                this.completedRequests.add(strictConnPool$LeaseRequest);
            }
        }
        finally {
            this.lock.unlock();
        }
        this.fireCallbacks();
    }

    private int getMax(T object) {
        if ((object = this.maxPerRoute.get(object)) != null) {
            return (Integer)object;
        }
        return this.defaultMaxPerRoute;
    }

    @Override
    public void setMaxTotal(int n2) {
        Args.positive(n2, "Max value");
        this.lock.lock();
        try {
            this.maxTotal = n2;
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int getMaxTotal() {
        this.lock.lock();
        try {
            int n2 = this.maxTotal;
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setDefaultMaxPerRoute(int n2) {
        Args.positive(n2, "Max value");
        this.lock.lock();
        try {
            this.defaultMaxPerRoute = n2;
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int getDefaultMaxPerRoute() {
        this.lock.lock();
        try {
            int n2 = this.defaultMaxPerRoute;
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setMaxPerRoute(T t2, int n2) {
        Args.notNull(t2, "Route");
        this.lock.lock();
        try {
            if (n2 >= 0) {
                this.maxPerRoute.put(t2, n2);
            } else {
                this.maxPerRoute.remove(t2);
            }
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int getMaxPerRoute(T t2) {
        Args.notNull(t2, "Route");
        this.lock.lock();
        try {
            int n2 = this.getMax(t2);
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public PoolStats getTotalStats() {
        this.lock.lock();
        try {
            int n2 = 0;
            for (StrictConnPool$LeaseRequest strictConnPool$LeaseRequest : this.pendingRequests) {
                Deadline deadline;
                if (strictConnPool$LeaseRequest.isDone() || (deadline = strictConnPool$LeaseRequest.getDeadline()).isExpired()) continue;
                ++n2;
            }
            PoolStats poolStats = new PoolStats(this.leased.size(), n2, this.available.size(), this.maxTotal);
            return poolStats;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public PoolStats getStats(T t2) {
        Args.notNull(t2, "Route");
        this.lock.lock();
        try {
            StrictConnPool$PerRoutePool<T, C> strictConnPool$PerRoutePool = this.getPool(t2);
            int n2 = 0;
            for (StrictConnPool$LeaseRequest strictConnPool$LeaseRequest : this.pendingRequests) {
                Deadline deadline;
                if (strictConnPool$LeaseRequest.isDone() || !Objects.equals(t2, strictConnPool$LeaseRequest.getRoute()) || (deadline = strictConnPool$LeaseRequest.getDeadline()).isExpired()) continue;
                ++n2;
            }
            PoolStats poolStats = new PoolStats(strictConnPool$PerRoutePool.getLeasedCount(), n2, strictConnPool$PerRoutePool.getAvailableCount(), this.getMax(t2));
            return poolStats;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Set<T> getRoutes() {
        this.lock.lock();
        try {
            HashSet<T> hashSet = new HashSet<T>(this.routeToPool.keySet());
            return hashSet;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void enumAvailable(Callback<PoolEntry<T, C>> callback) {
        this.lock.lock();
        try {
            Iterator iterator = this.available.iterator();
            while (iterator.hasNext()) {
                PoolEntry poolEntry = (PoolEntry)iterator.next();
                callback.execute(poolEntry);
                if (poolEntry.hasConnection()) continue;
                StrictConnPool$PerRoutePool strictConnPool$PerRoutePool = this.getPool(poolEntry.getRoute());
                strictConnPool$PerRoutePool.remove(poolEntry);
                iterator.remove();
            }
            this.processPendingRequests();
            this.purgePoolMap();
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void enumLeased(Callback<PoolEntry<T, C>> callback) {
        this.lock.lock();
        try {
            for (PoolEntry<T, C> poolEntry : this.leased) {
                callback.execute(poolEntry);
            }
            this.processPendingRequests();
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void purgePoolMap() {
        Iterator<Map.Entry<T, StrictConnPool$PerRoutePool<T, C>>> iterator = this.routeToPool.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (((StrictConnPool$PerRoutePool)(object = object.getValue())).getAllocatedCount() != 0) continue;
            iterator.remove();
        }
    }

    @Override
    public void closeIdle(TimeValue timeValue) {
        long l2 = System.currentTimeMillis() - (TimeValue.isPositive(timeValue) ? timeValue.toMilliseconds() : 0L);
        this.enumAvailable(poolEntry -> {
            if (poolEntry.getUpdated() <= l2) {
                poolEntry.discardConnection(CloseMode.GRACEFUL);
            }
        });
    }

    @Override
    public void closeExpired() {
        long l2 = System.currentTimeMillis();
        this.enumAvailable(poolEntry -> {
            if (poolEntry.getExpiryDeadline().isBefore(l2)) {
                poolEntry.discardConnection(CloseMode.GRACEFUL);
            }
        });
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[leased: ");
        stringBuilder.append(this.leased.size());
        stringBuilder.append("][available: ");
        stringBuilder.append(this.available.size());
        stringBuilder.append("][pending: ");
        stringBuilder.append(this.pendingRequests.size());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

