/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.concurrent.ComplexFuture;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.ModalCloseable;
import org.apache.hc.core5.reactor.AbstractIOSessionPool$1;
import org.apache.hc.core5.reactor.AbstractIOSessionPool$2;
import org.apache.hc.core5.reactor.AbstractIOSessionPool$PoolEntry;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Asserts;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

@Contract(threading=ThreadingBehavior.SAFE)
public abstract class AbstractIOSessionPool<T>
implements ModalCloseable {
    private final ConcurrentMap<T, AbstractIOSessionPool$PoolEntry> sessionPool = new ConcurrentHashMap<T, AbstractIOSessionPool$PoolEntry>();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final ReentrantLock lock = new ReentrantLock();

    protected abstract Future<IOSession> connectSession(T var1, Timeout var2, FutureCallback<IOSession> var3);

    protected abstract void validateSession(IOSession var1, Callback<Boolean> var2);

    protected abstract void closeSession(IOSession var1, CloseMode var2);

    @Override
    public final void close(CloseMode closeMode) {
        if (this.closed.compareAndSet(false, true)) {
            for (AbstractIOSessionPool$PoolEntry abstractIOSessionPool$PoolEntry : this.sessionPool.values()) {
                this.lock.lock();
                try {
                    FutureCallback<IOSession> futureCallback;
                    if (abstractIOSessionPool$PoolEntry.session != null) {
                        this.closeSession(abstractIOSessionPool$PoolEntry.session, closeMode);
                        abstractIOSessionPool$PoolEntry.session = null;
                    }
                    if (abstractIOSessionPool$PoolEntry.sessionFuture != null) {
                        abstractIOSessionPool$PoolEntry.sessionFuture.cancel(true);
                        abstractIOSessionPool$PoolEntry.sessionFuture = null;
                    }
                    while ((futureCallback = abstractIOSessionPool$PoolEntry.requestQueue.poll()) != null) {
                        futureCallback.cancelled();
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
            this.sessionPool.clear();
        }
    }

    @Override
    public final void close() {
        this.close(CloseMode.GRACEFUL);
    }

    AbstractIOSessionPool$PoolEntry getPoolEntry(T t2) {
        AbstractIOSessionPool$PoolEntry abstractIOSessionPool$PoolEntry;
        AbstractIOSessionPool$PoolEntry abstractIOSessionPool$PoolEntry2 = (AbstractIOSessionPool$PoolEntry)this.sessionPool.get(t2);
        if (abstractIOSessionPool$PoolEntry2 == null && (abstractIOSessionPool$PoolEntry2 = this.sessionPool.putIfAbsent(t2, abstractIOSessionPool$PoolEntry = new AbstractIOSessionPool$PoolEntry())) == null) {
            abstractIOSessionPool$PoolEntry2 = abstractIOSessionPool$PoolEntry;
        }
        return abstractIOSessionPool$PoolEntry2;
    }

    public final Future<IOSession> getSession(T t2, Timeout timeout, FutureCallback<IOSession> object) {
        Args.notNull(t2, "Endpoint");
        Asserts.check(!this.closed.get(), "Connection pool shut down");
        object = new ComplexFuture<IOSession>((FutureCallback<IOSession>)object);
        AbstractIOSessionPool$PoolEntry abstractIOSessionPool$PoolEntry = this.getPoolEntry(t2);
        this.getSessionInternal(abstractIOSessionPool$PoolEntry, false, t2, timeout, new AbstractIOSessionPool$1(this, (ComplexFuture)object, abstractIOSessionPool$PoolEntry, t2, timeout));
        return object;
    }

    private void getSessionInternal(AbstractIOSessionPool$PoolEntry abstractIOSessionPool$PoolEntry, boolean bl2, T t2, Timeout timeout, FutureCallback<IOSession> futureCallback) {
        abstractIOSessionPool$PoolEntry.lock.lock();
        try {
            if (abstractIOSessionPool$PoolEntry.session != null && bl2) {
                this.closeSession(abstractIOSessionPool$PoolEntry.session, CloseMode.GRACEFUL);
                abstractIOSessionPool$PoolEntry.session = null;
            }
            if (abstractIOSessionPool$PoolEntry.session != null && !abstractIOSessionPool$PoolEntry.session.isOpen()) {
                abstractIOSessionPool$PoolEntry.session = null;
            }
            if (abstractIOSessionPool$PoolEntry.session != null) {
                futureCallback.completed(abstractIOSessionPool$PoolEntry.session);
            } else {
                abstractIOSessionPool$PoolEntry.requestQueue.add(futureCallback);
                if (abstractIOSessionPool$PoolEntry.sessionFuture != null && abstractIOSessionPool$PoolEntry.completed) {
                    abstractIOSessionPool$PoolEntry.sessionFuture = null;
                }
                if (abstractIOSessionPool$PoolEntry.sessionFuture == null) {
                    abstractIOSessionPool$PoolEntry.completed = false;
                    abstractIOSessionPool$PoolEntry.sessionFuture = this.connectSession(t2, timeout, new AbstractIOSessionPool$2(this, abstractIOSessionPool$PoolEntry));
                }
            }
            return;
        }
        finally {
            abstractIOSessionPool$PoolEntry.lock.unlock();
        }
    }

    public final void enumAvailable(Callback<IOSession> callback) {
        for (AbstractIOSessionPool$PoolEntry abstractIOSessionPool$PoolEntry : this.sessionPool.values()) {
            if (abstractIOSessionPool$PoolEntry.session == null) continue;
            this.lock.lock();
            try {
                if (abstractIOSessionPool$PoolEntry.session == null) continue;
                callback.execute(abstractIOSessionPool$PoolEntry.session);
                if (abstractIOSessionPool$PoolEntry.session.isOpen()) continue;
                abstractIOSessionPool$PoolEntry.session = null;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public final void closeIdle(TimeValue object) {
        long l2 = System.currentTimeMillis() - (TimeValue.isPositive((TimeValue)object) ? ((TimeValue)object).toMilliseconds() : 0L);
        for (AbstractIOSessionPool$PoolEntry abstractIOSessionPool$PoolEntry : this.sessionPool.values()) {
            if (abstractIOSessionPool$PoolEntry.session == null) continue;
            this.lock.lock();
            try {
                if (abstractIOSessionPool$PoolEntry.session == null || abstractIOSessionPool$PoolEntry.session.getLastReadTime() > l2) continue;
                this.closeSession(abstractIOSessionPool$PoolEntry.session, CloseMode.GRACEFUL);
                abstractIOSessionPool$PoolEntry.session = null;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public final Set<T> getRoutes() {
        return new HashSet(this.sessionPool.keySet());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("I/O sessions: ");
        stringBuilder.append(this.sessionPool.size());
        return stringBuilder.toString();
    }

    static /* synthetic */ void access$000(AbstractIOSessionPool abstractIOSessionPool, AbstractIOSessionPool$PoolEntry abstractIOSessionPool$PoolEntry, boolean bl2, Object object, Timeout timeout, FutureCallback futureCallback) {
        abstractIOSessionPool.getSessionInternal(abstractIOSessionPool$PoolEntry, bl2, object, timeout, futureCallback);
    }
}

