/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor;

import java.io.IOException;
import java.util.concurrent.ThreadFactory;
import org.apache.hc.core5.concurrent.DefaultThreadFactory;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.function.Decorator;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.reactor.AbstractIOReactorBase;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOReactorStatus;
import org.apache.hc.core5.reactor.IOReactorWorker;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.IOSessionListener;
import org.apache.hc.core5.reactor.IOWorkers;
import org.apache.hc.core5.reactor.IOWorkers$Selector;
import org.apache.hc.core5.reactor.MultiCoreIOReactor;
import org.apache.hc.core5.reactor.SingleCoreIOReactor;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;

public class DefaultConnectingIOReactor
extends AbstractIOReactorBase {
    private final int workerCount;
    private final SingleCoreIOReactor[] workers;
    private final MultiCoreIOReactor ioReactor;
    private final IOWorkers$Selector workerSelector;
    private static final ThreadFactory THREAD_FACTORY = new DefaultThreadFactory("I/O client dispatch", true);

    public DefaultConnectingIOReactor(IOEventHandlerFactory iOEventHandlerFactory, IOReactorConfig iOReactorConfig, ThreadFactory threadFactory, Decorator<IOSession> decorator, Callback<Exception> callback, IOSessionListener iOSessionListener, Callback<IOSession> callback2) {
        Args.notNull(iOEventHandlerFactory, "Event handler factory");
        this.workerCount = iOReactorConfig != null ? iOReactorConfig.getIoThreadCount() : IOReactorConfig.DEFAULT.getIoThreadCount();
        this.workers = new SingleCoreIOReactor[this.workerCount];
        Thread[] threadArray = new Thread[this.workerCount];
        for (int i2 = 0; i2 < this.workers.length; ++i2) {
            SingleCoreIOReactor singleCoreIOReactor;
            this.workers[i2] = singleCoreIOReactor = new SingleCoreIOReactor(callback, iOEventHandlerFactory, iOReactorConfig != null ? iOReactorConfig : IOReactorConfig.DEFAULT, decorator, iOSessionListener, callback2);
            threadArray[i2] = (threadFactory != null ? threadFactory : THREAD_FACTORY).newThread(new IOReactorWorker(singleCoreIOReactor));
        }
        this.ioReactor = new MultiCoreIOReactor(this.workers, threadArray);
        this.workerSelector = IOWorkers.newSelector(this.workers);
    }

    public DefaultConnectingIOReactor(IOEventHandlerFactory iOEventHandlerFactory, IOReactorConfig iOReactorConfig, Callback<IOSession> callback) {
        this(iOEventHandlerFactory, iOReactorConfig, null, null, null, null, callback);
    }

    public DefaultConnectingIOReactor(IOEventHandlerFactory iOEventHandlerFactory) {
        this(iOEventHandlerFactory, null, null);
    }

    @Override
    public void start() {
        this.ioReactor.start();
    }

    @Override
    public IOReactorStatus getStatus() {
        return this.ioReactor.getStatus();
    }

    @Override
    IOWorkers$Selector getWorkerSelector() {
        return this.workerSelector;
    }

    @Override
    public void initiateShutdown() {
        this.ioReactor.initiateShutdown();
    }

    @Override
    public void awaitShutdown(TimeValue timeValue) throws InterruptedException {
        this.ioReactor.awaitShutdown(timeValue);
    }

    @Override
    public void close(CloseMode closeMode) {
        this.ioReactor.close(closeMode);
    }

    @Override
    public void close() throws IOException {
        this.ioReactor.close();
    }
}

