/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor;

import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.net.Ports;
import org.apache.hc.core5.util.Args;

@Internal
public final class EndpointParameters
implements NamedEndpoint {
    private final String scheme;
    private final String hostName;
    private final int port;
    private final Object attachment;

    public EndpointParameters(String string, String string2, int n2, Object object) {
        this.scheme = Args.notBlank(string, "Protocol scheme");
        this.hostName = Args.notBlank(string2, "Endpoint name");
        this.port = Ports.checkWithDefault(n2);
        this.attachment = object;
    }

    public EndpointParameters(HttpHost httpHost, Object object) {
        Args.notNull(httpHost, "HTTP host");
        this.scheme = httpHost.getSchemeName();
        this.hostName = httpHost.getHostName();
        this.port = httpHost.getPort();
        this.attachment = object;
    }

    public final String getScheme() {
        return this.scheme;
    }

    @Override
    public final String getHostName() {
        return this.hostName;
    }

    @Override
    public final int getPort() {
        return this.port;
    }

    public final Object getAttachment() {
        return this.attachment;
    }

    public final String toString() {
        return "EndpointParameters{scheme='" + this.scheme + '\'' + ", name='" + this.hostName + '\'' + ", port=" + this.port + ", attachment=" + this.attachment + '}';
    }
}

