/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor;

import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

public class IOReactorConfig$Builder {
    private static int defaultMaxIOThreadCount = -1;
    private TimeValue selectInterval = TimeValue.ofSeconds(1L);
    private int ioThreadCount = IOReactorConfig$Builder.getDefaultMaxIOThreadCount();
    private Timeout soTimeout = Timeout.ZERO_MILLISECONDS;
    private boolean soReuseAddress = false;
    private TimeValue soLinger = TimeValue.NEG_ONE_SECOND;
    private boolean soKeepAlive = false;
    private boolean tcpNoDelay = true;
    private int trafficClass = 0;
    private int sndBufSize = 0;
    private int rcvBufSize = 0;
    private int backlogSize = 0;
    private int tcpKeepIdle = -1;
    private int tcpKeepInterval = -1;
    private int tcpKeepCount = -1;
    private SocketAddress socksProxyAddress = null;
    private String socksProxyUsername = null;
    private String socksProxyPassword = null;

    public static int getDefaultMaxIOThreadCount() {
        if (defaultMaxIOThreadCount > 0) {
            return defaultMaxIOThreadCount;
        }
        return Runtime.getRuntime().availableProcessors();
    }

    public static void setDefaultMaxIOThreadCount(int n2) {
        defaultMaxIOThreadCount = n2;
    }

    IOReactorConfig$Builder() {
    }

    public IOReactorConfig$Builder setSelectInterval(TimeValue timeValue) {
        this.selectInterval = timeValue;
        return this;
    }

    public IOReactorConfig$Builder setIoThreadCount(int n2) {
        this.ioThreadCount = n2;
        return this;
    }

    public IOReactorConfig$Builder setSoTimeout(int n2, TimeUnit timeUnit) {
        this.soTimeout = Timeout.of(n2, timeUnit);
        return this;
    }

    public IOReactorConfig$Builder setSoTimeout(Timeout timeout) {
        this.soTimeout = timeout;
        return this;
    }

    public IOReactorConfig$Builder setSoReuseAddress(boolean bl2) {
        this.soReuseAddress = bl2;
        return this;
    }

    public IOReactorConfig$Builder setSoLinger(int n2, TimeUnit timeUnit) {
        this.soLinger = TimeValue.of(n2, timeUnit);
        return this;
    }

    public IOReactorConfig$Builder setSoLinger(TimeValue timeValue) {
        this.soLinger = timeValue;
        return this;
    }

    public IOReactorConfig$Builder setSoKeepAlive(boolean bl2) {
        this.soKeepAlive = bl2;
        return this;
    }

    public IOReactorConfig$Builder setTcpNoDelay(boolean bl2) {
        this.tcpNoDelay = bl2;
        return this;
    }

    public IOReactorConfig$Builder setTrafficClass(int n2) {
        this.trafficClass = n2;
        return this;
    }

    public IOReactorConfig$Builder setSndBufSize(int n2) {
        this.sndBufSize = n2;
        return this;
    }

    public IOReactorConfig$Builder setRcvBufSize(int n2) {
        this.rcvBufSize = n2;
        return this;
    }

    public IOReactorConfig$Builder setBacklogSize(int n2) {
        this.backlogSize = n2;
        return this;
    }

    public IOReactorConfig$Builder setTcpKeepIdle(int n2) {
        this.tcpKeepIdle = n2;
        return this;
    }

    public IOReactorConfig$Builder setTcpKeepInterval(int n2) {
        this.tcpKeepInterval = n2;
        return this;
    }

    public IOReactorConfig$Builder setTcpKeepCount(int n2) {
        this.tcpKeepCount = n2;
        return this;
    }

    public IOReactorConfig$Builder setSocksProxyAddress(SocketAddress socketAddress) {
        this.socksProxyAddress = socketAddress;
        return this;
    }

    public IOReactorConfig$Builder setSocksProxyUsername(String string) {
        this.socksProxyUsername = string;
        return this;
    }

    public IOReactorConfig$Builder setSocksProxyPassword(String string) {
        this.socksProxyPassword = string;
        return this;
    }

    public IOReactorConfig build() {
        return new IOReactorConfig(this.selectInterval != null ? this.selectInterval : TimeValue.ofSeconds(1L), this.ioThreadCount, Timeout.defaultsToInfinite(this.soTimeout), this.soReuseAddress, TimeValue.defaultsToNegativeOneMillisecond(this.soLinger), this.soKeepAlive, this.tcpNoDelay, this.trafficClass, this.sndBufSize, this.rcvBufSize, this.backlogSize, this.tcpKeepIdle, this.tcpKeepInterval, this.tcpKeepCount, this.socksProxyAddress, this.socksProxyUsername, this.socksProxyPassword);
    }
}

