/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.Closer;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.Command$Priority;
import org.apache.hc.core5.reactor.IOEventHandler;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.IOSession$Status;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Timeout;

class IOSessionImpl
implements IOSession {
    private static final AtomicLong COUNT = new AtomicLong(0L);
    private final SelectionKey key;
    private final SocketChannel channel;
    private final Deque<Command> commandQueue;
    private final Lock lock;
    private final String id;
    private final AtomicReference<IOEventHandler> handlerRef;
    private final Callback<IOSession> sessionClosedCallback;
    private final AtomicReference<IOSession$Status> status;
    private volatile Timeout socketTimeout;
    private volatile long lastReadTime;
    private volatile long lastWriteTime;
    private volatile long lastEventTime;

    public IOSessionImpl(String string, SelectionKey selectionKey, SocketChannel socketChannel, Callback<IOSession> callback) {
        long l2;
        this.key = Args.notNull(selectionKey, "Selection key");
        this.channel = Args.notNull(socketChannel, "Socket channel");
        this.sessionClosedCallback = callback;
        this.commandQueue = new ConcurrentLinkedDeque<Command>();
        this.lock = new ReentrantLock();
        this.socketTimeout = Timeout.INFINITE;
        this.id = String.format(string + "-%010d", COUNT.getAndIncrement());
        this.handlerRef = new AtomicReference();
        this.status = new AtomicReference<IOSession$Status>(IOSession$Status.ACTIVE);
        this.lastReadTime = l2 = System.currentTimeMillis();
        this.lastWriteTime = l2;
        this.lastEventTime = l2;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IOEventHandler getHandler() {
        return this.handlerRef.get();
    }

    @Override
    public void upgrade(IOEventHandler iOEventHandler) {
        this.handlerRef.set(iOEventHandler);
    }

    @Override
    public Lock getLock() {
        return this.lock;
    }

    @Override
    public void enqueue(Command command, Command$Priority command$Priority) {
        if (command$Priority == Command$Priority.IMMEDIATE) {
            this.commandQueue.addFirst(command);
        } else {
            this.commandQueue.add(command);
        }
        if (this.status.get() == IOSession$Status.ACTIVE) {
            this.setEvent(4);
            return;
        }
        command.cancel();
    }

    @Override
    public boolean hasCommands() {
        return !this.commandQueue.isEmpty();
    }

    @Override
    public Command poll() {
        return this.commandQueue.poll();
    }

    @Override
    public ByteChannel channel() {
        return this.channel;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.channel.socket().getLocalSocketAddress();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.channel.socket().getRemoteSocketAddress();
    }

    @Override
    public int getEventMask() {
        return this.key.interestOps();
    }

    @Override
    public void setEventMask(int n2) {
        this.lock.lock();
        try {
            if (this.isStatusClosed()) {
                return;
            }
            this.key.interestOps(n2);
        }
        finally {
            this.lock.unlock();
        }
        this.key.selector().wakeup();
    }

    @Override
    public void setEvent(int n2) {
        this.lock.lock();
        try {
            if (this.isStatusClosed()) {
                return;
            }
            this.key.interestOps(this.key.interestOps() | n2);
        }
        finally {
            this.lock.unlock();
        }
        this.key.selector().wakeup();
    }

    @Override
    public void clearEvent(int n2) {
        this.lock.lock();
        try {
            if (this.isStatusClosed()) {
                return;
            }
            this.key.interestOps(this.key.interestOps() & ~n2);
        }
        finally {
            this.lock.unlock();
        }
        this.key.selector().wakeup();
    }

    @Override
    public Timeout getSocketTimeout() {
        return this.socketTimeout;
    }

    @Override
    public void setSocketTimeout(Timeout timeout) {
        this.socketTimeout = Timeout.defaultsToInfinite(timeout);
        this.lastEventTime = System.currentTimeMillis();
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        return this.channel.read(byteBuffer);
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        return this.channel.write(byteBuffer);
    }

    @Override
    public void updateReadTime() {
        this.lastEventTime = this.lastReadTime = System.currentTimeMillis();
    }

    @Override
    public void updateWriteTime() {
        this.lastEventTime = this.lastWriteTime = System.currentTimeMillis();
    }

    @Override
    public long getLastReadTime() {
        return this.lastReadTime;
    }

    @Override
    public long getLastWriteTime() {
        return this.lastWriteTime;
    }

    @Override
    public long getLastEventTime() {
        return this.lastEventTime;
    }

    @Override
    public IOSession$Status getStatus() {
        return this.status.get();
    }

    private boolean isStatusClosed() {
        return this.status.get() == IOSession$Status.CLOSED;
    }

    @Override
    public boolean isOpen() {
        return this.status.get() == IOSession$Status.ACTIVE && this.channel.isOpen();
    }

    @Override
    public void close() {
        this.close(CloseMode.GRACEFUL);
    }

    @Override
    public void close(CloseMode closeMode) {
        if (this.status.compareAndSet(IOSession$Status.ACTIVE, IOSession$Status.CLOSED)) {
            try {
                if (closeMode == CloseMode.IMMEDIATE) {
                    try {
                        this.channel.socket().setSoLinger(true, 0);
                    }
                    catch (SocketException socketException) {}
                } else {
                    try {
                        this.channel.shutdownOutput();
                    }
                    catch (IOException iOException) {}
                }
                this.lock.lock();
                try {
                    this.key.cancel();
                    this.key.attach(null);
                }
                finally {
                    this.lock.unlock();
                }
                Closer.closeQuietly(this.key.channel());
                if (this.key.selector().isOpen()) {
                    this.key.selector().wakeup();
                }
                if (this.sessionClosedCallback != null) {
                    this.sessionClosedCallback.execute(this);
                    return;
                }
            }
            catch (Throwable throwable) {
                if (this.sessionClosedCallback != null) {
                    this.sessionClosedCallback.execute(this);
                }
                throw throwable;
            }
        }
    }

    private static void formatOps(StringBuilder stringBuilder, int n2) {
        if ((n2 & 1) > 0) {
            stringBuilder.append('r');
        }
        if ((n2 & 4) > 0) {
            stringBuilder.append('w');
        }
        if ((n2 & 0x10) > 0) {
            stringBuilder.append('a');
        }
        if ((n2 & 8) > 0) {
            stringBuilder.append('c');
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.id).append("[");
        stringBuilder.append(this.status);
        stringBuilder.append("][");
        if (this.key.isValid()) {
            IOSessionImpl.formatOps(stringBuilder, this.key.interestOps());
            stringBuilder.append(":");
            IOSessionImpl.formatOps(stringBuilder, this.key.readyOps());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

