/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor;

import java.net.SocketAddress;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.concurrent.BasicFuture;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.ModalCloseable;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.ProtocolIOSession;
import org.apache.hc.core5.util.Timeout;

final class IOSessionRequest
implements Future<IOSession> {
    final NamedEndpoint remoteEndpoint;
    final SocketAddress remoteAddress;
    final SocketAddress localAddress;
    final Timeout timeout;
    final Object attachment;
    final BasicFuture<IOSession> future;
    private final AtomicReference<ModalCloseable> closeableRef;

    public IOSessionRequest(NamedEndpoint namedEndpoint, SocketAddress socketAddress, SocketAddress socketAddress2, Timeout timeout, Object object, FutureCallback<IOSession> futureCallback) {
        this.remoteEndpoint = namedEndpoint;
        this.remoteAddress = socketAddress;
        this.localAddress = socketAddress2;
        this.timeout = timeout;
        this.attachment = object;
        this.future = new BasicFuture<IOSession>(futureCallback);
        this.closeableRef = new AtomicReference();
    }

    public final void completed(ProtocolIOSession protocolIOSession) {
        this.future.completed(protocolIOSession);
        this.closeableRef.set(null);
    }

    public final void failed(Exception exception) {
        this.future.failed(exception);
        this.closeableRef.set(null);
    }

    public final boolean cancel() {
        boolean bl2 = this.future.cancel();
        ModalCloseable modalCloseable = this.closeableRef.getAndSet(null);
        if (bl2 && modalCloseable != null) {
            modalCloseable.close(CloseMode.IMMEDIATE);
        }
        return bl2;
    }

    @Override
    public final boolean cancel(boolean bl2) {
        return this.cancel();
    }

    @Override
    public final boolean isCancelled() {
        return this.future.isCancelled();
    }

    public final void assign(ModalCloseable modalCloseable) {
        this.closeableRef.set(modalCloseable);
    }

    @Override
    public final boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public final IOSession get() throws InterruptedException, ExecutionException {
        return this.future.get();
    }

    @Override
    public final IOSession get(long l2, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.future.get(l2, timeUnit);
    }

    public final String toString() {
        return "[remoteEndpoint=" + this.remoteEndpoint + ", remoteAddress=" + this.remoteAddress + ", localAddress=" + this.localAddress + ", attachment=" + this.attachment + ']';
    }
}

