/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.Closer;
import org.apache.hc.core5.io.SocketTimeoutExceptionFactory;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOSessionRequest;
import org.apache.hc.core5.reactor.InternalChannel;
import org.apache.hc.core5.reactor.InternalDataChannel;
import org.apache.hc.core5.reactor.SocksProxyProtocolHandler;
import org.apache.hc.core5.util.Timeout;

final class InternalConnectChannel
extends InternalChannel {
    private final SelectionKey key;
    private final SocketChannel socketChannel;
    private final IOSessionRequest sessionRequest;
    private final InternalDataChannel dataChannel;
    private final IOEventHandlerFactory eventHandlerFactory;
    private final IOReactorConfig reactorConfig;
    private final long creationTimeMillis;

    InternalConnectChannel(SelectionKey selectionKey, SocketChannel socketChannel, IOSessionRequest iOSessionRequest, InternalDataChannel internalDataChannel, IOEventHandlerFactory iOEventHandlerFactory, IOReactorConfig iOReactorConfig) {
        this.key = selectionKey;
        this.socketChannel = socketChannel;
        this.sessionRequest = iOSessionRequest;
        this.dataChannel = internalDataChannel;
        this.eventHandlerFactory = iOEventHandlerFactory;
        this.reactorConfig = iOReactorConfig;
        this.creationTimeMillis = System.currentTimeMillis();
    }

    @Override
    final void onIOEvent(int n2) throws IOException {
        if ((n2 & 8) != 0) {
            long l2;
            if (this.socketChannel.isConnectionPending()) {
                this.socketChannel.finishConnect();
            }
            if (this.checkTimeout(l2 = System.currentTimeMillis())) {
                this.key.attach(this.dataChannel);
                if (this.reactorConfig.getSocksProxyAddress() == null) {
                    this.dataChannel.upgrade(this.eventHandlerFactory.createHandler(this.dataChannel, this.sessionRequest.attachment));
                    this.sessionRequest.completed(this.dataChannel);
                    this.dataChannel.handleIOEvent(8);
                    return;
                }
                SocksProxyProtocolHandler socksProxyProtocolHandler = new SocksProxyProtocolHandler(this.dataChannel, this.sessionRequest, this.eventHandlerFactory, this.reactorConfig);
                this.dataChannel.upgrade(socksProxyProtocolHandler);
                socksProxyProtocolHandler.connected(this.dataChannel);
            }
        }
    }

    @Override
    final Timeout getTimeout() {
        return this.sessionRequest.timeout;
    }

    @Override
    final long getLastEventTime() {
        return this.creationTimeMillis;
    }

    @Override
    final void onTimeout(Timeout timeout) throws IOException {
        this.sessionRequest.failed(SocketTimeoutExceptionFactory.create(timeout));
        this.close();
    }

    @Override
    final void onException(Exception exception) {
        this.sessionRequest.failed(exception);
    }

    @Override
    public final void close() throws IOException {
        try {
            if (!this.sessionRequest.isDone()) {
                this.sessionRequest.cancel();
            }
            return;
        }
        finally {
            this.key.cancel();
            this.socketChannel.close();
        }
    }

    @Override
    public final void close(CloseMode closeMode) {
        this.key.cancel();
        Closer.closeQuietly(this.socketChannel);
    }

    public final String toString() {
        return this.sessionRequest.toString();
    }
}

