/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import javax.net.ssl.SSLContext;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Decorator;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.Command$Priority;
import org.apache.hc.core5.reactor.IOEventHandler;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.IOSession$Status;
import org.apache.hc.core5.reactor.IOSessionListener;
import org.apache.hc.core5.reactor.InternalChannel;
import org.apache.hc.core5.reactor.InternalDataChannel$1;
import org.apache.hc.core5.reactor.ProtocolIOSession;
import org.apache.hc.core5.reactor.ProtocolUpgradeHandler;
import org.apache.hc.core5.reactor.ssl.SSLBufferMode;
import org.apache.hc.core5.reactor.ssl.SSLIOSession;
import org.apache.hc.core5.reactor.ssl.SSLMode;
import org.apache.hc.core5.reactor.ssl.SSLSessionInitializer;
import org.apache.hc.core5.reactor.ssl.SSLSessionVerifier;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.reactor.ssl.TransportSecurityLayer;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Asserts;
import org.apache.hc.core5.util.TextUtils;
import org.apache.hc.core5.util.Timeout;

final class InternalDataChannel
extends InternalChannel
implements ProtocolIOSession {
    private final IOSession ioSession;
    private final NamedEndpoint initialEndpoint;
    private final Decorator<IOSession> ioSessionDecorator;
    private final IOSessionListener sessionListener;
    private final AtomicReference<SSLIOSession> tlsSessionRef;
    private final AtomicReference<IOSession> currentSessionRef;
    private final AtomicReference<IOEventHandler> eventHandlerRef;
    private final ConcurrentMap<String, ProtocolUpgradeHandler> protocolUpgradeHandlerMap;
    private final AtomicBoolean closed;

    InternalDataChannel(IOSession iOSession, NamedEndpoint namedEndpoint, Decorator<IOSession> decorator, IOSessionListener iOSessionListener) {
        this.ioSession = iOSession;
        this.initialEndpoint = namedEndpoint;
        this.ioSessionDecorator = decorator;
        this.sessionListener = iOSessionListener;
        this.tlsSessionRef = new AtomicReference();
        this.currentSessionRef = new AtomicReference<IOSession>(decorator != null ? decorator.decorate(iOSession) : iOSession);
        this.eventHandlerRef = new AtomicReference();
        this.protocolUpgradeHandlerMap = new ConcurrentHashMap<String, ProtocolUpgradeHandler>();
        this.closed = new AtomicBoolean();
    }

    @Override
    public final String getId() {
        return this.ioSession.getId();
    }

    @Override
    public final NamedEndpoint getInitialEndpoint() {
        return this.initialEndpoint;
    }

    @Override
    public final IOEventHandler getHandler() {
        return this.eventHandlerRef.get();
    }

    @Override
    public final void upgrade(IOEventHandler iOEventHandler) {
        IOSession iOSession = this.currentSessionRef.get();
        iOSession.upgrade(iOEventHandler);
        this.eventHandlerRef.set(iOEventHandler);
    }

    private IOEventHandler ensureHandler(IOSession object) {
        object = object.getHandler();
        Asserts.notNull(object, "IO event handler");
        return object;
    }

    @Override
    final void onIOEvent(int n2) throws IOException {
        IOEventHandler iOEventHandler;
        IOSession iOSession;
        if ((n2 & 8) != 0) {
            iOSession = this.currentSessionRef.get();
            iOSession.clearEvent(8);
            if (this.tlsSessionRef.get() == null) {
                if (this.sessionListener != null) {
                    this.sessionListener.connected(iOSession);
                }
                iOEventHandler = this.ensureHandler(iOSession);
                iOEventHandler.connected(iOSession);
            }
        }
        if ((n2 & 1) != 0) {
            iOSession = this.currentSessionRef.get();
            iOSession.updateReadTime();
            if (this.sessionListener != null) {
                this.sessionListener.inputReady(iOSession);
            }
            iOEventHandler = this.ensureHandler(iOSession);
            iOEventHandler.inputReady(iOSession, null);
        }
        if ((n2 & 4) != 0 || (this.ioSession.getEventMask() & 4) != 0) {
            iOSession = this.currentSessionRef.get();
            iOSession.updateWriteTime();
            if (this.sessionListener != null) {
                this.sessionListener.outputReady(iOSession);
            }
            iOEventHandler = this.ensureHandler(iOSession);
            iOEventHandler.outputReady(iOSession);
        }
    }

    @Override
    final Timeout getTimeout() {
        IOSession iOSession = this.currentSessionRef.get();
        return iOSession.getSocketTimeout();
    }

    @Override
    final void onTimeout(Timeout timeout) throws IOException {
        IOSession iOSession = this.currentSessionRef.get();
        if (this.sessionListener != null) {
            this.sessionListener.timeout(iOSession);
        }
        IOEventHandler iOEventHandler = this.ensureHandler(iOSession);
        iOEventHandler.timeout(iOSession, timeout);
    }

    @Override
    final void onException(Exception exception) {
        IOEventHandler iOEventHandler;
        IOSession iOSession = this.currentSessionRef.get();
        if (this.sessionListener != null) {
            this.sessionListener.exception(iOSession, exception);
        }
        if ((iOEventHandler = iOSession.getHandler()) != null) {
            iOEventHandler.exception(iOSession, exception);
        }
    }

    final void onTLSSessionStart(SSLIOSession iOSession) {
        iOSession = this.currentSessionRef.get();
        if (this.sessionListener != null) {
            this.sessionListener.connected(iOSession);
        }
    }

    @Override
    public final void startTls(SSLContext sSLContext, NamedEndpoint namedEndpoint, SSLBufferMode sSLBufferMode, SSLSessionInitializer sSLSessionInitializer, SSLSessionVerifier sSLSessionVerifier, Timeout timeout) {
        this.startTls(sSLContext, namedEndpoint, sSLBufferMode, sSLSessionInitializer, sSLSessionVerifier, timeout, null);
    }

    @Override
    public final void startTls(SSLContext object, NamedEndpoint namedEndpoint, SSLBufferMode sSLBufferMode, SSLSessionInitializer sSLSessionInitializer, SSLSessionVerifier sSLSessionVerifier, Timeout timeout, FutureCallback<TransportSecurityLayer> futureCallback) {
        FutureCallback<TransportSecurityLayer> futureCallback2 = futureCallback;
        object = new SSLIOSession(namedEndpoint != null ? namedEndpoint : this.initialEndpoint, this.ioSession, this.initialEndpoint != null ? SSLMode.CLIENT : SSLMode.SERVER, (SSLContext)object, sSLBufferMode, sSLSessionInitializer, sSLSessionVerifier, timeout, this::onTLSSessionStart, null, new InternalDataChannel$1(this, futureCallback2, futureCallback2));
        if (!this.tlsSessionRef.compareAndSet(null, (SSLIOSession)object)) {
            throw new IllegalStateException("TLS already activated");
        }
        this.currentSessionRef.set((IOSession)(this.ioSessionDecorator != null ? this.ioSessionDecorator.decorate((IOSession)object) : object));
        try {
            if (this.sessionListener != null) {
                this.sessionListener.startTls((IOSession)object);
            }
            ((SSLIOSession)object).beginHandshake(this);
            return;
        }
        catch (Exception exception) {
            this.onException(exception);
            return;
        }
    }

    @Override
    public final TlsDetails getTlsDetails() {
        SSLIOSession sSLIOSession = this.tlsSessionRef.get();
        if (sSLIOSession != null) {
            return sSLIOSession.getTlsDetails();
        }
        return null;
    }

    @Override
    public final Lock getLock() {
        return this.ioSession.getLock();
    }

    @Override
    public final void close() {
        this.close(CloseMode.GRACEFUL);
    }

    @Override
    public final void close(CloseMode closeMode) {
        if (closeMode == CloseMode.IMMEDIATE) {
            this.ioSession.close(closeMode);
            return;
        }
        IOSession iOSession = this.currentSessionRef.get();
        iOSession.close(closeMode);
    }

    @Override
    public final IOSession$Status getStatus() {
        IOSession iOSession = this.currentSessionRef.get();
        return iOSession.getStatus();
    }

    @Override
    public final boolean isOpen() {
        IOSession iOSession = this.currentSessionRef.get();
        return iOSession.isOpen();
    }

    @Override
    public final void enqueue(Command command, Command$Priority command$Priority) {
        IOSession iOSession = this.currentSessionRef.get();
        iOSession.enqueue(command, command$Priority);
    }

    @Override
    public final boolean hasCommands() {
        IOSession iOSession = this.currentSessionRef.get();
        return iOSession.hasCommands();
    }

    @Override
    public final Command poll() {
        IOSession iOSession = this.currentSessionRef.get();
        return iOSession.poll();
    }

    @Override
    public final ByteChannel channel() {
        IOSession iOSession = this.currentSessionRef.get();
        return iOSession.channel();
    }

    @Override
    public final SocketAddress getRemoteAddress() {
        return this.ioSession.getRemoteAddress();
    }

    @Override
    public final SocketAddress getLocalAddress() {
        return this.ioSession.getLocalAddress();
    }

    @Override
    public final int getEventMask() {
        IOSession iOSession = this.currentSessionRef.get();
        return iOSession.getEventMask();
    }

    @Override
    public final void setEventMask(int n2) {
        IOSession iOSession = this.currentSessionRef.get();
        iOSession.setEventMask(n2);
    }

    @Override
    public final void setEvent(int n2) {
        IOSession iOSession = this.currentSessionRef.get();
        iOSession.setEvent(n2);
    }

    @Override
    public final void clearEvent(int n2) {
        IOSession iOSession = this.currentSessionRef.get();
        iOSession.clearEvent(n2);
    }

    @Override
    public final Timeout getSocketTimeout() {
        return this.ioSession.getSocketTimeout();
    }

    @Override
    public final void setSocketTimeout(Timeout timeout) {
        this.ioSession.setSocketTimeout(timeout);
    }

    @Override
    public final int read(ByteBuffer byteBuffer) throws IOException {
        IOSession iOSession = this.currentSessionRef.get();
        return iOSession.read(byteBuffer);
    }

    @Override
    public final int write(ByteBuffer byteBuffer) throws IOException {
        IOSession iOSession = this.currentSessionRef.get();
        return iOSession.write(byteBuffer);
    }

    @Override
    public final void updateReadTime() {
        this.ioSession.updateReadTime();
    }

    @Override
    public final void updateWriteTime() {
        this.ioSession.updateWriteTime();
    }

    @Override
    public final long getLastReadTime() {
        return this.ioSession.getLastReadTime();
    }

    @Override
    public final long getLastWriteTime() {
        return this.ioSession.getLastWriteTime();
    }

    @Override
    public final long getLastEventTime() {
        return this.ioSession.getLastEventTime();
    }

    @Override
    public final void switchProtocol(String string, FutureCallback<ProtocolIOSession> futureCallback) {
        Args.notEmpty(string, "Application protocol ID");
        ProtocolUpgradeHandler protocolUpgradeHandler = (ProtocolUpgradeHandler)this.protocolUpgradeHandlerMap.get(TextUtils.toLowerCase(string));
        if (protocolUpgradeHandler != null) {
            protocolUpgradeHandler.upgrade(this, futureCallback);
            return;
        }
        throw new IllegalStateException("Unsupported protocol: " + string);
    }

    @Override
    public final void registerProtocol(String string, ProtocolUpgradeHandler protocolUpgradeHandler) {
        Args.notEmpty(string, "Application protocol ID");
        Args.notNull(protocolUpgradeHandler, "Protocol upgrade handler");
        this.protocolUpgradeHandlerMap.put(TextUtils.toLowerCase(string), protocolUpgradeHandler);
    }

    public final String toString() {
        IOSession iOSession = this.currentSessionRef.get();
        return Objects.toString(iOSession != null ? iOSession : this.ioSession, null);
    }
}

