/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.UnknownHostException;
import java.nio.channels.ByteChannel;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.function.Decorator;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.Closer;
import org.apache.hc.core5.io.ModalCloseable;
import org.apache.hc.core5.io.SocketSupport;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.reactor.AbstractSingleCoreIOReactor;
import org.apache.hc.core5.reactor.ChannelEntry;
import org.apache.hc.core5.reactor.ConnectionInitiator;
import org.apache.hc.core5.reactor.IOEventHandler;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOReactorShutdownException;
import org.apache.hc.core5.reactor.IOReactorStatus;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.IOSessionImpl;
import org.apache.hc.core5.reactor.IOSessionListener;
import org.apache.hc.core5.reactor.IOSessionRequest;
import org.apache.hc.core5.reactor.InternalChannel;
import org.apache.hc.core5.reactor.InternalConnectChannel;
import org.apache.hc.core5.reactor.InternalDataChannel;
import org.apache.hc.core5.reactor.ProtocolIOSession;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Timeout;

class SingleCoreIOReactor
extends AbstractSingleCoreIOReactor
implements ConnectionInitiator {
    private static final int MAX_CHANNEL_REQUESTS = 10000;
    private final IOEventHandlerFactory eventHandlerFactory;
    private final IOReactorConfig reactorConfig;
    private final Decorator<IOSession> ioSessionDecorator;
    private final IOSessionListener sessionListener;
    private final Callback<IOSession> sessionShutdownCallback;
    private final Queue<IOSession> closedSessions;
    private final Queue<ChannelEntry> channelQueue;
    private final Queue<IOSessionRequest> requestQueue;
    private final AtomicBoolean shutdownInitiated;
    private final long selectTimeoutMillis;
    private volatile long lastTimeoutCheckMillis;

    SingleCoreIOReactor(Callback<Exception> callback, IOEventHandlerFactory iOEventHandlerFactory, IOReactorConfig iOReactorConfig, Decorator<IOSession> decorator, IOSessionListener iOSessionListener, Callback<IOSession> callback2) {
        super(callback);
        this.eventHandlerFactory = Args.notNull(iOEventHandlerFactory, "Event handler factory");
        this.reactorConfig = Args.notNull(iOReactorConfig, "I/O reactor config");
        this.ioSessionDecorator = decorator;
        this.sessionListener = iOSessionListener;
        this.sessionShutdownCallback = callback2;
        this.shutdownInitiated = new AtomicBoolean();
        this.closedSessions = new ConcurrentLinkedQueue<IOSession>();
        this.channelQueue = new ConcurrentLinkedQueue<ChannelEntry>();
        this.requestQueue = new ConcurrentLinkedQueue<IOSessionRequest>();
        this.selectTimeoutMillis = this.reactorConfig.getSelectInterval().toMilliseconds();
    }

    void enqueueChannel(ChannelEntry channelEntry) throws IOReactorShutdownException {
        if (this.getStatus().compareTo(IOReactorStatus.ACTIVE) > 0) {
            throw new IOReactorShutdownException("I/O reactor has been shut down");
        }
        this.channelQueue.add(channelEntry);
        this.selector.wakeup();
    }

    @Override
    void doTerminate() {
        this.closePendingChannels();
        this.closePendingConnectionRequests();
        this.processClosedSessions();
    }

    @Override
    void doExecute() throws IOException {
        while (!Thread.currentThread().isInterrupted()) {
            int n2 = this.selector.select(this.selectTimeoutMillis);
            if (this.getStatus().compareTo(IOReactorStatus.SHUTTING_DOWN) >= 0) {
                if (this.shutdownInitiated.compareAndSet(false, true)) {
                    this.initiateSessionShutdown();
                }
                this.closePendingChannels();
            }
            if (this.getStatus() == IOReactorStatus.SHUT_DOWN) break;
            if (n2 > 0) {
                SingleCoreIOReactor singleCoreIOReactor = this;
                singleCoreIOReactor.processEvents(singleCoreIOReactor.selector.selectedKeys());
            }
            this.validateActiveChannels();
            this.processClosedSessions();
            if (this.getStatus() == IOReactorStatus.ACTIVE) {
                this.processPendingChannels();
                this.processPendingConnectionRequests();
            }
            if ((this.getStatus() != IOReactorStatus.SHUTTING_DOWN || !this.selector.keys().isEmpty()) && this.getStatus() != IOReactorStatus.SHUT_DOWN) continue;
        }
    }

    private void initiateSessionShutdown() {
        if (this.sessionShutdownCallback != null) {
            Object object = this.selector.keys();
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = (SelectionKey)object.next();
                if (!((object2 = (InternalChannel)((SelectionKey)object2).attachment()) instanceof InternalDataChannel)) continue;
                this.sessionShutdownCallback.execute((InternalDataChannel)object2);
            }
        }
    }

    private void validateActiveChannels() {
        long l2 = System.currentTimeMillis();
        if (l2 - this.lastTimeoutCheckMillis >= this.selectTimeoutMillis) {
            this.lastTimeoutCheckMillis = l2;
            for (SelectionKey selectionKey : this.selector.keys()) {
                this.checkTimeout(selectionKey, l2);
            }
        }
    }

    private void processEvents(Set<SelectionKey> set) {
        for (SelectionKey selectionKey : set) {
            InternalChannel internalChannel = (InternalChannel)selectionKey.attachment();
            if (internalChannel == null) continue;
            try {
                internalChannel.handleIOEvent(selectionKey.readyOps());
            }
            catch (CancelledKeyException cancelledKeyException) {
                internalChannel.close(CloseMode.GRACEFUL);
            }
        }
        set.clear();
    }

    private void processPendingChannels() throws IOException {
        Object object;
        for (int i2 = 0; i2 < 10000 && (object = this.channelQueue.poll()) != null; ++i2) {
            SelectionKey selectionKey;
            ByteChannel byteChannel = ((ChannelEntry)object).channel;
            object = ((ChannelEntry)object).attachment;
            try {
                this.prepareSocket((SocketChannel)byteChannel);
                ((AbstractSelectableChannel)((Object)byteChannel)).configureBlocking(false);
            }
            catch (IOException iOException) {
                this.logException(iOException);
                try {
                    ((AbstractInterruptibleChannel)((Object)byteChannel)).close();
                }
                catch (IOException iOException2) {
                    this.logException(iOException2);
                }
                throw iOException;
            }
            try {
                selectionKey = ((SelectableChannel)((Object)byteChannel)).register(this.selector, 1);
            }
            catch (ClosedChannelException closedChannelException) {
                return;
            }
            byteChannel = new IOSessionImpl("a", selectionKey, (SocketChannel)byteChannel, this.closedSessions::add);
            byteChannel = new InternalDataChannel((IOSession)byteChannel, null, this.ioSessionDecorator, this.sessionListener);
            ((InternalDataChannel)byteChannel).setSocketTimeout(this.reactorConfig.getSoTimeout());
            ((InternalDataChannel)byteChannel).upgrade(this.eventHandlerFactory.createHandler((ProtocolIOSession)byteChannel, object));
            selectionKey.attach(byteChannel);
            ((InternalChannel)((Object)byteChannel)).handleIOEvent(8);
        }
    }

    private void processClosedSessions() {
        IOSession iOSession;
        while ((iOSession = this.closedSessions.poll()) != null) {
            try {
                IOEventHandler iOEventHandler;
                if (this.sessionListener != null) {
                    this.sessionListener.disconnected(iOSession);
                }
                if ((iOEventHandler = iOSession.getHandler()) == null) continue;
                iOEventHandler.disconnected(iOSession);
            }
            catch (CancelledKeyException cancelledKeyException) {}
        }
    }

    private void checkTimeout(SelectionKey object, long l2) {
        if ((object = (InternalChannel)((SelectionKey)object).attachment()) != null) {
            ((InternalChannel)object).checkTimeout(l2);
        }
    }

    @Override
    public Future<IOSession> connect(NamedEndpoint object, SocketAddress socketAddress, SocketAddress socketAddress2, Timeout timeout, Object object2, FutureCallback<IOSession> futureCallback) throws IOReactorShutdownException {
        Args.notNull(object, "Remote endpoint");
        object = new IOSessionRequest((NamedEndpoint)object, socketAddress != null ? socketAddress : new InetSocketAddress(object.getHostName(), object.getPort()), socketAddress2, timeout, object2, futureCallback);
        this.requestQueue.add((IOSessionRequest)object);
        this.selector.wakeup();
        return object;
    }

    private void prepareSocket(SocketChannel socketChannel) throws IOException {
        int n2;
        Socket socket = socketChannel.socket();
        socket.setTcpNoDelay(this.reactorConfig.isTcpNoDelay());
        socket.setKeepAlive(this.reactorConfig.isSoKeepAlive());
        if (this.reactorConfig.getSndBufSize() > 0) {
            socket.setSendBufferSize(this.reactorConfig.getSndBufSize());
        }
        if (this.reactorConfig.getRcvBufSize() > 0) {
            socket.setReceiveBufferSize(this.reactorConfig.getRcvBufSize());
        }
        if (this.reactorConfig.getTrafficClass() > 0) {
            socket.setTrafficClass(this.reactorConfig.getTrafficClass());
        }
        if ((n2 = this.reactorConfig.getSoLinger().toSecondsIntBound()) >= 0) {
            socket.setSoLinger(true, n2);
        }
        if (this.reactorConfig.getTcpKeepIdle() > 0) {
            this.setExtendedSocketOption(socketChannel, "TCP_KEEPIDLE", this.reactorConfig.getTcpKeepIdle());
        }
        if (this.reactorConfig.getTcpKeepInterval() > 0) {
            this.setExtendedSocketOption(socketChannel, "TCP_KEEPINTERVAL", this.reactorConfig.getTcpKeepInterval());
        }
        if (this.reactorConfig.getTcpKeepInterval() > 0) {
            this.setExtendedSocketOption(socketChannel, "TCP_KEEPCOUNT", this.reactorConfig.getTcpKeepCount());
        }
    }

    <T> void setExtendedSocketOption(SocketChannel socketChannel, String string, T t2) throws IOException {
        SocketOption socketOption = SocketSupport.getExtendedSocketOptionOrNull(string);
        if (socketOption == null) {
            throw new UnsupportedOperationException(string + " is not supported in the current jdk");
        }
        socketChannel.setOption(socketOption, (Object)t2);
    }

    private void validateAddress(SocketAddress socketAddress) throws UnknownHostException {
        if (socketAddress instanceof InetSocketAddress && ((InetSocketAddress)(socketAddress = (InetSocketAddress)socketAddress)).isUnresolved()) {
            throw new UnknownHostException(((InetSocketAddress)socketAddress).getHostName());
        }
    }

    private void processPendingConnectionRequests() {
        IOSessionRequest iOSessionRequest;
        for (int i2 = 0; i2 < 10000 && (iOSessionRequest = this.requestQueue.poll()) != null; ++i2) {
            SocketChannel socketChannel;
            if (iOSessionRequest.isCancelled()) continue;
            try {
                socketChannel = SocketChannel.open();
            }
            catch (IOException iOException) {
                iOSessionRequest.failed(iOException);
                return;
            }
            try {
                this.processConnectionRequest(socketChannel, iOSessionRequest);
                continue;
            }
            catch (IOException | RuntimeException exception) {
                Closer.closeQuietly(socketChannel);
                iOSessionRequest.failed(exception);
            }
        }
    }

    private void processConnectionRequest(SocketChannel closeable, IOSessionRequest iOSessionRequest) throws IOException {
        Object object;
        ((AbstractSelectableChannel)closeable).configureBlocking(false);
        this.prepareSocket((SocketChannel)closeable);
        this.validateAddress(iOSessionRequest.localAddress);
        if (iOSessionRequest.localAddress != null) {
            object = ((SocketChannel)closeable).socket();
            ((Socket)object).setReuseAddress(this.reactorConfig.isSoReuseAddress());
            ((Socket)object).bind(iOSessionRequest.localAddress);
        }
        object = (object = this.reactorConfig.getSocksProxyAddress()) != null ? object : iOSessionRequest.remoteAddress;
        this.validateAddress((SocketAddress)object);
        boolean bl2 = ((SocketChannel)closeable).connect((SocketAddress)object);
        SelectionKey selectionKey = ((SelectableChannel)closeable).register(this.selector, 9);
        IOSession iOSession = new IOSessionImpl("c", selectionKey, (SocketChannel)closeable, this.closedSessions::add);
        iOSession = new InternalDataChannel(iOSession, iOSessionRequest.remoteEndpoint, this.ioSessionDecorator, this.sessionListener);
        ((InternalDataChannel)iOSession).setSocketTimeout(this.reactorConfig.getSoTimeout());
        closeable = new InternalConnectChannel(selectionKey, (SocketChannel)closeable, iOSessionRequest, (InternalDataChannel)iOSession, this.eventHandlerFactory, this.reactorConfig);
        if (bl2) {
            ((InternalChannel)closeable).handleIOEvent(8);
            return;
        }
        selectionKey.attach(closeable);
        iOSessionRequest.assign((ModalCloseable)closeable);
    }

    private void closePendingChannels() {
        Object object;
        while ((object = this.channelQueue.poll()) != null) {
            object = ((ChannelEntry)object).channel;
            try {
                ((AbstractInterruptibleChannel)object).close();
            }
            catch (IOException iOException) {
                this.logException(iOException);
            }
        }
    }

    private void closePendingConnectionRequests() {
        IOSessionRequest iOSessionRequest;
        while ((iOSessionRequest = this.requestQueue.poll()) != null) {
            iOSessionRequest.cancel();
        }
    }
}

