/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.charset.StandardCharsets;
import org.apache.hc.core5.http.nio.command.CommandSupport;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.SocketTimeoutExceptionFactory;
import org.apache.hc.core5.reactor.IOEventHandler;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.IOSessionRequest;
import org.apache.hc.core5.reactor.InternalDataChannel;
import org.apache.hc.core5.reactor.SocksProxyProtocolHandler$State;
import org.apache.hc.core5.util.Timeout;

final class SocksProxyProtocolHandler
implements IOEventHandler {
    private static final int MAX_DNS_NAME_LENGTH = 255;
    private static final int MAX_COMMAND_CONNECT_LENGTH = 262;
    private static final byte CLIENT_VERSION = 5;
    private static final byte NO_AUTHENTICATION_REQUIRED = 0;
    private static final byte USERNAME_PASSWORD = 2;
    private static final byte USERNAME_PASSWORD_VERSION = 1;
    private static final byte SUCCESS = 0;
    private static final byte COMMAND_CONNECT = 1;
    private static final byte ATYP_DOMAINNAME = 3;
    private final InternalDataChannel dataChannel;
    private final IOSessionRequest sessionRequest;
    private final IOEventHandlerFactory eventHandlerFactory;
    private final IOReactorConfig reactorConfig;
    private ByteBuffer buffer = ByteBuffer.allocate(512);
    private SocksProxyProtocolHandler$State state = SocksProxyProtocolHandler$State.SEND_AUTH;

    SocksProxyProtocolHandler(InternalDataChannel internalDataChannel, IOSessionRequest iOSessionRequest, IOEventHandlerFactory iOEventHandlerFactory, IOReactorConfig iOReactorConfig) {
        this.dataChannel = internalDataChannel;
        this.sessionRequest = iOSessionRequest;
        this.eventHandlerFactory = iOEventHandlerFactory;
        this.reactorConfig = iOReactorConfig;
    }

    @Override
    public final void connected(IOSession iOSession) throws IOException {
        this.buffer.put((byte)5);
        if (this.reactorConfig.getSocksProxyUsername() != null && this.reactorConfig.getSocksProxyPassword() != null) {
            this.buffer.put((byte)2);
            this.buffer.put((byte)0);
            this.buffer.put((byte)2);
        } else {
            this.buffer.put((byte)1);
            this.buffer.put((byte)0);
        }
        this.buffer.flip();
        iOSession.setEventMask(4);
    }

    @Override
    public final void outputReady(IOSession iOSession) throws IOException {
        switch (this.state) {
            case SEND_AUTH: {
                if (!this.writeAndPrepareRead(iOSession, 2)) break;
                iOSession.setEventMask(1);
                this.state = SocksProxyProtocolHandler$State.RECEIVE_AUTH_METHOD;
                return;
            }
            case SEND_USERNAME_PASSWORD: {
                if (!this.writeAndPrepareRead(iOSession, 2)) break;
                iOSession.setEventMask(1);
                this.state = SocksProxyProtocolHandler$State.RECEIVE_AUTH;
                return;
            }
            case SEND_CONNECT: {
                if (!this.writeAndPrepareRead(iOSession, 2)) break;
                iOSession.setEventMask(1);
                this.state = SocksProxyProtocolHandler$State.RECEIVE_RESPONSE_CODE;
                return;
            }
            case RECEIVE_AUTH_METHOD: 
            case RECEIVE_AUTH: 
            case RECEIVE_ADDRESS: 
            case RECEIVE_ADDRESS_TYPE: 
            case RECEIVE_RESPONSE_CODE: {
                iOSession.setEventMask(1);
            }
        }
    }

    private byte[] cred(String object) throws IOException {
        if (object == null) {
            return new byte[0];
        }
        byte[] byArray = ((String)object).getBytes(StandardCharsets.ISO_8859_1);
        object = byArray;
        if (byArray.length >= 255) {
            throw new IOException("SOCKS username / password are too long");
        }
        return object;
    }

    @Override
    public final void inputReady(IOSession iOSession, ByteBuffer object) throws IOException {
        if (object != null) {
            try {
                this.buffer.put((ByteBuffer)object);
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new IOException("Unexpected input data");
            }
        }
        switch (this.state) {
            case RECEIVE_AUTH_METHOD: {
                if (!this.fillBuffer(iOSession)) break;
                this.buffer.flip();
                byte by2 = this.buffer.get();
                byte by3 = this.buffer.get();
                if (by2 != 5) {
                    throw new IOException("SOCKS server returned unsupported version: " + by2);
                }
                if (by3 == 2) {
                    this.buffer.clear();
                    SocksProxyProtocolHandler socksProxyProtocolHandler = this;
                    byte[] byArray = socksProxyProtocolHandler.cred(socksProxyProtocolHandler.reactorConfig.getSocksProxyUsername());
                    SocksProxyProtocolHandler socksProxyProtocolHandler2 = this;
                    byte[] byArray2 = socksProxyProtocolHandler2.cred(socksProxyProtocolHandler2.reactorConfig.getSocksProxyPassword());
                    this.setBufferLimit(byArray.length + byArray2.length + 3);
                    this.buffer.put((byte)1);
                    this.buffer.put((byte)byArray.length);
                    this.buffer.put(byArray);
                    this.buffer.put((byte)byArray2.length);
                    this.buffer.put(byArray2);
                    this.buffer.flip();
                    iOSession.setEventMask(4);
                    this.state = SocksProxyProtocolHandler$State.SEND_USERNAME_PASSWORD;
                    break;
                }
                if (by3 == 0) {
                    this.prepareConnectCommand();
                    iOSession.setEventMask(4);
                    this.state = SocksProxyProtocolHandler$State.SEND_CONNECT;
                    break;
                }
                throw new IOException("SOCKS server return unsupported authentication method: " + by3);
            }
            case RECEIVE_AUTH: {
                if (!this.fillBuffer(iOSession)) break;
                this.buffer.flip();
                this.buffer.get();
                byte by4 = this.buffer.get();
                if (by4 != 0) {
                    throw new IOException("Authentication failed for external SOCKS proxy");
                }
                this.prepareConnectCommand();
                iOSession.setEventMask(4);
                this.state = SocksProxyProtocolHandler$State.SEND_CONNECT;
                return;
            }
            case RECEIVE_RESPONSE_CODE: {
                if (!this.fillBuffer(iOSession)) break;
                this.buffer.flip();
                byte by5 = this.buffer.get();
                int n2 = this.buffer.get();
                if (by5 != 5) {
                    throw new IOException("SOCKS server returned unsupported version: " + by5);
                }
                switch (n2) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        throw new IOException("SOCKS: General SOCKS server failure");
                    }
                    case 2: {
                        throw new IOException("SOCKS5: Connection not allowed by ruleset");
                    }
                    case 3: {
                        throw new IOException("SOCKS5: Network unreachable");
                    }
                    case 4: {
                        throw new IOException("SOCKS5: Host unreachable");
                    }
                    case 5: {
                        throw new IOException("SOCKS5: Connection refused");
                    }
                    case 6: {
                        throw new IOException("SOCKS5: TTL expired");
                    }
                    case 7: {
                        throw new IOException("SOCKS5: Command not supported");
                    }
                    case 8: {
                        throw new IOException("SOCKS5: Address type not supported");
                    }
                    default: {
                        throw new IOException("SOCKS5: Unexpected SOCKS response code " + n2);
                    }
                }
                this.buffer.compact();
                this.buffer.limit(3);
                this.state = SocksProxyProtocolHandler$State.RECEIVE_ADDRESS_TYPE;
            }
            case RECEIVE_ADDRESS_TYPE: {
                int n2;
                if (!this.fillBuffer(iOSession)) break;
                this.buffer.flip();
                this.buffer.get();
                int n3 = this.buffer.get();
                if (n3 == 1) {
                    n2 = 4;
                } else if (n3 == 4) {
                    n2 = 16;
                } else if (n3 == 3) {
                    n2 = this.buffer.get() & 0xFF;
                } else {
                    throw new IOException("SOCKS server returned unsupported address type: " + n3);
                }
                n3 = n2 + 2;
                this.buffer.compact();
                this.buffer.limit(n3);
                this.state = SocksProxyProtocolHandler$State.RECEIVE_ADDRESS;
            }
            case RECEIVE_ADDRESS: {
                if (!this.fillBuffer(iOSession)) break;
                this.buffer.clear();
                this.state = SocksProxyProtocolHandler$State.COMPLETE;
                object = this.eventHandlerFactory.createHandler(this.dataChannel, this.sessionRequest.attachment);
                this.dataChannel.upgrade((IOEventHandler)object);
                this.sessionRequest.completed(this.dataChannel);
                this.dataChannel.handleIOEvent(8);
                return;
            }
            case SEND_AUTH: 
            case SEND_USERNAME_PASSWORD: 
            case SEND_CONNECT: {
                iOSession.setEventMask(4);
            }
        }
    }

    private void prepareConnectCommand() throws IOException {
        Object object;
        this.buffer.clear();
        this.setBufferLimit(262);
        this.buffer.put((byte)5);
        this.buffer.put((byte)1);
        this.buffer.put((byte)0);
        if (!(this.sessionRequest.remoteAddress instanceof InetSocketAddress)) {
            throw new IOException("Unsupported address class: " + this.sessionRequest.remoteAddress.getClass());
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)this.sessionRequest.remoteAddress;
        if (inetSocketAddress.isUnresolved()) {
            this.buffer.put((byte)3);
            object = inetSocketAddress.getHostName();
            byte[] byArray = ((String)object).getBytes(StandardCharsets.US_ASCII);
            object = byArray;
            if (byArray.length > 255) {
                throw new IOException("Host name exceeds 255 bytes");
            }
            this.buffer.put((byte)((Object)object).length);
            this.buffer.put((byte[])object);
        } else {
            object = inetSocketAddress.getAddress();
            if (object instanceof Inet4Address) {
                this.buffer.put((byte)1);
            } else if (object instanceof Inet6Address) {
                this.buffer.put((byte)4);
            } else {
                throw new IOException("Unsupported remote address class: " + object.getClass().getName());
            }
            this.buffer.put(((InetAddress)object).getAddress());
        }
        int n2 = inetSocketAddress.getPort();
        this.buffer.putShort((short)n2);
        this.buffer.flip();
    }

    private void setBufferLimit(int n2) {
        if (this.buffer.capacity() < n2) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
            this.buffer.flip();
            byteBuffer.put(this.buffer);
            this.buffer = byteBuffer;
            return;
        }
        this.buffer.limit(n2);
    }

    private boolean writeAndPrepareRead(ByteChannel byteChannel, int n2) throws IOException {
        if (this.writeBuffer(byteChannel)) {
            this.buffer.clear();
            this.setBufferLimit(n2);
            return true;
        }
        return false;
    }

    private boolean writeBuffer(ByteChannel byteChannel) throws IOException {
        if (this.buffer.hasRemaining()) {
            byteChannel.write(this.buffer);
        }
        return !this.buffer.hasRemaining();
    }

    private boolean fillBuffer(ByteChannel byteChannel) throws IOException {
        if (this.buffer.hasRemaining()) {
            byteChannel.read(this.buffer);
        }
        return !this.buffer.hasRemaining();
    }

    @Override
    public final void timeout(IOSession iOSession, Timeout timeout) throws IOException {
        this.exception(iOSession, SocketTimeoutExceptionFactory.create(timeout));
    }

    @Override
    public final void exception(IOSession iOSession, Exception exception) {
        try {
            this.sessionRequest.failed(exception);
            return;
        }
        finally {
            iOSession.close(CloseMode.IMMEDIATE);
            CommandSupport.failCommands(iOSession, exception);
        }
    }

    @Override
    public final void disconnected(IOSession iOSession) {
        this.sessionRequest.cancel();
        CommandSupport.cancelCommands(iOSession);
    }
}

