/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.util;

import java.text.ParseException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.concurrent.TimeUnit;
import org.apache.hc.core5.util.TimeValue;

public class Deadline {
    public static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final long INTERNAL_MAX_VALUE = Long.MAX_VALUE;
    private static final long INTERNAL_MIN_VALUE = 0L;
    public static Deadline MAX_VALUE = new Deadline(Long.MAX_VALUE);
    public static Deadline MIN_VALUE = new Deadline(0L);
    private static final DateTimeFormatter DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().parseLenient().parseCaseInsensitive().appendPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ").toFormatter();
    private volatile boolean frozen;
    private volatile long lastCheck;
    private final long value;

    public static Deadline calculate(long l2, TimeValue timeValue) {
        if (TimeValue.isPositive(timeValue)) {
            long l3 = l2 + timeValue.toMilliseconds();
            if (l3 < 0L) {
                return MAX_VALUE;
            }
            return Deadline.fromUnixMilliseconds(l3);
        }
        return MAX_VALUE;
    }

    public static Deadline calculate(TimeValue timeValue) {
        return Deadline.calculate(System.currentTimeMillis(), timeValue);
    }

    public static Deadline fromUnixMilliseconds(long l2) {
        if (l2 == Long.MAX_VALUE) {
            return MAX_VALUE;
        }
        if (l2 == 0L) {
            return MIN_VALUE;
        }
        return new Deadline(l2);
    }

    public static Deadline parse(String object) throws ParseException {
        if (object == null) {
            return null;
        }
        object = Instant.from(DATE_TIME_FORMATTER.parse((CharSequence)object));
        return Deadline.fromUnixMilliseconds(((Instant)object).toEpochMilli());
    }

    private Deadline(long l2) {
        this.value = l2;
        this.setLastCheck();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (Deadline)object;
        return this.value == ((Deadline)object).value;
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }

    public String format(TimeUnit timeUnit) {
        if (this.value == Deadline.MAX_VALUE.value) {
            return "No deadline (infinite)";
        }
        return String.format("Deadline: %s, %s overdue", this.formatTarget(), TimeValue.of(this.remaining(), timeUnit));
    }

    public String formatTarget() {
        if (this.value == Deadline.MAX_VALUE.value) {
            return "(infinite)";
        }
        return DATE_TIME_FORMATTER.format(Instant.ofEpochMilli(this.value).atOffset(ZoneOffset.UTC));
    }

    public Deadline freeze() {
        this.frozen = true;
        return this;
    }

    long getLastCheck() {
        return this.lastCheck;
    }

    public long getValue() {
        return this.value;
    }

    public boolean isBefore(long l2) {
        return this.value < l2;
    }

    public boolean isExpired() {
        this.setLastCheck();
        return this.value < this.lastCheck;
    }

    public boolean isMax() {
        return this.value == Long.MAX_VALUE;
    }

    public boolean isMin() {
        return this.value == 0L;
    }

    public boolean isNotExpired() {
        this.setLastCheck();
        return this.value >= this.lastCheck;
    }

    public Deadline min(Deadline deadline) {
        if (this.value <= deadline.value) {
            return this;
        }
        return deadline;
    }

    public long remaining() {
        this.setLastCheck();
        return this.value - this.lastCheck;
    }

    public TimeValue remainingTimeValue() {
        return TimeValue.of(this.remaining(), TimeUnit.MILLISECONDS);
    }

    private void setLastCheck() {
        if (!this.frozen) {
            this.lastCheck = System.currentTimeMillis();
        }
    }

    public String toString() {
        return this.formatTarget();
    }
}

