/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.util;

import java.util.Locale;
import org.apache.hc.core5.annotation.Internal;

public final class TextUtils {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private TextUtils() {
    }

    public static boolean isEmpty(CharSequence charSequence) {
        return TextUtils.length(charSequence) == 0;
    }

    public static boolean isBlank(CharSequence charSequence) {
        int n2 = TextUtils.length(charSequence);
        if (n2 == 0) {
            return true;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isWhitespace(charSequence.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static int length(CharSequence charSequence) {
        if (charSequence == null) {
            return 0;
        }
        return charSequence.length();
    }

    public static boolean containsBlanks(CharSequence charSequence) {
        int n2 = TextUtils.length(charSequence);
        if (n2 == 0) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!Character.isWhitespace(charSequence.charAt(i2))) continue;
            return true;
        }
        return false;
    }

    public static String toHexString(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(byArray.length << 1);
        for (byte by2 : byArray) {
            stringBuilder.append(HEX_CHARS[(0xF0 & by2) >>> 4]).append(HEX_CHARS[0xF & by2]);
        }
        return stringBuilder.toString();
    }

    public static String toLowerCase(String string) {
        if (string == null) {
            return null;
        }
        return string.toLowerCase(Locale.ROOT);
    }

    public static boolean isAllASCII(CharSequence charSequence) {
        int n2 = TextUtils.length(charSequence);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (charSequence.charAt(i2) <= '\u007f') continue;
            return false;
        }
        return true;
    }

    @Internal
    public static byte castAsByte(int n2) {
        if (n2 >= 32 && n2 <= 126 || n2 >= 160 && n2 <= 255 || n2 == 9) {
            return (byte)n2;
        }
        return 63;
    }
}

