/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.util;

import java.text.ParseException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.LangUtils;
import org.apache.hc.core5.util.Timeout;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class TimeValue
implements Comparable<TimeValue> {
    static final int INT_UNDEFINED = -1;
    public static final TimeValue MAX_VALUE = TimeValue.ofDays(Long.MAX_VALUE);
    public static final TimeValue NEG_ONE_MILLISECOND = TimeValue.of(-1L, TimeUnit.MILLISECONDS);
    public static final TimeValue NEG_ONE_SECOND = TimeValue.of(-1L, TimeUnit.SECONDS);
    public static final TimeValue ZERO_MILLISECONDS = TimeValue.of(0L, TimeUnit.MILLISECONDS);
    private final long duration;
    private final TimeUnit timeUnit;

    public static int asBoundInt(long l2) {
        if (l2 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (l2 < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)l2;
    }

    public static <T extends TimeValue> T defaultsTo(T t2, T t3) {
        if (t2 != null) {
            return t2;
        }
        return t3;
    }

    public static TimeValue defaultsToNegativeOneMillisecond(TimeValue timeValue) {
        return TimeValue.defaultsTo(timeValue, NEG_ONE_MILLISECOND);
    }

    public static TimeValue defaultsToNegativeOneSecond(TimeValue timeValue) {
        return TimeValue.defaultsTo(timeValue, NEG_ONE_SECOND);
    }

    public static TimeValue defaultsToZeroMilliseconds(TimeValue timeValue) {
        return TimeValue.defaultsTo(timeValue, ZERO_MILLISECONDS);
    }

    public static boolean isNonNegative(TimeValue timeValue) {
        return timeValue != null && timeValue.getDuration() >= 0L;
    }

    public static boolean isPositive(TimeValue timeValue) {
        return timeValue != null && timeValue.getDuration() > 0L;
    }

    public static TimeValue of(long l2, TimeUnit timeUnit) {
        return new TimeValue(l2, timeUnit);
    }

    public static TimeValue of(Duration duration) {
        long l2 = duration.getSeconds();
        long l3 = duration.getNano();
        if (l2 == 0L) {
            return TimeValue.of(l3, TimeUnit.NANOSECONDS);
        }
        if (l3 == 0L) {
            return TimeValue.of(l2, TimeUnit.SECONDS);
        }
        try {
            return TimeValue.of(duration.toNanos(), TimeUnit.NANOSECONDS);
        }
        catch (ArithmeticException arithmeticException) {
            try {
                return TimeValue.of(duration.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (ArithmeticException arithmeticException2) {
                return TimeValue.of(l2, TimeUnit.SECONDS);
            }
        }
    }

    public static TimeValue ofDays(long l2) {
        return TimeValue.of(l2, TimeUnit.DAYS);
    }

    public static TimeValue ofHours(long l2) {
        return TimeValue.of(l2, TimeUnit.HOURS);
    }

    public static TimeValue ofMicroseconds(long l2) {
        return TimeValue.of(l2, TimeUnit.MICROSECONDS);
    }

    public static TimeValue ofMilliseconds(long l2) {
        return TimeValue.of(l2, TimeUnit.MILLISECONDS);
    }

    public static TimeValue ofMinutes(long l2) {
        return TimeValue.of(l2, TimeUnit.MINUTES);
    }

    public static TimeValue ofNanoseconds(long l2) {
        return TimeValue.of(l2, TimeUnit.NANOSECONDS);
    }

    public static TimeValue ofSeconds(long l2) {
        return TimeValue.of(l2, TimeUnit.SECONDS);
    }

    static ChronoUnit toChronoUnit(TimeUnit timeUnit) {
        switch (Objects.requireNonNull(timeUnit)) {
            case NANOSECONDS: {
                return ChronoUnit.NANOS;
            }
            case MICROSECONDS: {
                return ChronoUnit.MICROS;
            }
            case MILLISECONDS: {
                return ChronoUnit.MILLIS;
            }
            case SECONDS: {
                return ChronoUnit.SECONDS;
            }
            case MINUTES: {
                return ChronoUnit.MINUTES;
            }
            case HOURS: {
                return ChronoUnit.HOURS;
            }
            case DAYS: {
                return ChronoUnit.DAYS;
            }
        }
        throw new IllegalArgumentException(timeUnit.toString());
    }

    public static TimeValue parse(String string) throws ParseException {
        Object object = string.trim().split("\\s+");
        if (((String[])object).length < 2) {
            throw new IllegalArgumentException(String.format("Expected format for <Long><SPACE><java.util.concurrent.TimeUnit>: %s", string));
        }
        string = object[0].trim();
        object = (object = object[1].trim().toUpperCase(Locale.ROOT)).endsWith("S") ? object : (String)object + "S";
        return TimeValue.of(Long.parseLong(string), TimeUnit.valueOf((String)object));
    }

    TimeValue(long l2, TimeUnit timeUnit) {
        this.duration = l2;
        this.timeUnit = Args.notNull(timeUnit, "timeUnit");
    }

    public long convert(TimeUnit timeUnit) {
        Args.notNull(timeUnit, "timeUnit");
        return timeUnit.convert(this.duration, this.timeUnit);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof TimeValue) {
            long l2;
            object = (TimeValue)object;
            long l3 = this.convert(TimeUnit.NANOSECONDS);
            return l3 == (l2 = ((TimeValue)object).convert(TimeUnit.NANOSECONDS));
        }
        return false;
    }

    public TimeValue divide(long l2) {
        long l3 = this.duration / l2;
        return TimeValue.of(l3, this.timeUnit);
    }

    public TimeValue divide(long l2, TimeUnit timeUnit) {
        return TimeValue.of(this.convert(timeUnit) / l2, timeUnit);
    }

    public long getDuration() {
        return this.duration;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public int hashCode() {
        int n2 = LangUtils.hashCode(17, this.convert(TimeUnit.NANOSECONDS));
        return n2;
    }

    public TimeValue min(TimeValue timeValue) {
        if (this.compareTo(timeValue) > 0) {
            return timeValue;
        }
        return this;
    }

    private TimeUnit min(TimeUnit timeUnit) {
        if (this.scale() > this.scale(timeUnit)) {
            return timeUnit;
        }
        return this.getTimeUnit();
    }

    private int scale() {
        TimeValue timeValue = this;
        return timeValue.scale(timeValue.timeUnit);
    }

    private int scale(TimeUnit timeUnit) {
        switch (timeUnit) {
            case NANOSECONDS: {
                return 1;
            }
            case MICROSECONDS: {
                return 2;
            }
            case MILLISECONDS: {
                return 3;
            }
            case SECONDS: {
                return 4;
            }
            case MINUTES: {
                return 5;
            }
            case HOURS: {
                return 6;
            }
            case DAYS: {
                return 7;
            }
        }
        throw new IllegalStateException();
    }

    public void sleep() throws InterruptedException {
        this.timeUnit.sleep(this.duration);
    }

    public void timedJoin(Thread thread) throws InterruptedException {
        this.timeUnit.timedJoin(thread, this.duration);
    }

    public void timedWait(Object object) throws InterruptedException {
        this.timeUnit.timedWait(object, this.duration);
    }

    public long toDays() {
        return this.timeUnit.toDays(this.duration);
    }

    public Duration toDuration() {
        if (this.duration == 0L) {
            return Duration.ZERO;
        }
        return Duration.of(this.duration, TimeValue.toChronoUnit(this.timeUnit));
    }

    public long toHours() {
        return this.timeUnit.toHours(this.duration);
    }

    public long toMicroseconds() {
        return this.timeUnit.toMicros(this.duration);
    }

    public long toMilliseconds() {
        return this.timeUnit.toMillis(this.duration);
    }

    public int toMillisecondsIntBound() {
        return TimeValue.asBoundInt(this.toMilliseconds());
    }

    public long toMinutes() {
        return this.timeUnit.toMinutes(this.duration);
    }

    public long toNanoseconds() {
        return this.timeUnit.toNanos(this.duration);
    }

    public long toSeconds() {
        return this.timeUnit.toSeconds(this.duration);
    }

    public int toSecondsIntBound() {
        return TimeValue.asBoundInt(this.toSeconds());
    }

    @Override
    public int compareTo(TimeValue timeValue) {
        TimeUnit timeUnit = this.min(timeValue.getTimeUnit());
        return Long.compare(this.convert(timeUnit), timeValue.convert(timeUnit));
    }

    public String toString() {
        return String.format("%d %s", new Object[]{this.duration, this.timeUnit});
    }

    public Timeout toTimeout() {
        return Timeout.of(this.duration, this.timeUnit);
    }
}

