/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.util;

import java.util.BitSet;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Tokenizer$Cursor;
import org.apache.hc.core5.util.Tokenizer$Delimiter;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class Tokenizer {
    public static final char DQUOTE = '\"';
    public static final char ESCAPE = '\\';
    public static final int CR = 13;
    public static final int LF = 10;
    public static final int SP = 32;
    public static final int HT = 9;
    public static final Tokenizer INSTANCE = new Tokenizer();

    @Deprecated
    public static BitSet INIT_BITSET(int ... nArray) {
        BitSet bitSet = new BitSet();
        for (int n2 : nArray) {
            bitSet.set(n2);
        }
        return bitSet;
    }

    public static boolean isWhitespace(char c2) {
        return c2 == ' ' || c2 == '\t' || c2 == '\r' || c2 == '\n';
    }

    public static Tokenizer$Delimiter delimiters(BitSet bitSet) {
        return bitSet::get;
    }

    public static Tokenizer$Delimiter delimiters(char ... cArray) {
        return c2 -> {
            for (char c3 : cArray) {
                if (c3 != c2) continue;
                return true;
            }
            return false;
        };
    }

    public static Tokenizer$Delimiter delimiters(char c2) {
        return c3 -> c3 == c2;
    }

    public static Tokenizer$Delimiter delimiters(char c2, char c3) {
        return c4 -> c4 == c2 || c4 == c3;
    }

    public static Tokenizer$Delimiter delimiters(char c2, char c3, char c4) {
        return c5 -> c5 == c2 || c5 == c3 || c5 == c4;
    }

    public String parseContent(CharSequence charSequence, Tokenizer$Cursor tokenizer$Cursor, Tokenizer$Delimiter tokenizer$Delimiter) {
        Args.notNull(charSequence, "Char sequence");
        Args.notNull(tokenizer$Cursor, "Parser cursor");
        StringBuilder stringBuilder = new StringBuilder();
        this.copyContent(charSequence, tokenizer$Cursor, tokenizer$Delimiter, stringBuilder);
        return stringBuilder.toString();
    }

    @Deprecated
    public String parseContent(CharSequence charSequence, Tokenizer$Cursor tokenizer$Cursor, BitSet bitSet) {
        return this.parseContent(charSequence, tokenizer$Cursor, bitSet != null ? bitSet::get : null);
    }

    public String parseToken(CharSequence charSequence, Tokenizer$Cursor tokenizer$Cursor, Tokenizer$Delimiter tokenizer$Delimiter) {
        Args.notNull(charSequence, "Char sequence");
        Args.notNull(tokenizer$Cursor, "Parser cursor");
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        while (!tokenizer$Cursor.atEnd()) {
            char c2 = charSequence.charAt(tokenizer$Cursor.getPos());
            if (tokenizer$Delimiter != null && tokenizer$Delimiter.test(c2)) break;
            if (Tokenizer.isWhitespace(c2)) {
                this.skipWhiteSpace(charSequence, tokenizer$Cursor);
                bl2 = true;
                continue;
            }
            if (bl2 && stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            this.copyContent(charSequence, tokenizer$Cursor, tokenizer$Delimiter, stringBuilder);
            bl2 = false;
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public String parseToken(CharSequence charSequence, Tokenizer$Cursor tokenizer$Cursor, BitSet bitSet) {
        return this.parseToken(charSequence, tokenizer$Cursor, bitSet != null ? bitSet::get : null);
    }

    public String parseValue(CharSequence charSequence, Tokenizer$Cursor tokenizer$Cursor, Tokenizer$Delimiter tokenizer$Delimiter) {
        Args.notNull(charSequence, "Char sequence");
        Args.notNull(tokenizer$Cursor, "Parser cursor");
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        while (!tokenizer$Cursor.atEnd()) {
            char c2 = charSequence.charAt(tokenizer$Cursor.getPos());
            if (tokenizer$Delimiter != null && tokenizer$Delimiter.test(c2)) break;
            if (Tokenizer.isWhitespace(c2)) {
                this.skipWhiteSpace(charSequence, tokenizer$Cursor);
                bl2 = true;
                continue;
            }
            if (c2 == '\"') {
                if (bl2 && stringBuilder.length() > 0) {
                    stringBuilder.append(' ');
                }
                this.copyQuotedContent(charSequence, tokenizer$Cursor, stringBuilder);
                bl2 = false;
                continue;
            }
            if (bl2 && stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            this.copyUnquotedContent(charSequence, tokenizer$Cursor, tokenizer$Delimiter, stringBuilder);
            bl2 = false;
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public String parseValue(CharSequence charSequence, Tokenizer$Cursor tokenizer$Cursor, BitSet bitSet) {
        return this.parseValue(charSequence, tokenizer$Cursor, bitSet != null ? bitSet::get : null);
    }

    public void skipWhiteSpace(CharSequence charSequence, Tokenizer$Cursor tokenizer$Cursor) {
        char c2;
        Args.notNull(charSequence, "Char sequence");
        Args.notNull(tokenizer$Cursor, "Parser cursor");
        int n2 = tokenizer$Cursor.getPos();
        int n3 = tokenizer$Cursor.getPos();
        int n4 = tokenizer$Cursor.getUpperBound();
        while (n3 < n4 && Tokenizer.isWhitespace(c2 = charSequence.charAt(n3))) {
            ++n2;
            ++n3;
        }
        tokenizer$Cursor.updatePos(n2);
    }

    public void copyContent(CharSequence charSequence, Tokenizer$Cursor tokenizer$Cursor, Tokenizer$Delimiter tokenizer$Delimiter, StringBuilder stringBuilder) {
        Args.notNull(charSequence, "Char sequence");
        Args.notNull(tokenizer$Cursor, "Parser cursor");
        Args.notNull(stringBuilder, "String builder");
        int n2 = tokenizer$Cursor.getPos();
        int n3 = tokenizer$Cursor.getPos();
        int n4 = tokenizer$Cursor.getUpperBound();
        while (n3 < n4) {
            char c2 = charSequence.charAt(n3);
            if (tokenizer$Delimiter != null && tokenizer$Delimiter.test(c2) || Tokenizer.isWhitespace(c2)) break;
            ++n2;
            stringBuilder.append(c2);
            ++n3;
        }
        tokenizer$Cursor.updatePos(n2);
    }

    @Deprecated
    public void copyContent(CharSequence charSequence, Tokenizer$Cursor tokenizer$Cursor, BitSet bitSet, StringBuilder stringBuilder) {
        this.copyContent(charSequence, tokenizer$Cursor, bitSet != null ? bitSet::get : null, stringBuilder);
    }

    public void copyUnquotedContent(CharSequence charSequence, Tokenizer$Cursor tokenizer$Cursor, Tokenizer$Delimiter tokenizer$Delimiter, StringBuilder stringBuilder) {
        Args.notNull(charSequence, "Char sequence");
        Args.notNull(tokenizer$Cursor, "Parser cursor");
        Args.notNull(stringBuilder, "String builder");
        int n2 = tokenizer$Cursor.getPos();
        int n3 = tokenizer$Cursor.getPos();
        int n4 = tokenizer$Cursor.getUpperBound();
        while (n3 < n4) {
            char c2 = charSequence.charAt(n3);
            if (tokenizer$Delimiter != null && tokenizer$Delimiter.test(c2) || Tokenizer.isWhitespace(c2) || c2 == '\"') break;
            ++n2;
            stringBuilder.append(c2);
            ++n3;
        }
        tokenizer$Cursor.updatePos(n2);
    }

    @Deprecated
    public void copyUnquotedContent(CharSequence charSequence, Tokenizer$Cursor tokenizer$Cursor, BitSet bitSet, StringBuilder stringBuilder) {
        this.copyUnquotedContent(charSequence, tokenizer$Cursor, bitSet != null ? bitSet::get : null, stringBuilder);
    }

    public void copyQuotedContent(CharSequence charSequence, Tokenizer$Cursor tokenizer$Cursor, StringBuilder stringBuilder) {
        Args.notNull(charSequence, "Char sequence");
        Args.notNull(tokenizer$Cursor, "Parser cursor");
        Args.notNull(stringBuilder, "String builder");
        if (tokenizer$Cursor.atEnd()) {
            return;
        }
        int n2 = tokenizer$Cursor.getPos();
        int n3 = tokenizer$Cursor.getPos();
        int n4 = tokenizer$Cursor.getUpperBound();
        char c2 = charSequence.charAt(n2);
        if (c2 != '\"') {
            return;
        }
        ++n2;
        ++n3;
        boolean bl2 = false;
        while (n3 < n4) {
            c2 = charSequence.charAt(n3);
            if (bl2) {
                if (c2 != '\"' && c2 != '\\') {
                    stringBuilder.append('\\');
                }
                stringBuilder.append(c2);
                bl2 = false;
            } else {
                if (c2 == '\"') {
                    ++n2;
                    break;
                }
                if (c2 == '\\') {
                    bl2 = true;
                } else if (c2 != '\r' && c2 != '\n') {
                    stringBuilder.append(c2);
                }
            }
            ++n3;
            ++n2;
        }
        tokenizer$Cursor.updatePos(n2);
    }
}

