/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject$Null;
import org.json.JSONParserConfiguration;
import org.json.JSONPointer;
import org.json.JSONPointerException;
import org.json.JSONPropertyIgnore;
import org.json.JSONPropertyName;
import org.json.JSONString;
import org.json.JSONTokener;
import org.json.JSONWriter;
import org.json.StringBuilderWriter;

public class JSONObject {
    static final Pattern NUMBER_PATTERN = Pattern.compile("-?(?:0|[1-9]\\d*)(?:\\.\\d+)?(?:[eE][+-]?\\d+)?");
    private final Map<String, Object> map;
    public static final Object NULL = new JSONObject$Null(null);

    public Class<? extends Map> getMapType() {
        return this.map.getClass();
    }

    public JSONObject() {
        this.map = new HashMap<String, Object>();
    }

    public JSONObject(JSONObject jSONObject, String ... stringArray) {
        this(stringArray.length);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            try {
                this.putOnce(stringArray[i2], jSONObject.opt(stringArray[i2]));
                continue;
            }
            catch (Exception exception) {}
        }
    }

    public JSONObject(JSONTokener jSONTokener) throws JSONException {
        JSONTokener jSONTokener2 = jSONTokener;
        this(jSONTokener2, jSONTokener2.getJsonParserConfiguration());
    }

    public JSONObject(JSONTokener jSONTokener, JSONParserConfiguration jSONParserConfiguration) throws JSONException {
        this();
        boolean bl2;
        boolean bl3 = bl2 = jSONTokener.getPrevious() == '\u0000';
        if (jSONTokener.nextClean() != '{') {
            throw jSONTokener.syntaxError("A JSONObject text must begin with '{'");
        }
        block9: while (true) {
            char c2 = jSONTokener.nextClean();
            switch (c2) {
                case '\u0000': {
                    throw jSONTokener.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    if (bl2 && jSONParserConfiguration.isStrictMode() && jSONTokener.nextClean() != '\u0000') {
                        throw jSONTokener.syntaxError("Strict mode error: Unparsed characters found at end of input text");
                    }
                    return;
                }
            }
            String string = jSONTokener.nextSimpleValue(c2).toString();
            c2 = jSONTokener.nextClean();
            if (c2 != ':') {
                throw jSONTokener.syntaxError("Expected a ':' after a key");
            }
            if (string != null) {
                c2 = this.opt(string) != null ? (char)'\u0001' : '\u0000';
                if (c2 != '\u0000' && !jSONParserConfiguration.isOverwriteDuplicateKey()) {
                    throw jSONTokener.syntaxError("Duplicate key \"" + string + "\"");
                }
                Object object = jSONTokener.nextValue();
                if (object != null) {
                    this.put(string, object);
                }
            }
            switch (jSONTokener.nextClean()) {
                case ';': {
                    if (jSONParserConfiguration.isStrictMode()) {
                        throw jSONTokener.syntaxError("Strict mode error: Invalid character ';' found");
                    }
                }
                case ',': {
                    if (jSONTokener.nextClean() == '}') {
                        if (jSONParserConfiguration.isStrictMode()) {
                            throw jSONTokener.syntaxError("Strict mode error: Expected another object element");
                        }
                        return;
                    }
                    if (jSONTokener.end()) {
                        throw jSONTokener.syntaxError("A JSONObject text must end with '}'");
                    }
                    jSONTokener.back();
                    continue block9;
                }
                case '}': {
                    if (bl2 && jSONParserConfiguration.isStrictMode() && jSONTokener.nextClean() != '\u0000') {
                        throw jSONTokener.syntaxError("Strict mode error: Unparsed characters found at end of input text");
                    }
                    return;
                }
            }
            break;
        }
        throw jSONTokener.syntaxError("Expected a ',' or '}'");
    }

    public JSONObject(Map<?, ?> map) {
        this(map, 0, new JSONParserConfiguration());
    }

    public JSONObject(Map<?, ?> map, JSONParserConfiguration jSONParserConfiguration) {
        this(map, 0, jSONParserConfiguration);
    }

    private JSONObject(Map<?, ?> object, int n2, JSONParserConfiguration jSONParserConfiguration) {
        if (n2 > jSONParserConfiguration.getMaxNestingDepth()) {
            throw new JSONException("JSONObject has reached recursion depth limit of " + jSONParserConfiguration.getMaxNestingDepth());
        }
        if (object == null) {
            this.map = new HashMap<String, Object>();
            return;
        }
        this.map = new HashMap<String, Object>(object.size());
        for (Map.Entry entry : object.entrySet()) {
            if (entry.getKey() == null) {
                throw new NullPointerException("Null key.");
            }
            Object v2 = entry.getValue();
            if (v2 == null && !jSONParserConfiguration.isUseNativeNulls()) continue;
            JSONObject.testValidity(v2);
            this.map.put(String.valueOf(entry.getKey()), JSONObject.wrap(v2, n2 + 1, jSONParserConfiguration));
        }
    }

    public JSONObject(Object object) {
        this();
        this.populateMap(object);
    }

    private JSONObject(Object object, Set<Object> set) {
        this();
        this.populateMap(object, set);
    }

    public JSONObject(Object object, String ... stringArray) {
        this(stringArray.length);
        Class<?> clazz = object.getClass();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            try {
                this.putOpt(string, clazz.getField(string).get(object));
                continue;
            }
            catch (Exception exception) {}
        }
    }

    public JSONObject(String string) throws JSONException {
        this(string, new JSONParserConfiguration());
    }

    public JSONObject(String string, JSONParserConfiguration jSONParserConfiguration) throws JSONException {
        this(new JSONTokener(string, jSONParserConfiguration), jSONParserConfiguration);
    }

    public JSONObject(String object, Locale object2) throws JSONException {
        this();
        object = ResourceBundle.getBundle((String)object, (Locale)object2, Thread.currentThread().getContextClassLoader());
        object2 = ((ResourceBundle)object).getKeys();
        while (object2.hasMoreElements()) {
            Object e2 = object2.nextElement();
            if (e2 == null) continue;
            String[] stringArray = ((String)e2).split("\\.");
            int n2 = stringArray.length - 1;
            JSONObject jSONObject = this;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = stringArray[i2];
                JSONObject jSONObject2 = jSONObject.optJSONObject(string);
                if (jSONObject2 == null) {
                    jSONObject2 = new JSONObject();
                    jSONObject.put(string, jSONObject2);
                }
                jSONObject = jSONObject2;
            }
            jSONObject.put(stringArray[n2], ((ResourceBundle)object).getString((String)e2));
        }
    }

    protected JSONObject(int n2) {
        this.map = new HashMap<String, Object>(n2);
    }

    public JSONObject accumulate(String string, Object object) throws JSONException {
        JSONObject.testValidity(object);
        Object object2 = this.opt(string);
        if (object2 == null) {
            this.put(string, object instanceof JSONArray ? new JSONArray().put(object) : object);
        } else if (object2 instanceof JSONArray) {
            ((JSONArray)object2).put(object);
        } else {
            this.put(string, new JSONArray().put(object2).put(object));
        }
        return this;
    }

    public JSONObject append(String string, Object object) throws JSONException {
        JSONObject.testValidity(object);
        Object object2 = this.opt(string);
        if (object2 == null) {
            this.put(string, new JSONArray().put(object));
        } else if (object2 instanceof JSONArray) {
            this.put(string, ((JSONArray)object2).put(object));
        } else {
            throw JSONObject.wrongValueFormatException(string, "JSONArray", null, null);
        }
        return this;
    }

    public static String doubleToString(double d2) {
        if (Double.isInfinite(d2) || Double.isNaN(d2)) {
            return "null";
        }
        String string = Double.toString(d2);
        if (string.indexOf(46) > 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public Object get(String string) throws JSONException {
        if (string == null) {
            throw new JSONException("Null key.");
        }
        Object object = this.opt(string);
        if (object == null) {
            throw new JSONException("JSONObject[" + JSONObject.quote(string) + "] not found.");
        }
        return object;
    }

    public <E extends Enum<E>> E getEnum(Class<E> clazz, String string) throws JSONException {
        E e2 = this.optEnum(clazz, string);
        if (e2 == null) {
            throw JSONObject.wrongValueFormatException(string, "enum of type " + JSONObject.quote(clazz.getSimpleName()), this.opt(string), null);
        }
        return e2;
    }

    public boolean getBoolean(String string) throws JSONException {
        Object object = this.get(string);
        if (object.equals(Boolean.FALSE) || object instanceof String && ((String)object).equalsIgnoreCase("false")) {
            return false;
        }
        if (object.equals(Boolean.TRUE) || object instanceof String && ((String)object).equalsIgnoreCase("true")) {
            return true;
        }
        throw JSONObject.wrongValueFormatException(string, "Boolean", object, null);
    }

    public BigInteger getBigInteger(String string) throws JSONException {
        Object object = this.get(string);
        BigInteger bigInteger = JSONObject.objectToBigInteger(object, null);
        if (bigInteger != null) {
            return bigInteger;
        }
        throw JSONObject.wrongValueFormatException(string, "BigInteger", object, null);
    }

    public BigDecimal getBigDecimal(String string) throws JSONException {
        Object object = this.get(string);
        BigDecimal bigDecimal = JSONObject.objectToBigDecimal(object, null);
        if (bigDecimal != null) {
            return bigDecimal;
        }
        throw JSONObject.wrongValueFormatException(string, "BigDecimal", object, null);
    }

    public double getDouble(String string) throws JSONException {
        Object object = this.get(string);
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        try {
            return Double.parseDouble(object.toString());
        }
        catch (Exception exception) {
            throw JSONObject.wrongValueFormatException(string, "double", object, exception);
        }
    }

    public float getFloat(String string) throws JSONException {
        Object object = this.get(string);
        if (object instanceof Number) {
            return ((Number)object).floatValue();
        }
        try {
            return Float.parseFloat(object.toString());
        }
        catch (Exception exception) {
            throw JSONObject.wrongValueFormatException(string, "float", object, exception);
        }
    }

    public Number getNumber(String string) throws JSONException {
        Object object = this.get(string);
        try {
            if (object instanceof Number) {
                return (Number)object;
            }
            return JSONObject.stringToNumber(object.toString());
        }
        catch (Exception exception) {
            throw JSONObject.wrongValueFormatException(string, "number", object, exception);
        }
    }

    public int getInt(String string) throws JSONException {
        Object object = this.get(string);
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        try {
            return Integer.parseInt(object.toString());
        }
        catch (Exception exception) {
            throw JSONObject.wrongValueFormatException(string, "int", object, exception);
        }
    }

    public JSONArray getJSONArray(String string) throws JSONException {
        Object object = this.get(string);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        throw JSONObject.wrongValueFormatException(string, "JSONArray", object, null);
    }

    public JSONObject getJSONObject(String string) throws JSONException {
        Object object = this.get(string);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        throw JSONObject.wrongValueFormatException(string, "JSONObject", object, null);
    }

    public long getLong(String string) throws JSONException {
        Object object = this.get(string);
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        try {
            return Long.parseLong(object.toString());
        }
        catch (Exception exception) {
            throw JSONObject.wrongValueFormatException(string, "long", object, exception);
        }
    }

    public static String[] getNames(JSONObject jSONObject) {
        if (jSONObject.isEmpty()) {
            return null;
        }
        return jSONObject.keySet().toArray(new String[jSONObject.length()]);
    }

    public static String[] getNames(Object fieldArray) {
        if (fieldArray == null) {
            return null;
        }
        fieldArray = fieldArray.getClass();
        int n2 = (fieldArray = fieldArray.getFields()).length;
        if (n2 == 0) {
            return null;
        }
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = fieldArray[i2].getName();
        }
        return stringArray;
    }

    public String getString(String string) throws JSONException {
        Object object = this.get(string);
        if (object instanceof String) {
            return (String)object;
        }
        throw JSONObject.wrongValueFormatException(string, "string", object, null);
    }

    public boolean has(String string) {
        return this.map.containsKey(string);
    }

    public JSONObject increment(String string) throws JSONException {
        Object object = this.opt(string);
        if (object == null) {
            this.put(string, 1);
        } else if (object instanceof Integer) {
            this.put(string, (Integer)object + 1);
        } else if (object instanceof Long) {
            this.put(string, (Long)object + 1L);
        } else if (object instanceof BigInteger) {
            this.put(string, ((BigInteger)object).add(BigInteger.ONE));
        } else if (object instanceof Float) {
            this.put(string, ((Float)object).floatValue() + 1.0f);
        } else if (object instanceof Double) {
            this.put(string, (Double)object + 1.0);
        } else if (object instanceof BigDecimal) {
            this.put(string, ((BigDecimal)object).add(BigDecimal.ONE));
        } else {
            throw new JSONException("Unable to increment [" + JSONObject.quote(string) + "].");
        }
        return this;
    }

    public boolean isNull(String string) {
        return NULL.equals(this.opt(string));
    }

    public Iterator<String> keys() {
        return this.keySet().iterator();
    }

    public Set<String> keySet() {
        return this.map.keySet();
    }

    protected Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    public int length() {
        return this.map.size();
    }

    public void clear() {
        this.map.clear();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public JSONArray names() {
        if (this.map.isEmpty()) {
            return null;
        }
        return new JSONArray((Collection<?>)this.map.keySet());
    }

    public static String numberToString(Number object) throws JSONException {
        if (object == null) {
            throw new JSONException("Null pointer");
        }
        JSONObject.testValidity(object);
        object = object.toString();
        if (((String)object).indexOf(46) > 0 && ((String)object).indexOf(101) < 0 && ((String)object).indexOf(69) < 0) {
            while (((String)object).endsWith("0")) {
                object = ((String)object).substring(0, ((String)object).length() - 1);
            }
            if (((String)object).endsWith(".")) {
                object = ((String)object).substring(0, ((String)object).length() - 1);
            }
        }
        return object;
    }

    public Object opt(String string) {
        if (string == null) {
            return null;
        }
        return this.map.get(string);
    }

    public <E extends Enum<E>> E optEnum(Class<E> clazz, String string) {
        return this.optEnum(clazz, string, null);
    }

    public <E extends Enum<E>> E optEnum(Class<E> object, String object2, E e2) {
        try {
            object2 = this.opt((String)object2);
            if (NULL.equals(object2)) {
                return e2;
            }
            if (((Class)object).isAssignableFrom(object2.getClass())) {
                object = (Enum)object2;
                return (E)object;
            }
            return Enum.valueOf(object, object2.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return e2;
        }
        catch (NullPointerException nullPointerException) {
            return e2;
        }
    }

    public boolean optBoolean(String string) {
        return this.optBoolean(string, false);
    }

    public boolean optBoolean(String string, boolean bl2) {
        Object object = this.opt(string);
        if (NULL.equals(object)) {
            return bl2;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        try {
            return this.getBoolean(string);
        }
        catch (Exception exception) {
            return bl2;
        }
    }

    public Boolean optBooleanObject(String string) {
        return this.optBooleanObject(string, Boolean.FALSE);
    }

    public Boolean optBooleanObject(String string, Boolean bl2) {
        Object object = this.opt(string);
        if (NULL.equals(object)) {
            return bl2;
        }
        if (object instanceof Boolean) {
            return (boolean)((Boolean)object);
        }
        try {
            return this.getBoolean(string);
        }
        catch (Exception exception) {
            return bl2;
        }
    }

    public BigDecimal optBigDecimal(String object, BigDecimal bigDecimal) {
        object = this.opt((String)object);
        return JSONObject.objectToBigDecimal(object, bigDecimal);
    }

    static BigDecimal objectToBigDecimal(Object object, BigDecimal bigDecimal) {
        return JSONObject.objectToBigDecimal(object, bigDecimal, true);
    }

    static BigDecimal objectToBigDecimal(Object object, BigDecimal bigDecimal, boolean bl2) {
        if (NULL.equals(object)) {
            return bigDecimal;
        }
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        if (object instanceof BigInteger) {
            return new BigDecimal((BigInteger)object);
        }
        if (object instanceof Double || object instanceof Float) {
            if (!JSONObject.numberIsFinite((Number)object)) {
                return bigDecimal;
            }
            if (bl2) {
                return new BigDecimal(((Number)object).doubleValue());
            }
            return new BigDecimal(object.toString());
        }
        if (object instanceof Long || object instanceof Integer || object instanceof Short || object instanceof Byte) {
            return new BigDecimal(((Number)object).longValue());
        }
        try {
            return new BigDecimal(object.toString());
        }
        catch (Exception exception) {
            return bigDecimal;
        }
    }

    public BigInteger optBigInteger(String object, BigInteger bigInteger) {
        object = this.opt((String)object);
        return JSONObject.objectToBigInteger(object, bigInteger);
    }

    static BigInteger objectToBigInteger(Object object, BigInteger bigInteger) {
        if (NULL.equals(object)) {
            return bigInteger;
        }
        if (object instanceof BigInteger) {
            return (BigInteger)object;
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).toBigInteger();
        }
        if (object instanceof Double || object instanceof Float) {
            if (!JSONObject.numberIsFinite((Number)object)) {
                return bigInteger;
            }
            return new BigDecimal(((Number)object).doubleValue()).toBigInteger();
        }
        if (object instanceof Long || object instanceof Integer || object instanceof Short || object instanceof Byte) {
            return BigInteger.valueOf(((Number)object).longValue());
        }
        try {
            object = object.toString();
            if (JSONObject.isDecimalNotation((String)object)) {
                return new BigDecimal((String)object).toBigInteger();
            }
            return new BigInteger((String)object);
        }
        catch (Exception exception) {
            return bigInteger;
        }
    }

    public double optDouble(String string) {
        return this.optDouble(string, Double.NaN);
    }

    public double optDouble(String object, double d2) {
        if ((object = this.optNumber((String)object)) == null) {
            return d2;
        }
        return ((Number)object).doubleValue();
    }

    public Double optDoubleObject(String string) {
        return this.optDoubleObject(string, Double.NaN);
    }

    public Double optDoubleObject(String object, Double d2) {
        if ((object = this.optNumber((String)object)) == null) {
            return d2;
        }
        return ((Number)object).doubleValue();
    }

    public float optFloat(String string) {
        return this.optFloat(string, Float.NaN);
    }

    public float optFloat(String object, float f2) {
        if ((object = this.optNumber((String)object)) == null) {
            return f2;
        }
        float f3 = ((Number)object).floatValue();
        return f3;
    }

    public Float optFloatObject(String string) {
        return this.optFloatObject(string, Float.valueOf(Float.NaN));
    }

    public Float optFloatObject(String object, Float f2) {
        if ((object = this.optNumber((String)object)) == null) {
            return f2;
        }
        object = Float.valueOf(((Number)object).floatValue());
        return object;
    }

    public int optInt(String string) {
        return this.optInt(string, 0);
    }

    public int optInt(String object, int n2) {
        if ((object = this.optNumber((String)object, null)) == null) {
            return n2;
        }
        return ((Number)object).intValue();
    }

    public Integer optIntegerObject(String string) {
        return this.optIntegerObject(string, 0);
    }

    public Integer optIntegerObject(String object, Integer n2) {
        if ((object = this.optNumber((String)object, null)) == null) {
            return n2;
        }
        return ((Number)object).intValue();
    }

    public JSONArray optJSONArray(String string) {
        return this.optJSONArray(string, null);
    }

    public JSONArray optJSONArray(String object, JSONArray jSONArray) {
        if ((object = this.opt((String)object)) instanceof JSONArray) {
            return (JSONArray)object;
        }
        return jSONArray;
    }

    public JSONObject optJSONObject(String string) {
        return this.optJSONObject(string, null);
    }

    public JSONObject optJSONObject(String object, JSONObject jSONObject) {
        if ((object = this.opt((String)object)) instanceof JSONObject) {
            return (JSONObject)object;
        }
        return jSONObject;
    }

    public long optLong(String string) {
        return this.optLong(string, 0L);
    }

    public long optLong(String object, long l2) {
        if ((object = this.optNumber((String)object, null)) == null) {
            return l2;
        }
        return ((Number)object).longValue();
    }

    public Long optLongObject(String string) {
        return this.optLongObject(string, 0L);
    }

    public Long optLongObject(String object, Long l2) {
        if ((object = this.optNumber((String)object, null)) == null) {
            return l2;
        }
        return ((Number)object).longValue();
    }

    public Number optNumber(String string) {
        return this.optNumber(string, null);
    }

    public Number optNumber(String object, Number number) {
        if (NULL.equals(object = this.opt((String)object))) {
            return number;
        }
        if (object instanceof Number) {
            return (Number)object;
        }
        try {
            return JSONObject.stringToNumber(object.toString());
        }
        catch (Exception exception) {
            return number;
        }
    }

    public String optString(String string) {
        return this.optString(string, "");
    }

    public String optString(String object, String string) {
        if (NULL.equals(object = this.opt((String)object))) {
            return string;
        }
        return object.toString();
    }

    private void populateMap(Object object) {
        this.populateMap(object, Collections.newSetFromMap(new IdentityHashMap()));
    }

    private void populateMap(Object object, Set<Object> set) {
        Method[] methodArray = object.getClass();
        int n2 = methodArray.getClassLoader() != null ? 1 : 0;
        Method[] methodArray2 = n2 != 0 ? methodArray.getMethods() : methodArray.getDeclaredMethods();
        methodArray = methodArray2;
        methodArray = methodArray2;
        n2 = methodArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string;
            Object object2 = methodArray[i2];
            int n3 = ((Method)object2).getModifiers();
            if (!Modifier.isPublic(n3) || Modifier.isStatic(n3) || ((Method)object2).getParameterTypes().length != 0 || ((Method)object2).isBridge() || ((Method)object2).getReturnType() == Void.TYPE || !JSONObject.isValidMethodName(((Method)object2).getName()) || (string = JSONObject.getKeyNameFromMethod((Method)object2)) == null || string.isEmpty()) continue;
            try {
                object2 = ((Method)object2).invoke(object, new Object[0]);
                if (object2 == null) continue;
                if (set.contains(object2)) {
                    throw JSONObject.recursivelyDefinedObjectException(string);
                }
                set.add(object2);
                JSONObject.testValidity(object2);
                this.map.put(string, JSONObject.wrap(object2, set));
                set.remove(object2);
                if (!(object2 instanceof Closeable)) continue;
                try {
                    ((Closeable)object2).close();
                }
                catch (IOException iOException) {}
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
    }

    private static boolean isValidMethodName(String string) {
        return !"getClass".equals(string) && !"getDeclaringClass".equals(string);
    }

    private static String getKeyNameFromMethod(Method object) {
        int n2;
        int n3 = JSONObject.getAnnotationDepth((Method)object, JSONPropertyIgnore.class);
        if (n3 > 0 && ((n2 = JSONObject.getAnnotationDepth((Method)object, JSONPropertyName.class)) < 0 || n3 <= n2)) {
            return null;
        }
        JSONPropertyName jSONPropertyName = JSONObject.getAnnotation((Method)object, JSONPropertyName.class);
        if (jSONPropertyName != null && jSONPropertyName.value() != null && !jSONPropertyName.value().isEmpty()) {
            return jSONPropertyName.value();
        }
        if (((String)(object = ((Method)object).getName())).startsWith("get") && ((String)object).length() > 3) {
            object = ((String)object).substring(3);
        } else if (((String)object).startsWith("is") && ((String)object).length() > 2) {
            object = ((String)object).substring(2);
        } else {
            return null;
        }
        if (((String)object).length() == 0 || Character.isLowerCase(((String)object).charAt(0))) {
            return null;
        }
        if (((String)object).length() == 1) {
            object = ((String)object).toLowerCase(Locale.ROOT);
        } else if (!Character.isUpperCase(((String)object).charAt(1))) {
            object = ((String)object).substring(0, 1).toLowerCase(Locale.ROOT) + ((String)object).substring(1);
        }
        return object;
    }

    private static <A extends Annotation> A getAnnotation(Method method, Class<A> clazz) {
        if (method == null || clazz == null) {
            return null;
        }
        if (method.isAnnotationPresent(clazz)) {
            return method.getAnnotation(clazz);
        }
        Class<?> clazz2 = method.getDeclaringClass();
        if (clazz2.getSuperclass() == null) {
            return null;
        }
        for (GenericDeclaration genericDeclaration : clazz2.getInterfaces()) {
            try {
                genericDeclaration = genericDeclaration.getMethod(method.getName(), method.getParameterTypes());
                return JSONObject.getAnnotation((Method)genericDeclaration, clazz);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        if (clazz2.getSuperclass().equals(Object.class)) {
            return null;
        }
        try {
            return JSONObject.getAnnotation(clazz2.getSuperclass().getMethod(method.getName(), method.getParameterTypes()), clazz);
        }
        catch (SecurityException securityException) {
            return null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static int getAnnotationDepth(Method method, Class<? extends Annotation> clazz) {
        if (method == null || clazz == null) {
            return -1;
        }
        if (method.isAnnotationPresent(clazz)) {
            return 1;
        }
        Class<?> clazz2 = method.getDeclaringClass();
        if (clazz2.getSuperclass() == null) {
            return -1;
        }
        for (GenericDeclaration genericDeclaration : clazz2.getInterfaces()) {
            try {
                genericDeclaration = genericDeclaration.getMethod(method.getName(), method.getParameterTypes());
                int n2 = JSONObject.getAnnotationDepth((Method)genericDeclaration, clazz);
                if (n2 <= 0) continue;
                return n2 + 1;
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        if (clazz2.getSuperclass().equals(Object.class)) {
            return -1;
        }
        try {
            int n3 = JSONObject.getAnnotationDepth(clazz2.getSuperclass().getMethod(method.getName(), method.getParameterTypes()), clazz);
            if (n3 > 0) {
                return n3 + 1;
            }
            return -1;
        }
        catch (SecurityException securityException) {
            return -1;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return -1;
        }
    }

    public JSONObject put(String string, boolean bl2) throws JSONException {
        return this.put(string, bl2 ? Boolean.TRUE : Boolean.FALSE);
    }

    public JSONObject put(String string, Collection<?> collection) throws JSONException {
        return this.put(string, new JSONArray(collection));
    }

    public JSONObject put(String string, double d2) throws JSONException {
        return this.put(string, (Object)d2);
    }

    public JSONObject put(String string, float f2) throws JSONException {
        return this.put(string, Float.valueOf(f2));
    }

    public JSONObject put(String string, int n2) throws JSONException {
        return this.put(string, (Object)n2);
    }

    public JSONObject put(String string, long l2) throws JSONException {
        return this.put(string, (Object)l2);
    }

    public JSONObject put(String string, Map<?, ?> map) throws JSONException {
        return this.put(string, new JSONObject(map));
    }

    public JSONObject put(String string, Object object) throws JSONException {
        if (string == null) {
            throw new NullPointerException("Null key.");
        }
        if (object != null) {
            JSONObject.testValidity(object);
            this.map.put(string, object);
        } else {
            this.remove(string);
        }
        return this;
    }

    public JSONObject putOnce(String string, Object object) throws JSONException {
        if (string != null && object != null) {
            if (this.opt(string) != null) {
                throw new JSONException("Duplicate key \"" + string + "\"");
            }
            return this.put(string, object);
        }
        return this;
    }

    public JSONObject putOpt(String string, Object object) throws JSONException {
        if (string != null && object != null) {
            return this.put(string, object);
        }
        return this;
    }

    public Object query(String string) {
        return this.query(new JSONPointer(string));
    }

    public Object query(JSONPointer jSONPointer) {
        return jSONPointer.queryFrom(this);
    }

    public Object optQuery(String string) {
        return this.optQuery(new JSONPointer(string));
    }

    public Object optQuery(JSONPointer jSONPointer) {
        try {
            return jSONPointer.queryFrom(this);
        }
        catch (JSONPointerException jSONPointerException) {
            return null;
        }
    }

    public static String quote(String string) {
        if (string == null || string.isEmpty()) {
            return "\"\"";
        }
        StringBuilderWriter stringBuilderWriter = new StringBuilderWriter(string.length() + 2);
        try {
            return JSONObject.quote(string, stringBuilderWriter).toString();
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public static Writer quote(String string, Writer writer) throws IOException {
        if (string == null || string.isEmpty()) {
            writer.write("\"\"");
            return writer;
        }
        char c2 = '\u0000';
        int n2 = string.length();
        writer.write(34);
        block9: for (int i2 = 0; i2 < n2; ++i2) {
            char c3 = c2;
            c2 = string.charAt(i2);
            switch (c2) {
                case '\"': 
                case '\\': {
                    writer.write(92);
                    break;
                }
                case '/': {
                    if (c3 == '<') {
                        writer.write(92);
                    }
                    writer.write(c2);
                    continue block9;
                }
                case '\b': {
                    writer.write("\\b");
                    continue block9;
                }
                case '\t': {
                    writer.write("\\t");
                    continue block9;
                }
                case '\n': {
                    writer.write("\\n");
                    continue block9;
                }
                case '\f': {
                    writer.write("\\f");
                    continue block9;
                }
                case '\r': {
                    writer.write("\\r");
                    continue block9;
                }
                default: {
                    if (c2 >= ' ' && (c2 < '\u0080' || c2 >= '\u00a0') && (c2 < '\u2000' || c2 >= '\u2100')) break;
                    writer.write("\\u");
                    String string2 = Integer.toHexString(c2);
                    writer.write("0000", 0, 4 - string2.length());
                    writer.write(string2);
                    continue block9;
                }
            }
            writer.write(c2);
        }
        writer.write(34);
        return writer;
    }

    public Object remove(String string) {
        return this.map.remove(string);
    }

    public boolean similar(Object object) {
        if (!(object instanceof JSONObject)) {
            return false;
        }
        try {
            if (!this.keySet().equals(((JSONObject)object).keySet())) {
                return false;
            }
            for (Map.Entry<String, Object> entry : this.entrySet()) {
                Object object2 = entry.getKey();
                Object object22 = entry.getValue();
                if (object22 == (object2 = ((JSONObject)object).get((String)object2))) continue;
                if (object22 == null) {
                    return false;
                }
                if (!(object22 instanceof JSONObject ? !((JSONObject)object22).similar(object2) : (object22 instanceof JSONArray ? !((JSONArray)object22).similar(object2) : (object22 instanceof Number && object2 instanceof Number ? !JSONObject.isNumberSimilar((Number)object22, (Number)object2) : (object22 instanceof JSONString && object2 instanceof JSONString ? !((JSONString)object22).toJSONString().equals(((JSONString)object2).toJSONString()) : !object22.equals(object2)))))) continue;
                return false;
            }
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    static boolean isNumberSimilar(Number number, Number number2) {
        if (!JSONObject.numberIsFinite(number) || !JSONObject.numberIsFinite(number2)) {
            return false;
        }
        if (number.getClass().equals(number2.getClass()) && number instanceof Comparable) {
            int n2 = ((Comparable)((Object)number)).compareTo(number2);
            return n2 == 0;
        }
        number = JSONObject.objectToBigDecimal(number, null, false);
        number2 = JSONObject.objectToBigDecimal(number2, null, false);
        if (number == null || number2 == null) {
            return false;
        }
        return ((BigDecimal)number).compareTo((BigDecimal)number2) == 0;
    }

    private static boolean numberIsFinite(Number number) {
        if (number instanceof Double && (((Double)number).isInfinite() || ((Double)number).isNaN())) {
            return false;
        }
        return !(number instanceof Float) || !((Float)number).isInfinite() && !((Float)number).isNaN();
    }

    protected static boolean isDecimalNotation(String string) {
        return string.indexOf(46) >= 0 || string.indexOf(101) >= 0 || string.indexOf(69) >= 0 || "-0".equals(string);
    }

    public static Object stringToValue(String string) {
        if ("".equals(string)) {
            return string;
        }
        if ("true".equalsIgnoreCase(string)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(string)) {
            return Boolean.FALSE;
        }
        if ("null".equalsIgnoreCase(string)) {
            return NULL;
        }
        char c2 = string.charAt(0);
        if (c2 >= '0' && c2 <= '9' || c2 == '-') {
            try {
                return JSONObject.stringToNumber(string);
            }
            catch (Exception exception) {}
        }
        return string;
    }

    protected static Number stringToNumber(String string) throws NumberFormatException {
        char c2 = string.charAt(0);
        if (c2 >= '0' && c2 <= '9' || c2 == '-') {
            BigInteger bigInteger;
            char c3;
            if (JSONObject.isDecimalNotation(string)) {
                try {
                    BigDecimal bigDecimal = new BigDecimal(string);
                    if (c2 == '-' && BigDecimal.ZERO.compareTo(bigDecimal) == 0) {
                        return -0.0;
                    }
                    return bigDecimal;
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        Double d2 = Double.valueOf(string);
                        if (d2.isNaN() || d2.isInfinite()) {
                            throw new NumberFormatException("val [" + string + "] is not a valid number.");
                        }
                        return d2;
                    }
                    catch (NumberFormatException numberFormatException2) {
                        throw new NumberFormatException("val [" + string + "] is not a valid number.");
                    }
                }
            }
            if (c2 == '0' && string.length() > 1) {
                c3 = string.charAt(1);
                if (c3 >= '0' && c3 <= '9') {
                    throw new NumberFormatException("val [" + string + "] is not a valid number.");
                }
            } else if (c2 == '-' && string.length() > 2) {
                c3 = string.charAt(1);
                c2 = string.charAt(2);
                if (c3 == '0' && c2 >= '0' && c2 <= '9') {
                    throw new NumberFormatException("val [" + string + "] is not a valid number.");
                }
            }
            if ((bigInteger = new BigInteger(string)).bitLength() <= 31) {
                return bigInteger.intValue();
            }
            if (bigInteger.bitLength() <= 63) {
                return bigInteger.longValue();
            }
            return bigInteger;
        }
        throw new NumberFormatException("val [" + string + "] is not a valid number.");
    }

    public static void testValidity(Object object) throws JSONException {
        if (object instanceof Number && !JSONObject.numberIsFinite((Number)object)) {
            throw new JSONException("JSON does not allow non-finite numbers.");
        }
    }

    public JSONArray toJSONArray(JSONArray jSONArray) throws JSONException {
        if (jSONArray == null || jSONArray.isEmpty()) {
            return null;
        }
        JSONArray jSONArray2 = new JSONArray();
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            jSONArray2.put(this.opt(jSONArray.getString(i2)));
        }
        return jSONArray2;
    }

    public String toString() {
        try {
            return this.toString(0);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String toString(int n2) throws JSONException {
        int n3 = this.map.size() * 6;
        StringBuilderWriter stringBuilderWriter = new StringBuilderWriter(Math.max(n3, 16));
        return this.write(stringBuilderWriter, n2, 0).toString();
    }

    public static String valueToString(Object object) throws JSONException {
        return JSONWriter.valueToString(object);
    }

    public static Object wrap(Object object) {
        return JSONObject.wrap(object, null);
    }

    static Object wrap(Object object, int n2, JSONParserConfiguration jSONParserConfiguration) {
        return JSONObject.wrap(object, null, n2, jSONParserConfiguration);
    }

    private static Object wrap(Object object, Set<Object> set) {
        return JSONObject.wrap(object, set, 0, new JSONParserConfiguration());
    }

    private static Object wrap(Object object, Set<Object> set, int n2, JSONParserConfiguration jSONParserConfiguration) {
        try {
            if (NULL.equals(object)) {
                return NULL;
            }
            if (object instanceof JSONObject || object instanceof JSONArray || NULL.equals(object) || object instanceof JSONString || object instanceof Byte || object instanceof Character || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Boolean || object instanceof Float || object instanceof Double || object instanceof String || object instanceof BigInteger || object instanceof BigDecimal || object instanceof Enum) {
                return object;
            }
            if (object instanceof Collection) {
                Collection collection = (Collection)object;
                return new JSONArray(collection, n2, jSONParserConfiguration);
            }
            if (object.getClass().isArray()) {
                return new JSONArray(object);
            }
            if (object instanceof Map) {
                Map map = (Map)object;
                return new JSONObject(map, n2, jSONParserConfiguration);
            }
            Package package_ = object.getClass().getPackage();
            String string = package_ != null ? package_.getName() : "";
            if (string.startsWith("java.") || string.startsWith("javax.") || object.getClass().getClassLoader() == null) {
                return object.toString();
            }
            if (set != null) {
                return new JSONObject(object, set);
            }
            return new JSONObject(object);
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            throw jSONException;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Writer write(Writer writer) throws JSONException {
        return this.write(writer, 0, 0);
    }

    static final Writer writeValue(Writer writer, Object object, int n2, int n3) throws JSONException, IOException {
        if (object == null || object.equals(null)) {
            writer.write("null");
        } else if (object instanceof JSONString) {
            String string;
            try {
                string = ((JSONString)object).toJSONString();
            }
            catch (Exception exception) {
                throw new JSONException(exception);
            }
            writer.write(string != null ? string.toString() : JSONObject.quote(object.toString()));
        } else {
            if (object instanceof String) {
                JSONObject.quote(object.toString(), writer);
                return writer;
            }
            if (object instanceof Number) {
                String string = JSONObject.numberToString((Number)object);
                if (NUMBER_PATTERN.matcher(string).matches()) {
                    writer.write(string);
                } else {
                    JSONObject.quote(string, writer);
                }
            } else if (object instanceof Boolean) {
                writer.write(object.toString());
            } else if (object instanceof Enum) {
                writer.write(JSONObject.quote(((Enum)object).name()));
            } else if (object instanceof JSONObject) {
                ((JSONObject)object).write(writer, n2, n3);
            } else if (object instanceof JSONArray) {
                ((JSONArray)object).write(writer, n2, n3);
            } else if (object instanceof Map) {
                Map map = (Map)object;
                new JSONObject(map).write(writer, n2, n3);
            } else if (object instanceof Collection) {
                Collection collection = (Collection)object;
                new JSONArray(collection).write(writer, n2, n3);
            } else if (object.getClass().isArray()) {
                new JSONArray(object).write(writer, n2, n3);
            } else {
                JSONObject.quote(object.toString(), writer);
            }
        }
        return writer;
    }

    static final void indent(Writer writer, int n2) throws IOException {
        for (int i2 = 0; i2 < n2; ++i2) {
            writer.write(32);
        }
    }

    public Writer write(Writer writer, int n2, int n3) throws JSONException {
        try {
            boolean bl2 = false;
            int n4 = this.length();
            writer.write(123);
            if (n4 == 1) {
                Map.Entry<String, Object> entry = this.entrySet().iterator().next();
                String string = entry.getKey();
                writer.write(JSONObject.quote(string));
                writer.write(58);
                if (n2 > 0) {
                    writer.write(32);
                }
                try {
                    JSONObject.writeValue(writer, entry.getValue(), n2, n3);
                }
                catch (Exception exception) {
                    throw new JSONException("Unable to write JSONObject value for key: " + string, exception);
                }
            }
            if (n4 != 0) {
                n4 = n3 + n2;
                for (Map.Entry<String, Object> entry : this.entrySet()) {
                    if (bl2) {
                        writer.write(44);
                    }
                    if (n2 > 0) {
                        writer.write(10);
                    }
                    JSONObject.indent(writer, n4);
                    String string = entry.getKey();
                    writer.write(JSONObject.quote(string));
                    writer.write(58);
                    if (n2 > 0) {
                        writer.write(32);
                    }
                    try {
                        JSONObject.writeValue(writer, entry.getValue(), n2, n4);
                    }
                    catch (Exception exception) {
                        throw new JSONException("Unable to write JSONObject value for key: " + string, exception);
                    }
                    bl2 = true;
                }
                if (n2 > 0) {
                    writer.write(10);
                }
                JSONObject.indent(writer, n3);
            }
            writer.write(125);
            return writer;
        }
        catch (IOException iOException) {
            throw new JSONException(iOException);
        }
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.entrySet()) {
            Object object = entry.getValue() == null || NULL.equals(entry.getValue()) ? null : (entry.getValue() instanceof JSONObject ? ((JSONObject)entry.getValue()).toMap() : (entry.getValue() instanceof JSONArray ? ((JSONArray)entry.getValue()).toList() : entry.getValue()));
            hashMap.put(entry.getKey(), object);
        }
        return hashMap;
    }

    private static JSONException wrongValueFormatException(String string, String string2, Object object, Throwable throwable) {
        if (object == null) {
            return new JSONException("JSONObject[" + JSONObject.quote(string) + "] is not a " + string2 + " (null).", throwable);
        }
        if (object instanceof Map || object instanceof Iterable || object instanceof JSONObject) {
            return new JSONException("JSONObject[" + JSONObject.quote(string) + "] is not a " + string2 + " (" + object.getClass() + ").", throwable);
        }
        return new JSONException("JSONObject[" + JSONObject.quote(string) + "] is not a " + string2 + " (" + object.getClass() + " : " + object + ").", throwable);
    }

    private static JSONException recursivelyDefinedObjectException(String string) {
        return new JSONException("JavaBean object contains recursively defined member variable of key " + JSONObject.quote(string));
    }

    private static String removeLeadingZerosOfNumber(String string) {
        int n2;
        if (string.equals("-")) {
            return string;
        }
        boolean bl2 = string.charAt(0) == '-';
        int n3 = n2 = bl2 ? 1 : 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) != '0') {
                if (bl2) {
                    return "-".concat(string.substring(n2));
                }
                return string.substring(n2);
            }
            ++n2;
        }
        if (bl2) {
            return "-0";
        }
        return "0";
    }
}

