/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.bridge;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LocationAwareLogger;

public class SLF4JBridgeHandler
extends Handler {
    private static final String FQCN = java.util.logging.Logger.class.getName();
    private static final String UNKNOWN_LOGGER_NAME = "unknown.jul.logger";
    private static final int TRACE_LEVEL_THRESHOLD = Level.FINEST.intValue();
    private static final int DEBUG_LEVEL_THRESHOLD = Level.FINE.intValue();
    private static final int INFO_LEVEL_THRESHOLD = Level.INFO.intValue();
    private static final int WARN_LEVEL_THRESHOLD = Level.WARNING.intValue();

    public static void install() {
        LogManager.getLogManager().getLogger("").addHandler(new SLF4JBridgeHandler());
    }

    private static java.util.logging.Logger getRootLogger() {
        return LogManager.getLogManager().getLogger("");
    }

    public static void uninstall() throws SecurityException {
        java.util.logging.Logger logger = SLF4JBridgeHandler.getRootLogger();
        Handler[] handlerArray = logger.getHandlers();
        Handler[] handlerArray2 = handlerArray;
        handlerArray2 = handlerArray;
        int n2 = handlerArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Handler handler = handlerArray2[i2];
            if (!(handler instanceof SLF4JBridgeHandler)) continue;
            logger.removeHandler(handler);
        }
    }

    public static boolean isInstalled() {
        Handler[] handlerArray = SLF4JBridgeHandler.getRootLogger();
        Handler[] handlerArray2 = handlerArray.getHandlers();
        handlerArray = handlerArray2;
        handlerArray = handlerArray2;
        int n2 = handlerArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Handler handler = handlerArray[i2];
            if (!(handler instanceof SLF4JBridgeHandler)) continue;
            return true;
        }
        return false;
    }

    public static void removeHandlersForRootLogger() {
        java.util.logging.Logger logger = SLF4JBridgeHandler.getRootLogger();
        Handler[] handlerArray = logger.getHandlers();
        Handler[] handlerArray2 = handlerArray;
        handlerArray2 = handlerArray;
        int n2 = handlerArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Handler handler = handlerArray2[i2];
            logger.removeHandler(handler);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    protected Logger getSLF4JLogger(LogRecord object) {
        if ((object = ((LogRecord)object).getLoggerName()) == null) {
            object = UNKNOWN_LOGGER_NAME;
        }
        return LoggerFactory.getLogger((String)object);
    }

    protected void callLocationAwareLogger(LocationAwareLogger locationAwareLogger, LogRecord logRecord) {
        int n2 = logRecord.getLevel().intValue();
        n2 = n2 <= TRACE_LEVEL_THRESHOLD ? 0 : (n2 <= DEBUG_LEVEL_THRESHOLD ? 10 : (n2 <= INFO_LEVEL_THRESHOLD ? 20 : (n2 <= WARN_LEVEL_THRESHOLD ? 30 : 40)));
        String string = this.getMessageI18N(logRecord);
        locationAwareLogger.log(null, FQCN, n2, string, null, logRecord.getThrown());
    }

    protected void callPlainSLF4JLogger(Logger logger, LogRecord logRecord) {
        String string = this.getMessageI18N(logRecord);
        int n2 = logRecord.getLevel().intValue();
        if (n2 <= TRACE_LEVEL_THRESHOLD) {
            logger.trace(string, logRecord.getThrown());
            return;
        }
        if (n2 <= DEBUG_LEVEL_THRESHOLD) {
            logger.debug(string, logRecord.getThrown());
            return;
        }
        if (n2 <= INFO_LEVEL_THRESHOLD) {
            logger.info(string, logRecord.getThrown());
            return;
        }
        if (n2 <= WARN_LEVEL_THRESHOLD) {
            logger.warn(string, logRecord.getThrown());
            return;
        }
        logger.error(string, logRecord.getThrown());
    }

    private String getMessageI18N(LogRecord objectArray) {
        String string = objectArray.getMessage();
        if (string == null) {
            return null;
        }
        ResourceBundle resourceBundle = objectArray.getResourceBundle();
        if (resourceBundle != null) {
            try {
                string = resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        if ((objectArray = objectArray.getParameters()) != null && objectArray.length > 0) {
            try {
                string = MessageFormat.format(string, objectArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return string;
            }
        }
        return string;
    }

    @Override
    public void publish(LogRecord logRecord) {
        if (logRecord == null) {
            return;
        }
        Logger logger = this.getSLF4JLogger(logRecord);
        if (logRecord.getMessage() == null) {
            logRecord.setMessage("");
        }
        if (logger instanceof LocationAwareLogger) {
            this.callLocationAwareLogger((LocationAwareLogger)logger, logRecord);
            return;
        }
        this.callPlainSLF4JLogger(logger, logRecord);
    }
}

