/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.spi;

import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.event.DefaultLoggingEvent;
import org.slf4j.event.KeyValuePair;
import org.slf4j.event.Level;
import org.slf4j.event.LoggingEvent;
import org.slf4j.spi.CallerBoundaryAware;
import org.slf4j.spi.LocationAwareLogger;
import org.slf4j.spi.LoggingEventAware;
import org.slf4j.spi.LoggingEventBuilder;

public class DefaultLoggingEventBuilder
implements CallerBoundaryAware,
LoggingEventBuilder {
    static String DLEB_FQCN = DefaultLoggingEventBuilder.class.getName();
    protected DefaultLoggingEvent loggingEvent;
    protected Logger logger;

    public DefaultLoggingEventBuilder(Logger logger, Level level) {
        this.logger = logger;
        this.loggingEvent = new DefaultLoggingEvent(level, logger);
    }

    @Override
    public LoggingEventBuilder addMarker(Marker marker) {
        this.loggingEvent.addMarker(marker);
        return this;
    }

    @Override
    public LoggingEventBuilder setCause(Throwable throwable) {
        this.loggingEvent.setThrowable(throwable);
        return this;
    }

    @Override
    public LoggingEventBuilder addArgument(Object object) {
        this.loggingEvent.addArgument(object);
        return this;
    }

    @Override
    public LoggingEventBuilder addArgument(Supplier<?> supplier) {
        this.loggingEvent.addArgument(supplier.get());
        return this;
    }

    @Override
    public LoggingEventBuilder addKeyValue(String string, Object object) {
        this.loggingEvent.addKeyValue(string, object);
        return this;
    }

    @Override
    public LoggingEventBuilder addKeyValue(String string, Supplier<Object> supplier) {
        this.loggingEvent.addKeyValue(string, supplier.get());
        return this;
    }

    @Override
    public void setCallerBoundary(String string) {
        this.loggingEvent.setCallerBoundary(string);
    }

    @Override
    public void log() {
        DefaultLoggingEventBuilder defaultLoggingEventBuilder = this;
        defaultLoggingEventBuilder.log(defaultLoggingEventBuilder.loggingEvent);
    }

    @Override
    public LoggingEventBuilder setMessage(String string) {
        this.loggingEvent.setMessage(string);
        return this;
    }

    @Override
    public LoggingEventBuilder setMessage(Supplier<String> supplier) {
        this.loggingEvent.setMessage(supplier.get());
        return this;
    }

    @Override
    public void log(String string) {
        this.loggingEvent.setMessage(string);
        DefaultLoggingEventBuilder defaultLoggingEventBuilder = this;
        defaultLoggingEventBuilder.log(defaultLoggingEventBuilder.loggingEvent);
    }

    @Override
    public void log(String string, Object object) {
        this.loggingEvent.setMessage(string);
        this.loggingEvent.addArgument(object);
        DefaultLoggingEventBuilder defaultLoggingEventBuilder = this;
        defaultLoggingEventBuilder.log(defaultLoggingEventBuilder.loggingEvent);
    }

    @Override
    public void log(String string, Object object, Object object2) {
        this.loggingEvent.setMessage(string);
        this.loggingEvent.addArgument(object);
        this.loggingEvent.addArgument(object2);
        DefaultLoggingEventBuilder defaultLoggingEventBuilder = this;
        defaultLoggingEventBuilder.log(defaultLoggingEventBuilder.loggingEvent);
    }

    @Override
    public void log(String string, Object ... objectArray) {
        this.loggingEvent.setMessage(string);
        this.loggingEvent.addArguments(objectArray);
        DefaultLoggingEventBuilder defaultLoggingEventBuilder = this;
        defaultLoggingEventBuilder.log(defaultLoggingEventBuilder.loggingEvent);
    }

    @Override
    public void log(Supplier<String> supplier) {
        if (supplier == null) {
            this.log((String)null);
            return;
        }
        this.log(supplier.get());
    }

    protected void log(LoggingEvent loggingEvent) {
        if (loggingEvent.getCallerBoundary() == null) {
            this.setCallerBoundary(DLEB_FQCN);
        }
        if (this.logger instanceof LoggingEventAware) {
            ((LoggingEventAware)((Object)this.logger)).log(loggingEvent);
            return;
        }
        if (this.logger instanceof LocationAwareLogger) {
            DefaultLoggingEventBuilder defaultLoggingEventBuilder = this;
            defaultLoggingEventBuilder.logViaLocationAwareLoggerAPI((LocationAwareLogger)defaultLoggingEventBuilder.logger, loggingEvent);
            return;
        }
        this.logViaPublicSLF4JLoggerAPI(loggingEvent);
    }

    private void logViaLocationAwareLoggerAPI(LocationAwareLogger locationAwareLogger, LoggingEvent loggingEvent) {
        loggingEvent.getMessage();
        loggingEvent.getMarkers();
        String string = this.mergeMarkersAndKeyValuePairsAndMessage(loggingEvent);
        locationAwareLogger.log(null, loggingEvent.getCallerBoundary(), loggingEvent.getLevel().toInt(), string, loggingEvent.getArgumentArray(), loggingEvent.getThrowable());
    }

    private void logViaPublicSLF4JLoggerAPI(LoggingEvent loggingEvent) {
        Object object = loggingEvent.getArgumentArray();
        int n2 = object == null ? 0 : ((Object[])object).length;
        Throwable throwable = loggingEvent.getThrowable();
        int n3 = throwable == null ? 0 : 1;
        Object[] objectArray = new Object[n2 + n3];
        if (object != null) {
            System.arraycopy(object, 0, objectArray, 0, n2);
        }
        if (throwable != null) {
            objectArray[n2] = throwable;
        }
        object = this.mergeMarkersAndKeyValuePairsAndMessage(loggingEvent);
        switch (loggingEvent.getLevel()) {
            case TRACE: {
                this.logger.trace((String)object, objectArray);
                return;
            }
            case DEBUG: {
                this.logger.debug((String)object, objectArray);
                return;
            }
            case INFO: {
                this.logger.info((String)object, objectArray);
                return;
            }
            case WARN: {
                this.logger.warn((String)object, objectArray);
                return;
            }
            case ERROR: {
                this.logger.error((String)object, objectArray);
            }
        }
    }

    private String mergeMarkersAndKeyValuePairsAndMessage(LoggingEvent object) {
        StringBuilder stringBuilder = this.mergeMarkers(object.getMarkers(), null);
        stringBuilder = this.mergeKeyValuePairs(object.getKeyValuePairs(), stringBuilder);
        object = this.mergeMessage(object.getMessage(), stringBuilder);
        return object;
    }

    private StringBuilder mergeMarkers(List<Marker> object, StringBuilder stringBuilder) {
        if (object == null || object.isEmpty()) {
            return stringBuilder;
        }
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder();
        }
        object = object.iterator();
        while (object.hasNext()) {
            Marker marker = (Marker)object.next();
            stringBuilder.append(marker);
            stringBuilder.append(' ');
        }
        return stringBuilder;
    }

    private StringBuilder mergeKeyValuePairs(List<KeyValuePair> object, StringBuilder stringBuilder) {
        if (object == null || object.isEmpty()) {
            return stringBuilder;
        }
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder();
        }
        object = object.iterator();
        while (object.hasNext()) {
            KeyValuePair keyValuePair = (KeyValuePair)object.next();
            stringBuilder.append(keyValuePair.key);
            stringBuilder.append('=');
            stringBuilder.append(keyValuePair.value);
            stringBuilder.append(' ');
        }
        return stringBuilder;
    }

    private String mergeMessage(String string, StringBuilder stringBuilder) {
        if (stringBuilder != null) {
            stringBuilder.append(string);
            return stringBuilder.toString();
        }
        return string;
    }
}

