/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal;

import java.awt.Component;
import java.io.File;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

public final class FileChooser {
    private final JFileChooser fileChooser = new JFileChooser();
    private boolean acceptAll = false;

    public FileChooser(String filterDescription, List<String> extensions) {
        this.setupExtensionFilters(filterDescription, extensions);
    }

    public void setMultiSelectionEnabled(boolean enabled) {
        this.fileChooser.setMultiSelectionEnabled(enabled);
    }

    public void setSelectedFile(String selectedFile) {
        this.fileChooser.setSelectedFile(new File(selectedFile));
    }

    public void setCurrentDirectory(String currentDirectory) {
        if (!currentDirectory.isEmpty()) {
            this.fileChooser.setCurrentDirectory(new File(currentDirectory));
        }
    }

    public void setAcceptAll(boolean enabled) {
        this.acceptAll = enabled;
    }

    public int showOpenDialog(Component parent) {
        if (this.acceptAll) {
            this.addAcceptAllFilter();
        }
        return this.fileChooser.showOpenDialog(parent);
    }

    public File selectedFile() {
        return this.fileChooser.getSelectedFile();
    }

    public File[] selectedFiles() {
        return this.fileChooser.getSelectedFiles();
    }

    public int showSaveDialog(Component parent) {
        if (this.acceptAll) {
            this.addAcceptAllFilter();
        }
        return this.fileChooser.showSaveDialog(parent);
    }

    private void setupExtensionFilters(String filterDescription, List<String> extensions) {
        if (extensions.isEmpty()) {
            return;
        }
        FileNameExtensionFilter filter = new FileNameExtensionFilter(filterDescription, extensions.toArray(new String[0]));
        this.fileChooser.addChoosableFileFilter(filter);
        this.fileChooser.setFileFilter(filter);
        this.fileChooser.setAcceptAllFileFilterUsed(false);
    }

    private void addAcceptAllFilter() {
        FileFilter acceptAllFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return true;
            }

            @Override
            public String getDescription() {
                return "All Files";
            }
        };
        this.fileChooser.addChoosableFileFilter(acceptAllFilter);
    }
}

