/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal;

import com.teamdev.jxbrowser.browser.internal.rpc.FocusRequest;
import com.teamdev.jxbrowser.deps.com.google.common.base.Converter;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.Size;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class ToolkitConverters {
    public static java.awt.Point toPoint(Point point) {
        return (java.awt.Point)new PointConverter().convert(point);
    }

    public static Point toProtoPoint(java.awt.Point point) {
        return (Point)new PointConverter().reverse().convert((Object)point);
    }

    public static Color toColor(com.teamdev.jxbrowser.ui.Color color) {
        return (Color)new ColorConverter().convert(color);
    }

    public static com.teamdev.jxbrowser.ui.Color toProtoColor(Color color) {
        return (com.teamdev.jxbrowser.ui.Color)new ColorConverter().reverse().convert((Object)color);
    }

    public static Dimension toDimension(Size size) {
        return (Dimension)new DimensionConverter().convert(size);
    }

    public static FocusRequest.Cause toProtoCause(FocusEvent.Cause cause) {
        if (cause == FocusEvent.Cause.TRAVERSAL_FORWARD) {
            return FocusRequest.Cause.TRAVERSAL_FORWARD;
        }
        if (cause == FocusEvent.Cause.TRAVERSAL_BACKWARD) {
            return FocusRequest.Cause.TRAVERSAL_BACKWARD;
        }
        return FocusRequest.Cause.FOCUS_CASE_UNSPECIFIED;
    }

    private ToolkitConverters() {
    }

    private static final class PointConverter
    extends Converter<Point, java.awt.Point> {
        private PointConverter() {
        }

        protected java.awt.Point doForward(Point point) {
            return new java.awt.Point(point.x(), point.y());
        }

        protected Point doBackward(java.awt.Point point) {
            return Point.of((int)point.x, (int)point.y);
        }
    }

    private static final class ColorConverter
    extends Converter<com.teamdev.jxbrowser.ui.Color, Color> {
        private ColorConverter() {
        }

        protected Color doForward(com.teamdev.jxbrowser.ui.Color color) {
            return new Color(color.red(), color.green(), color.blue(), color.alpha());
        }

        protected com.teamdev.jxbrowser.ui.Color doBackward(Color color) {
            return com.teamdev.jxbrowser.ui.Color.newBuilder().red((float)color.getRed() / 255.0f).green((float)color.getGreen() / 255.0f).blue((float)color.getBlue() / 255.0f).build();
        }
    }

    private static final class DimensionConverter
    extends Converter<Size, Dimension> {
        private DimensionConverter() {
        }

        protected Dimension doForward(Size size) {
            return new Dimension(size.width(), size.height());
        }

        protected Size doBackward(Dimension dimension) {
            return Size.of((int)dimension.width, (int)dimension.height);
        }
    }
}

