/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal.dnd;

import com.teamdev.jxbrowser.deps.com.google.common.io.CharStreams;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.view.swing.internal.dnd.CustomDataSupport;
import com.teamdev.jxbrowser.view.swing.internal.dnd.MimeType;
import com.teamdev.jxbrowser.view.swing.internal.dnd.RichDataFlavor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

final class StringDataFlavor
extends RichDataFlavor<String> {
    private final Charset charset;

    private StringDataFlavor(MimeType mimeType, Charset charset) {
        super(mimeType);
        this.charset = charset;
    }

    static StringDataFlavor newInstance(String mimeType) {
        return new StringDataFlavor(MimeType.newInstance(mimeType), StandardCharsets.UTF_8);
    }

    static StringDataFlavor newInstance(String mimeType, Charset charset) {
        return new StringDataFlavor(MimeType.newInstance(mimeType), charset);
    }

    @Override
    boolean isPresentedIn(Transferable transferable) {
        return Arrays.stream(transferable.getTransferDataFlavors()).filter(this.mimeType::matches).anyMatch(it -> !CustomDataSupport.isCustomDataFlavor(it));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    String read(Transferable transferable) {
        try {
            Optional<DataFlavor> stringFlavor = this.as(String.class, transferable);
            if (stringFlavor.isPresent()) {
                return (String)transferable.getTransferData(stringFlavor.get());
            }
            Optional<DataFlavor> asByteArray = this.as(byte[].class, transferable);
            if (asByteArray.isPresent()) {
                byte[] bytes = (byte[])transferable.getTransferData(asByteArray.get());
                return new String(bytes, this.charset);
            }
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            int n = dataFlavorArray.length;
            int n2 = 0;
            while (n2 < n) {
                DataFlavor flavor = dataFlavorArray[n2];
                try (Reader reader = flavor.getReaderForText(transferable);){
                    String string = CharStreams.toString((Readable)reader);
                    return string;
                }
                catch (IOException e) {
                    Logger.debug((String)"Failed to read drop data using: {0}", (Object[])new Object[]{flavor});
                    ++n2;
                }
            }
            throw this.noSuitableFlavor();
        }
        catch (UnsupportedFlavorException | IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private Optional<DataFlavor> as(Class<?> representationClass, Transferable transferable) {
        DataFlavor[] allFlavors = transferable.getTransferDataFlavors();
        List<DataFlavor> typedFlavors = Arrays.stream(allFlavors).filter(this.mimeType::matches).filter(it -> this.is((DataFlavor)it, representationClass)).filter(it -> !CustomDataSupport.isCustomDataFlavor(it)).collect(Collectors.toList());
        Optional<DataFlavor> charsetSpecific = this.findForCharset(typedFlavors);
        if (charsetSpecific.isPresent()) {
            return charsetSpecific;
        }
        if (typedFlavors.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(typedFlavors.get(0));
    }

    private Optional<DataFlavor> findForCharset(List<DataFlavor> flavors) {
        return flavors.stream().filter(flavor -> {
            String charsetParameter = flavor.getParameter("charset");
            return this.charset.displayName().equals(charsetParameter);
        }).findFirst();
    }

    private boolean is(DataFlavor flavor, Class<?> representationClass) {
        return flavor.getRepresentationClass().isAssignableFrom(representationClass);
    }
}

