/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal.menu;

import com.teamdev.jxbrowser.browser.internal.callback.ShowDropdownCallback;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.Rect;
import com.teamdev.jxbrowser.ui.internal.DropdownItem;
import com.teamdev.jxbrowser.ui.internal.Geometry;
import com.teamdev.jxbrowser.view.swing.BrowserView;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public final class Dropdown {
    private final BrowserView parent;
    private final JPopupMenu popupMenu;

    public Dropdown(BrowserView parent, List<DropdownItem> items, ShowDropdownCallback.Action action) {
        this.parent = parent;
        this.popupMenu = new JPopupMenu();
        this.popupMenu.addPopupMenuListener(new PopupMenuListenerImpl(parent, action));
        this.popupMenu.setLightWeightPopupEnabled(false);
        items.forEach(item -> this.addMenuItem((DropdownItem)item, action));
    }

    public void show(Rect bounds, double scaleFactor) {
        SwingUtilities.invokeLater(() -> {
            this.parent.setEnabled(false);
            Point location = this.locationOnScreen(bounds, scaleFactor);
            this.popupMenu.show(this.parent, location.x(), location.y());
        });
    }

    private Point locationOnScreen(Rect bounds, double scaleFactor) {
        Point origin = bounds.origin();
        Point location = Point.of((int)origin.x(), (int)(origin.y() + bounds.height()));
        location = Geometry.scaleDown((Point)location, (double)scaleFactor);
        return location;
    }

    private void addMenuItem(DropdownItem item, ShowDropdownCallback.Action action) {
        if (item.isOptgroup()) {
            JLabel label = new JLabel(item.label());
            label.setEnabled(false);
            this.popupMenu.add(label);
        } else {
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(item.label());
            menuItem.setEnabled(item.isEnabled());
            menuItem.setState(item.isChecked());
            menuItem.addActionListener(actionEvent -> {
                if (!action.isClosed()) {
                    action.select(item);
                }
                this.parent.setEnabled(true);
            });
            this.popupMenu.add(menuItem);
        }
    }

    private static final class PopupMenuListenerImpl
    implements PopupMenuListener {
        private final ShowDropdownCallback.Action action;
        private final JComponent parent;

        private PopupMenuListenerImpl(JComponent parent, ShowDropdownCallback.Action action) {
            this.parent = parent;
            this.action = action;
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            if (!this.action.isClosed()) {
                this.action.cancel();
                this.parent.setEnabled(true);
            }
        }
    }
}

