/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.browser.callback;

import com.teamdev.jxbrowser.browser.callback.BrowserAsyncCallback;
import com.teamdev.jxbrowser.callback.AsyncCallbackAction;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.download.Download;
import com.teamdev.jxbrowser.download.internal.DownloadImpl;
import com.teamdev.jxbrowser.download.internal.rpc.StartDownload;
import com.teamdev.jxbrowser.frame.Frame;
import com.teamdev.jxbrowser.frame.internal.FrameImpl;
import com.teamdev.jxbrowser.internal.rpc.DownloadId;
import com.teamdev.jxbrowser.internal.rpc.FilePath;
import com.teamdev.jxbrowser.internal.rpc.FrameId;
import com.teamdev.jxbrowser.internal.rpc.Protobuf;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Consumer;

public interface StartDownloadCallback
extends BrowserAsyncCallback<Params, Action> {

    public static final class Action
    extends AsyncCallbackAction<StartDownload.Response> {
        public Action(Consumer<StartDownload.Response> consumer) {
            super(consumer);
        }

        public void download(Path destFilePath) {
            Preconditions.checkNotNull(destFilePath);
            this.send(StartDownload.Response.newBuilder().setSaveTo(FilePath.newBuilder().setValue(destFilePath.toAbsolutePath().toString()).build()).build());
        }

        public void cancel() {
            this.send(StartDownload.Response.newBuilder().setCancel(Protobuf.empty()).build());
        }
    }

    public static interface Params {
        default public Download download() {
            DownloadId id = ((StartDownload.Request)this).getDownloadId();
            return DownloadImpl.of(id);
        }

        default public Optional<Frame> frame() {
            FrameId id = ((StartDownload.Request)this).getFrameId();
            return FrameImpl.find(id);
        }
    }
}

