/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.browser.callback;

import com.teamdev.jxbrowser.annotation.Immutable;
import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.callback.BrowserAsyncCallback;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.callback.AsyncCallbackAction;
import com.teamdev.jxbrowser.cast.MediaReceiver;
import com.teamdev.jxbrowser.cast.MediaReceivers;
import com.teamdev.jxbrowser.cast.PresentationRequest;
import com.teamdev.jxbrowser.cast.internal.MediaReceiverImpl;
import com.teamdev.jxbrowser.cast.internal.rpc.StartPresentation;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.internal.rpc.Protobuf;
import java.util.List;
import java.util.function.Consumer;

public interface StartPresentationCallback
extends BrowserAsyncCallback<Params, Action> {

    public static final class Action
    extends AsyncCallbackAction<StartPresentation.Response> {
        public Action(Consumer<StartPresentation.Response> consumer) {
            super(consumer);
        }

        public void start(MediaReceiver receiver) {
            this.send(StartPresentation.Response.newBuilder().setStart(((MediaReceiverImpl)receiver).id()).build());
        }

        public void cancel() {
            this.send(StartPresentation.Response.newBuilder().setCancel(Protobuf.empty()).build());
        }
    }

    public static interface Params {
        default public Browser browser() {
            return BrowserImpl.of(((StartPresentation.Request)this).getBrowserId());
        }

        default public MediaReceivers mediaReceivers() {
            return this.browser().profile().mediaCasting().mediaReceivers();
        }

        @Immutable
        default public List<MediaReceiver> list() {
            return this.mediaReceivers().list().stream().filter(receiver -> receiver.supports(this.presentationRequest())).collect(ImmutableList.toImmutableList());
        }

        default public PresentationRequest presentationRequest() {
            return ((StartPresentation.Request)this).getPresentationRequest();
        }
    }
}

