/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.card;

import com.teamdev.jxbrowser.card.CreditCardNetwork;
import com.teamdev.jxbrowser.card.internal.rpc.CreditCard;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import java.time.Month;
import java.time.YearMonth;

public interface CreditCard {
    public static Builder newBuilder(String number, YearMonth expirationDate) {
        Preconditions.checkNotNull(number);
        Preconditions.checkArgument(number.chars().allMatch(Character::isDigit), "The card number should consist solely of digits.");
        int expMonth = expirationDate.getMonthValue();
        int expYear = expirationDate.getYear();
        return new Builder(number, expMonth, expYear);
    }

    default public String cardholder() {
        return com.teamdev.jxbrowser.card.internal.rpc.CreditCard.cast(this).getCardholder();
    }

    default public String number() {
        return com.teamdev.jxbrowser.card.internal.rpc.CreditCard.cast(this).getNumber();
    }

    default public Month expirationMonth() {
        return Month.of(com.teamdev.jxbrowser.card.internal.rpc.CreditCard.cast(this).getExpirationMonth());
    }

    default public int expirationYear() {
        return com.teamdev.jxbrowser.card.internal.rpc.CreditCard.cast(this).getExpirationYear();
    }

    default public CreditCardNetwork network() {
        return com.teamdev.jxbrowser.card.internal.rpc.CreditCard.cast(this).getNetwork();
    }

    public static final class Builder {
        private final CreditCard.Builder builder;

        private Builder(String number, int expMonth, int expYear) {
            Preconditions.checkNotNull(number);
            this.builder = com.teamdev.jxbrowser.card.internal.rpc.CreditCard.newBuilder().setNumber(number).setExpirationMonth(expMonth).setExpirationYear(expYear);
        }

        public Builder cardholder(String cardholder) {
            Preconditions.checkNotNull(cardholder);
            this.builder.setCardholder(cardholder);
            return this;
        }

        public CreditCard build() {
            return this.builder.build();
        }
    }
}

