/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.deps.com.google.common.base;

import com.teamdev.jxbrowser.deps.com.google.common.base.CommonPattern;
import com.teamdev.jxbrowser.deps.com.google.common.base.JdkPattern;
import com.teamdev.jxbrowser.deps.com.google.common.base.PatternCompiler;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import java.util.logging.Logger;
import java.util.regex.Pattern;

final class Platform {
    private static final Logger logger = Logger.getLogger(Platform.class.getName());
    private static final PatternCompiler patternCompiler = Platform.loadPatternCompiler();

    private Platform() {
    }

    static CommonPattern compilePattern(String pattern) {
        Preconditions.checkNotNull(pattern);
        return patternCompiler.compile(pattern);
    }

    private static PatternCompiler loadPatternCompiler() {
        return new JdkPatternCompiler();
    }

    private static final class JdkPatternCompiler
    implements PatternCompiler {
        private JdkPatternCompiler() {
        }

        @Override
        public CommonPattern compile(String pattern) {
            return new JdkPattern(Pattern.compile(pattern));
        }
    }
}

