/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.deps.com.google.common.io;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.common.io.CharStreams;
import com.teamdev.jxbrowser.deps.com.google.common.io.Closer;
import com.teamdev.jxbrowser.deps.com.google.common.io.LineProcessor;
import com.teamdev.jxbrowser.deps.com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.io.Reader;

public abstract class CharSource {
    protected CharSource() {
    }

    public abstract Reader openStream() throws IOException;

    @CanIgnoreReturnValue
    public <T> T readLines(LineProcessor<T> processor) throws IOException {
        Preconditions.checkNotNull(processor);
        try (Closer closer = Closer.create();){
            Reader reader = closer.register(this.openStream());
            T t = CharStreams.readLines(reader, processor);
            return t;
        }
    }
}

