/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.dom.internal;

import com.teamdev.jxbrowser.ObjectClosedException;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableMap;
import com.teamdev.jxbrowser.deps.com.google.protobuf.BoolValue;
import com.teamdev.jxbrowser.deps.com.google.protobuf.StringValue;
import com.teamdev.jxbrowser.dom.Attribute;
import com.teamdev.jxbrowser.dom.Element;
import com.teamdev.jxbrowser.dom.ElementAttributes;
import com.teamdev.jxbrowser.dom.internal.ElementImpl;
import com.teamdev.jxbrowser.dom.internal.rpc.ElementStub;
import com.teamdev.jxbrowser.dom.internal.rpc.GetAttributeNodesRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.GetAttributeRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.GetAttributesRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.GetAttributesResponse;
import com.teamdev.jxbrowser.dom.internal.rpc.HasAttributeRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.NodeInfo;
import com.teamdev.jxbrowser.dom.internal.rpc.NodeInfoList;
import com.teamdev.jxbrowser.dom.internal.rpc.RemoveAttributeRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.SetAttributeRequest;
import com.teamdev.jxbrowser.frame.internal.DomContext;
import com.teamdev.jxbrowser.frame.internal.FrameImpl;
import com.teamdev.jxbrowser.internal.rpc.FrameId;
import com.teamdev.jxbrowser.internal.rpc.NodeId;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.string.StringPreconditions;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class ElementAttributesImpl
implements ElementAttributes {
    private final ServiceConnectionImpl<ElementStub> rpc;
    private final ElementImpl element;
    private final NodeId nodeId;
    private final FrameId frameId;
    private final DomContext domContext;

    ElementAttributesImpl(ElementImpl element, ServiceConnectionImpl<ElementStub> rpc, NodeInfo nodeInfo, DomContext domContext) {
        this.rpc = rpc;
        this.element = element;
        this.nodeId = nodeInfo.getNodeId();
        this.frameId = ((FrameImpl)element.frame()).id();
        this.domContext = domContext;
    }

    @Override
    public Element element() {
        return this.element;
    }

    @Override
    public int size() {
        this.checkElementNotClosed();
        GetAttributeNodesRequest request = GetAttributeNodesRequest.newBuilder().setFrameId(this.frameId).setNodeId(this.nodeId).build();
        return ((NodeInfoList)this.rpc.invoke(this.rpc.stub()::getAttributeNodes, request)).getNodeInfoList().size();
    }

    @Override
    public String get(String name) {
        StringPreconditions.checkNotNullEmptyOrBlank(name);
        this.checkElementNotClosed();
        GetAttributeRequest request = GetAttributeRequest.newBuilder().setFrameId(this.frameId).setNodeId(this.nodeId).setAttributeName(name).build();
        return ((StringValue)this.rpc.invoke(this.rpc.stub()::getAttribute, request)).getValue();
    }

    @Override
    public void put(String name, String value) {
        StringPreconditions.checkNotNullEmptyOrBlank(name);
        Preconditions.checkNotNull(value);
        this.checkElementNotClosed();
        SetAttributeRequest request = SetAttributeRequest.newBuilder().setFrameId(this.frameId).setNodeId(this.nodeId).setAttributeName(name).setAttributeValue(value).build();
        this.rpc.invoke(this.rpc.stub()::setAttribute, request);
    }

    @Override
    public void remove(String name) {
        StringPreconditions.checkNotNullEmptyOrBlank(name);
        this.checkElementNotClosed();
        RemoveAttributeRequest request = RemoveAttributeRequest.newBuilder().setFrameId(this.frameId).setNodeId(this.nodeId).setAttributeName(name).build();
        this.rpc.invoke(this.rpc.stub()::removeAttribute, request);
    }

    @Override
    public boolean contains(String name) {
        StringPreconditions.checkNotNullEmptyOrBlank(name);
        this.checkElementNotClosed();
        HasAttributeRequest request = HasAttributeRequest.newBuilder().setFrameId(this.frameId).setNodeId(this.nodeId).setAttributeName(name).build();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::hasAttribute, request)).getValue();
    }

    @Override
    public Map<String, String> asMap() {
        this.checkElementNotClosed();
        GetAttributesRequest request = GetAttributesRequest.newBuilder().setFrameId(this.frameId).setNodeId(this.nodeId).build();
        Map<String, String> map = ((GetAttributesResponse)this.rpc.invoke(this.rpc.stub()::getAttributes, request)).getAttributesMap();
        return ImmutableMap.copyOf(map);
    }

    @Override
    public List<Attribute> asNodes() {
        this.checkElementNotClosed();
        GetAttributeNodesRequest request = GetAttributeNodesRequest.newBuilder().setFrameId(this.frameId).setNodeId(this.nodeId).build();
        List<NodeInfo> nodesInfo = ((NodeInfoList)this.rpc.invoke(this.rpc.stub()::getAttributeNodes, request)).getNodeInfoList();
        List<Attribute> list = this.domContext.toNodes(nodesInfo, Attribute.class);
        return Collections.unmodifiableList(list);
    }

    private void checkElementNotClosed() {
        if (this.element.isClosed()) {
            throw new ObjectClosedException();
        }
    }
}

