/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.event.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.event.Event;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.internal.SubscriptionImpl;
import com.teamdev.jxbrowser.internal.Threads;
import com.teamdev.jxbrowser.logging.Logger;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public final class ObservableHelper<T extends Event> {
    private final Map<Class<? extends Event>, Set<Observer>> observers = new HashMap<Class<? extends Event>, Set<Observer>>();
    private final Map<Observer, SubscriptionImpl> subscriptions = new HashMap<Observer, SubscriptionImpl>();

    public <E extends T> SubscriptionImpl on(Class<E> eventClass, Observer<E> observer) {
        Preconditions.checkNotNull(eventClass);
        Preconditions.checkNotNull(observer);
        if (this.subscriptions.containsKey(observer)) {
            return this.subscriptions.get(observer);
        }
        if (!this.observers.containsKey(eventClass)) {
            this.observers.put(eventClass, new CopyOnWriteArraySet());
        }
        Set<Observer> observers = this.observers.get(eventClass);
        observers.add(observer);
        SubscriptionImpl newSubscription = this.createSubscription(eventClass, observer);
        this.subscriptions.put(observer, newSubscription);
        return newSubscription;
    }

    private <E extends T> SubscriptionImpl createSubscription(final Class<E> eventClass, final Observer<E> observer) {
        return new SubscriptionImpl(){

            @Override
            public void unsubscribe() {
                if (this.isUnsubscribed()) {
                    return;
                }
                ObservableHelper.this.subscriptions.remove(observer);
                ObservableHelper.this.observers.get(eventClass).remove(observer);
                super.unsubscribe();
            }
        };
    }

    public <E extends T> void notifyObservers(E event) {
        for (Class<? extends Event> eventClass : this.observers.keySet()) {
            if (!eventClass.isAssignableFrom(event.getClass())) continue;
            Set<Observer> observers = this.observers.get(eventClass);
            observers.forEach(observer -> ObservableHelper.notify(observer, event));
        }
    }

    private static <E extends Event> void notify(Observer<E> observer, E event) {
        try {
            observer.on(event);
        }
        catch (Exception e) {
            Threads.reportException(e);
            Logger.warn("An exception has been thrown during observers notification", e);
        }
    }
}

