/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.extensions.callback;

import com.teamdev.jxbrowser.annotation.Immutable;
import com.teamdev.jxbrowser.callback.AsyncCallbackAction;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.extensions.ExtensionPermission;
import com.teamdev.jxbrowser.extensions.callback.ExtensionsAsyncCallback;
import com.teamdev.jxbrowser.extensions.internal.rpc.InstallExtension;
import com.teamdev.jxbrowser.internal.rpc.Protobuf;
import java.util.List;
import java.util.function.Consumer;

public interface InstallExtensionCallback
extends ExtensionsAsyncCallback<Params, Action> {

    public static final class Action
    extends AsyncCallbackAction<InstallExtension.Response> {
        public Action(Consumer<InstallExtension.Response> consumer) {
            super(consumer);
        }

        public void install() {
            this.send(InstallExtension.Response.newBuilder().setInstall(Protobuf.empty()).build());
        }

        public void cancel() {
            this.send(InstallExtension.Response.newBuilder().setCancel(Protobuf.empty()).build());
        }
    }

    public static interface Params {
        default public String extensionId() {
            return InstallExtension.Request.cast(this).getExtensionId().getValue();
        }

        default public String extensionName() {
            return InstallExtension.Request.cast(this).getExtensionName();
        }

        default public String extensionVersion() {
            return InstallExtension.Request.cast(this).getExtensionVersion();
        }

        default public String extensionCrxFile() {
            return InstallExtension.Request.cast(this).getExtensionCrxFile();
        }

        @Immutable
        default public List<String> hosts() {
            return ImmutableList.copyOf(InstallExtension.Request.cast(this).getHostList());
        }

        @Immutable
        default public List<ExtensionPermission> permissions() {
            return ImmutableList.copyOf(InstallExtension.Request.cast(this).getPermissionsList());
        }
    }
}

