/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.frame.internal;

import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.browser.internal.RenderProcesses;
import com.teamdev.jxbrowser.frame.internal.FrameImpl;
import com.teamdev.jxbrowser.frame.internal.callback.CreateFrameCallback;
import com.teamdev.jxbrowser.frame.internal.callback.DeleteFrameCallback;
import com.teamdev.jxbrowser.frame.internal.rpc.CreateFrame;
import com.teamdev.jxbrowser.frame.internal.rpc.DeleteFrame;
import com.teamdev.jxbrowser.frame.internal.rpc.FrameCreated;
import com.teamdev.jxbrowser.frame.internal.rpc.FrameDeleted;
import com.teamdev.jxbrowser.frame.internal.rpc.FramesStub;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.rpc.RenderProcessId;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import java.util.Optional;

public final class Frames
extends CloseableImpl {
    private final ServiceConnectionImpl<FramesStub> rpc;

    public Frames(BrowserImpl browser) {
        this.rpc = new ServiceConnectionImpl<FramesStub>(browser.id(), browser.engine().connection(), FramesStub::new);
        this.rpc.set(CreateFrameCallback.class, params -> this.createFrame(browser, (CreateFrame.Request)params));
        this.rpc.set(DeleteFrameCallback.class, params -> this.deleteFrame(browser, (DeleteFrame.Request)params));
    }

    private CreateFrame.Response createFrame(BrowserImpl browser, CreateFrame.Request params) {
        FrameCreated event = params.getEvent();
        RenderProcessId id = event.getRenderProcessId();
        RenderProcesses processes = browser.engine().renderProcesses();
        processes.renderProcess(id).ifPresent(process -> {
            FrameImpl frame = FrameImpl.onEvent(browser, process, event);
            frame.register();
            browser.notifyObserversAsync(event);
        });
        return CreateFrame.Response.newBuilder().build();
    }

    private DeleteFrame.Response deleteFrame(BrowserImpl browser, DeleteFrame.Request params) {
        FrameDeleted event = params.getEvent();
        Optional<FrameImpl> frame = FrameImpl.findImpl(event.getFrameId());
        frame.ifPresent(f -> {
            f.close();
            browser.notifyObserversAsync(event, f::unregister);
        });
        return DeleteFrame.Response.newBuilder().build();
    }

    @Override
    public void close() {
        this.rpc.close();
        super.close();
    }

    public ServiceConnectionImpl<FramesStub> rpc() {
        return this.rpc;
    }
}

