/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.Closeable;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ForwardingMap;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import java.util.Map;

public final class CloseableMap<K, V extends Closeable>
extends ForwardingMap<K, V>
implements Closeable {
    private final CloseableImpl closeableSelf;
    private final Map<K, V> map;

    public static <K, V extends Closeable> CloseableMap<K, V> wrap(Map<K, V> delegateMap) {
        Preconditions.checkNotNull(delegateMap);
        return new CloseableMap<K, V>(delegateMap);
    }

    private CloseableMap(Map<K, V> map) {
        this.map = map;
        this.closeableSelf = new CloseableImpl();
    }

    @Override
    public void close() {
        this.closeableSelf.close();
        this.map.values().forEach(Closeable::close);
        this.map.clear();
    }

    @Override
    public boolean isClosed() {
        return this.closeableSelf.isClosed();
    }

    @Override
    protected Map<K, V> delegate() {
        Preconditions.checkState(!this.isClosed());
        return this.map;
    }
}

