/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.internal.BinariesListing;
import com.teamdev.jxbrowser.internal.BinaryVerifier;
import com.teamdev.jxbrowser.internal.ChromiumFile;
import com.teamdev.jxbrowser.logging.Logger;
import java.nio.file.Path;
import java.util.List;

final class JavaBinaryVerifier
implements BinaryVerifier {
    JavaBinaryVerifier() {
    }

    @Override
    public boolean verify(Path chromiumDir, List<BinariesListing> listings) {
        for (BinariesListing listing : listings) {
            Logger.debug("Using {0} listing...", listing.name());
            if (!this.verify(chromiumDir, listing)) continue;
            Logger.debug("Checking binaries integrity... [OK]");
            return true;
        }
        Logger.debug("Checking binaries integrity... [FAIL]");
        return false;
    }

    private boolean verify(Path chromiumDir, BinariesListing listing) {
        List<ChromiumFile> files = listing.files();
        for (ChromiumFile chromiumFile : files) {
            if (chromiumFile.checkIntegrity(chromiumDir)) continue;
            return false;
        }
        return true;
    }
}

